/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.gcreator.core.ClassLoading;
import org.gcreator.plugins.Plugin;
import org.gcreator.plugins.PluginCore;

public class PluginList {
    public static final String PLUGLIST = "./settings/pluglist";
    public static final PluginList stdlist = new PluginList("./settings/pluglist");
    public Vector<Plugin> plugins = new Vector();

    private PluginList() {
    }

    public PluginList(String location) {
        FileInputStream reader;
        File pluglist = new File(location);
        try {
            reader = new FileInputStream(pluglist);
        }
        catch (IOException e) {
            return;
        }
        Vector<String> lines = new Vector<String>();
        String curstring = "";
        try {
            int read;
            while ((read = reader.read()) != -1) {
                if (read == 13) continue;
                if (read == 10) {
                    lines.add(curstring);
                    curstring = "";
                    continue;
                }
                curstring = curstring + (char)read;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        curstring = null;
        boolean starter = false;
        Plugin curplugin = null;
        for (String line : lines) {
            if ((line = line.replace("#(.*)^", "")).equals("")) continue;
            if (!starter && !line.equals("[G-Creator Plugin List]")) break;
            if (!starter) {
                starter = true;
                continue;
            }
            if (curplugin == null && !line.equals("[~Plugin~]")) break;
            if (curplugin == null) {
                curplugin = new Plugin();
                continue;
            }
            if (line.equals("[~Plugin~]")) {
                this.plugins.add(curplugin);
                curplugin = new Plugin();
                continue;
            }
            if (line.matches("^Author=.*$")) {
                curplugin.authors.add(line.replaceAll("^Author=(.*)$", "$1"));
                continue;
            }
            if (line.matches("^File=.*$")) {
                curplugin.files.add(line.replaceAll("^File=(.*)$", "$1"));
                continue;
            }
            if (line.matches("^License=.*$")) {
                curplugin.licenseLocation = line.replaceAll("^License=(.*)$", "$1");
                continue;
            }
            if (line.matches("^Name=.*$")) {
                curplugin.name = line.replaceAll("^Name=(.*)$", "$1");
                continue;
            }
            if (line.matches("^Version=.*$")) {
                curplugin.version = line.replaceAll("^Version=(.*)$", "$1");
                continue;
            }
            if (line.matches("^Image=.*$")) {
                String fname;
                curplugin.img_loc = fname = "./plugins/" + line.replaceAll("^Image=(.*)$", "$1");
                if (new File(fname).exists() && !line.equals("Image=")) {
                    curplugin.image = new ImageIcon(fname);
                    continue;
                }
                curplugin.image = new ImageIcon(this.getClass().getResource("/org/gcreator/resources/plugin.png"));
                continue;
            }
            if (!line.matches("^Core=.*$")) continue;
            String t = line.replaceAll("^Core=(.*)$", "$1");
            try {
                curplugin.value = (PluginCore)ClassLoading.classLoader.loadClass(t).newInstance();
            }
            catch (Exception e) {}
        }
        if (curplugin != null) {
            this.plugins.add(curplugin);
        }
    }
}

