/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.IOException;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.DebugTokenStream;

public class DebugParser
extends Parser {
    protected DebugEventListener dbg = null;
    public boolean isCyclicDecision = false;

    public DebugParser(TokenStream input, DebugEventListener dbg) {
        super(new DebugTokenStream(input, dbg));
        this.setDebugListener(dbg);
    }

    public DebugParser(TokenStream input) {
        this(input, 49153);
    }

    public DebugParser(TokenStream input, int port) {
        super(new DebugTokenStream(input, null));
    }

    public void setDebugListener(DebugEventListener dbg) {
        if (this.input instanceof DebugTokenStream) {
            ((DebugTokenStream)this.input).setDebugListener(dbg);
        }
        this.dbg = dbg;
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void reportError(IOException e) {
        System.err.println(e);
        e.printStackTrace(System.err);
    }

    public void beginResync() {
        this.dbg.beginResync();
    }

    public void endResync() {
        this.dbg.endResync();
    }

    public void beginBacktrack(int level) {
        this.dbg.beginBacktrack(level);
    }

    public void endBacktrack(int level, boolean successful) {
        this.dbg.endBacktrack(level, successful);
    }

    public void recoverFromMismatchedToken(IntStream input, RecognitionException mte, int ttype, BitSet follow) throws RecognitionException {
        System.err.println("recoverFromMismatchedToken");
        this.dbg.recognitionException(mte);
        super.recoverFromMismatchedToken(input, mte, ttype, follow);
    }

    public void recoverFromMismatchedSet(IntStream input, RecognitionException mte, BitSet follow) throws RecognitionException {
        this.dbg.recognitionException(mte);
        super.recoverFromMismatchedSet(input, mte, follow);
    }
}

