/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener dbg, TreeAdaptor adaptor) {
        this.dbg = dbg;
        this.adaptor = adaptor;
    }

    public Object create(Token payload) {
        Object node = this.adaptor.create(payload);
        this.dbg.createNode(node, payload);
        return node;
    }

    public Object dupTree(Object tree) {
        return this.adaptor.dupTree(tree);
    }

    public Object dupNode(Object treeNode) {
        return this.adaptor.dupNode(treeNode);
    }

    public Object nil() {
        Object node = this.adaptor.nil();
        this.dbg.nilNode(node);
        return node;
    }

    public boolean isNil(Object tree) {
        return this.adaptor.isNil(tree);
    }

    public void addChild(Object t, Object child) {
        if (t == null || child == null) {
            return;
        }
        this.adaptor.addChild(t, child);
        this.dbg.addChild(t, child);
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Object n = this.adaptor.becomeRoot(newRoot, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    public Object rulePostProcessing(Object root) {
        return this.adaptor.rulePostProcessing(root);
    }

    public void addChild(Object t, Token child) {
        Object n = this.create(child);
        this.addChild(t, n);
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        Object n = this.create(newRoot);
        this.adaptor.becomeRoot(n, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n;
    }

    public Object create(int tokenType, Token fromToken) {
        Object node = this.adaptor.create(tokenType, fromToken);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        Object node = this.adaptor.create(tokenType, fromToken, text);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, String text) {
        Object node = this.adaptor.create(tokenType, text);
        this.dbg.createNode(node);
        return node;
    }

    public int getType(Object t) {
        return this.adaptor.getType(t);
    }

    public void setType(Object t, int type) {
        this.adaptor.setType(t, type);
    }

    public String getText(Object t) {
        return this.adaptor.getText(t);
    }

    public void setText(Object t, String text) {
        this.adaptor.setText(t, text);
    }

    public Token getToken(Object t) {
        return this.adaptor.getToken(t);
    }

    public void setTokenBoundaries(Object t, Token startToken, Token stopToken) {
        this.adaptor.setTokenBoundaries(t, startToken, stopToken);
        if (t != null && startToken != null && stopToken != null) {
            this.dbg.setTokenBoundaries(t, startToken.getTokenIndex(), stopToken.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object t) {
        return this.adaptor.getTokenStartIndex(t);
    }

    public int getTokenStopIndex(Object t) {
        return this.adaptor.getTokenStopIndex(t);
    }

    public Object getChild(Object t, int i) {
        return this.adaptor.getChild(t, i);
    }

    public int getChildCount(Object t) {
        return this.adaptor.getChildCount(t);
    }

    public int getUniqueID(Object node) {
        return this.adaptor.getUniqueID(node);
    }

    public DebugEventListener getDebugEventListener() {
        return this.dbg;
    }

    public void setDebugEventListener(DebugEventListener dbg) {
        this.dbg = dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

