/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.actions;

import java.awt.Color;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.gcreator.actions.ActionPattern;
import org.gcreator.editors.ActorEditor;
import org.gcreator.editors.TimelineEditor;
import org.gcreator.fileclass.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action
implements Serializable {
    static final long serialVersionUID = 1L;
    public ActionPattern pattern;
    private JComponent panel;
    public Project project;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("pattern", ActionPattern.class)};

    public Action(ActionPattern pattern) {
        this.pattern = pattern;
        this.project = null;
        if (pattern != null) {
            this.panel = pattern.createNewPanel(this, null);
        }
    }

    public Action(ActorEditor editor, ActionPattern pattern) {
        this.pattern = pattern;
        this.project = editor.project;
        if (pattern != null) {
            this.panel = pattern.createNewPanel(this, this.project);
        }
    }

    public Action(TimelineEditor editor, ActionPattern pattern) {
        this.pattern = pattern;
        this.project = editor.project;
        if (pattern != null) {
            this.panel = pattern.createNewPanel(this, this.project);
        }
    }

    public ImageIcon getImage() {
        return this.pattern.getStandardImage();
    }

    public String getLabel() {
        return this.pattern.getStandardText(this.getPanel());
    }

    public void setPanel(JPanel panel) {
        this.panel = panel;
    }

    public JComponent getPanel() {
        if (this.panel == null) {
            this.panel = this.pattern.createNewPanel(this, this.project);
            this.pattern.load(this.panel);
        }
        return this.panel;
    }

    public String getGCL() {
        return this.pattern.generateGCL(this.getPanel());
    }

    public Color getBackground(JList list) {
        return this.pattern.getBackground(list);
    }

    public Color getForeground(JList list) {
        return this.pattern.getForeground(list);
    }

    public Color getSelectedBackground(JList list) {
        return this.pattern.getSelectedBackground(list);
    }

    public Color getSelectedForeground(JList list) {
        return this.pattern.getSelectedForeground(list);
    }

    public String writeXml() {
        String xml = "<action>\n";
        xml = xml + "<type>";
        xml = xml + this.pattern.getClass().getName();
        xml = xml + "</type>";
        xml = xml + this.pattern.writeXml(this.panel);
        xml = xml + "</action>\n";
        return xml;
    }

    public Action clone() {
        Action a = new Action(this.pattern);
        return a;
    }

    public boolean indents(Vector<Action> indented, Vector<Action> unindented, JList list, boolean selected) {
        return this.pattern.indents(this.panel, indented, unindented, list, selected);
    }

    public boolean unindents(Vector<Action> indented, Vector<Action> unindented, JList list, boolean selected) {
        return this.pattern.unindents(this.panel, indented, unindented, list, selected);
    }

    public boolean indentsNext(Vector<Action> indented, Vector<Action> unindented, JList list, boolean selected) {
        return this.pattern.indentsNext(this.panel, indented, unindented, list, selected);
    }

    public boolean unindentsNext(Vector<Action> indented, Vector<Action> unindented, JList list, boolean selected) {
        return this.pattern.unindentsNext(this.panel, indented, unindented, list, selected);
    }
}

