/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gcreator.components.IconListElement;

public class IconList
extends JComponent {
    private int columns = 3;
    private Vector<IconListElement> elements = new Vector();
    private int columnWidth = 120;
    private int columnHeight = 120;
    private int selIndex = 0;
    private int wgap = 10;
    private int hgap = 10;
    private Color selectionColor = Color.BLUE;

    public IconList() {
        this.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent evt) {
            }

            public void mouseExited(MouseEvent evt) {
            }

            public void mousePressed(MouseEvent evt) {
            }

            public void mouseReleased(MouseEvent evt) {
                IconList.this.mouseAction(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                IconList.this.mouseAction(evt);
            }
        });
    }

    public void mouseAction(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        int b = evt.getButton();
        if (b != 1) {
            return;
        }
        y -= this.hgap;
        if ((x -= this.wgap) % (this.columnWidth + this.wgap) > this.columnWidth) {
            return;
        }
        if (y % (this.columnHeight + this.hgap) > this.columnHeight) {
            return;
        }
        int t = (y /= this.columnHeight + this.hgap) * this.columns + (x /= this.columnWidth + this.wgap);
        if (t < this.countVisibleElements()) {
            this.selIndex = t;
            this.repaint();
        }
    }

    public int countVisibleElements() {
        int cf = 0;
        Enumeration<IconListElement> e = this.elements.elements();
        while (e.hasMoreElements()) {
            IconListElement element = e.nextElement();
            if (!element.visible) continue;
            ++cf;
        }
        return cf;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.updateUI();
    }

    public int getWidthGap() {
        return this.wgap;
    }

    public int getHeightGap() {
        return this.hgap;
    }

    public void setWidthGap(int wgap) {
        this.wgap = wgap;
        this.updateUI();
    }

    public void setHeightGap(int hgap) {
        this.hgap = hgap;
        this.updateUI();
    }

    public int getSelectedIndex() {
        return this.selIndex;
    }

    public void setSelectedIndex(int index) {
        this.selIndex = index;
        this.updateUI();
    }

    public String getSelectedText() {
        return this.getTextAt(this.getSelectedIndex(), true);
    }

    public Object getSelectedExtraContent() {
        return this.getExtraContentAt(this.getSelectedIndex(), true);
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getColumnHeight() {
        return this.columnHeight;
    }

    public void setColumnWidth(int dim) {
        this.columnWidth = dim;
        this.updateUI();
    }

    public void setColumnHeight(int dim) {
        this.columnHeight = dim;
        this.updateUI();
    }

    public void addElement(String text, ImageIcon img, Object plus) {
        this.elements.add(new IconListElement(text, img, plus));
    }

    public void removeElement(int i) {
        this.elements.removeElementAt(i);
        this.elements.trimToSize();
        this.updateUI();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.updateUI();
    }

    public Object getExtraContentAt(int i) {
        return this.getExtraContentAt(i, false);
    }

    public Object getExtraContentAt(int i, boolean visibleonly) {
        if (i < 0 || i >= this.elements.size()) {
            return null;
        }
        int x = i;
        if (visibleonly) {
            x = 0;
            Enumeration<IconListElement> e = this.elements.elements();
            while (e.hasMoreElements()) {
                if (x == i) {
                    return e.nextElement().plus;
                }
                if (!e.nextElement().visible) continue;
                ++x;
            }
            return null;
        }
        return this.elements.get((int)x).plus;
    }

    public String getTextAt(int i) {
        return this.getTextAt(i, false);
    }

    public String getTextAt(int i, boolean visibleonly) {
        if (i < 0 || i >= this.elements.size()) {
            return null;
        }
        int x = i;
        if (visibleonly) {
            x = 0;
            Enumeration<IconListElement> e = this.elements.elements();
            while (e.hasMoreElements()) {
                if (x == i) {
                    return e.nextElement().text;
                }
                if (!e.nextElement().visible) continue;
                ++x;
            }
            return null;
        }
        return this.elements.get((int)x).text;
    }

    public ImageIcon getImageAt(int i) {
        if (i < 0 || i >= this.elements.size()) {
            return null;
        }
        return this.elements.get((int)i).img;
    }

    public boolean isElementVisible(int i) {
        if (i < 0 || i >= this.elements.size()) {
            return false;
        }
        return this.elements.get((int)i).visible;
    }

    public boolean elementExists(int i) {
        return i >= 0 && i < this.elements.size();
    }

    public void setElementVisible(int i, boolean visible) {
        if (i < 0 || i >= this.elements.size()) {
            return;
        }
        this.elements.get((int)i).visible = visible;
        this.updateUI();
    }

    public void setElementText(int i, String text) {
        if (i < 0 || i >= this.elements.size()) {
            return;
        }
        this.elements.get((int)i).text = text;
        this.updateUI();
    }

    public void setElementImage(int i, ImageIcon img) {
        if (i < 0 || i >= this.elements.size()) {
            return;
        }
        this.elements.get((int)i).img = img;
        this.updateUI();
    }

    public void setElementExtraContent(int i, Object plus) {
        if (i < 0 || i >= this.elements.size()) {
            return;
        }
        this.elements.get((int)i).plus = plus;
        this.updateUI();
    }

    public int calcRows() {
        int cf = 0;
        Enumeration<IconListElement> e = this.elements.elements();
        while (e.hasMoreElements()) {
            IconListElement element = e.nextElement();
            if (!element.visible) continue;
            ++cf;
        }
        if (cf % this.columns != 0) {
            return cf / this.columns + 1;
        }
        return cf / this.columns;
    }

    public Dimension getPreferredSize() {
        int rows = this.calcRows();
        return new Dimension(this.columnWidth * this.columns + (this.columns + 1) * this.wgap, this.columnHeight * rows + (rows + 1) * this.hgap);
    }

    private void paintComponent(Graphics g, IconListElement element, int r, int c, int i) {
        int wstart = c * this.columnWidth + (c + 1) * this.wgap;
        int hstart = r * this.columnHeight + (r + 1) * this.hgap;
        if (i == this.selIndex) {
            g.setColor(Color.BLUE);
            g.drawRect(wstart + 1, hstart + 1, this.columnWidth - 2, this.columnHeight - 2);
        } else {
            g.setColor(Color.GRAY);
        }
        g.drawRect(wstart, hstart, this.columnWidth, this.columnHeight);
        int imgw = this.columnWidth - 4;
        int imgh = this.columnHeight - 22;
        ImageIcon img = element.img;
        if (img == null) {
            return;
        }
        int iconh = img.getIconHeight();
        int iconw = img.getIconWidth();
        if (iconw >= imgw && iconh >= imgh) {
            g.drawImage(img.getImage(), wstart + 2, hstart + 2, imgw, imgh, img.getImageObserver());
        }
        if (iconw >= imgw && iconh < imgh) {
            g.drawImage(img.getImage(), wstart + 2, hstart + 2 + (imgh - iconh) / 2, imgw, iconh, img.getImageObserver());
        }
        if (img.getIconWidth() < imgw && img.getIconHeight() >= imgh) {
            g.drawImage(img.getImage(), wstart + 2 + (imgw - iconw) / 2, hstart + 2, iconw, imgh, img.getImageObserver());
        }
        if (img.getIconWidth() < imgw && img.getIconHeight() < imgh) {
            g.drawImage(img.getImage(), wstart + 2 + (imgw - iconw) / 2, hstart + 2 + (imgh - iconh) / 2, iconw, img.getIconHeight(), img.getImageObserver());
        }
        g.drawString(element.text, wstart + 3, hstart + imgh + 16);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int r = 0;
        int c = 0;
        int i = 0;
        Enumeration<IconListElement> e = this.elements.elements();
        while (e.hasMoreElements()) {
            IconListElement element = e.nextElement();
            if (element.visible) {
                this.paintComponent(g, element, r, c, i);
                if (++c >= this.columns) {
                    c -= this.columns;
                    ++r;
                }
            }
            ++i;
        }
    }
}

