/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gcreator.components.popupmenus.PopupListener;
import org.gcreator.components.popupmenus.ScenePopupMenu;
import org.gcreator.core.Colorfeel;
import org.gcreator.editors.SceneEditor;
import org.gcreator.fileclass.res.Actor;
import org.gcreator.fileclass.res.Resource;
import org.gcreator.fileclass.res.Scene;
import org.gcreator.fileclass.res.Sprite;
import org.gcreator.fileclass.res.Tileset;
import org.gcreator.units.ActorInScene;
import org.gcreator.units.BackgroundInScene;
import org.gcreator.units.Tile;

public class ScenePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    SceneEditor root;
    ScenePopupMenu popup;

    public ScenePanel(SceneEditor root) {
        this.root = root;
        this.addMouseListener(this);
        this.popup = new ScenePopupMenu(root);
        this.addMouseListener(new PopupListener((JComponent)this, this.popup));
        this.addMouseMotionListener(this);
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            int a = this.root.mode();
            if (a == 0) {
                return;
            }
            int x = (int)((double)evt.getX() * this.root.getZoom());
            int y = (int)((double)evt.getY() * this.root.getZoom());
            if (a == 2) {
                this.eraseActorsAt(x, y);
            }
            if (a == 1) {
                this.addActorAt(x, y);
            }
            if (a == 3) {
                this.addTileAt(x, y);
            }
            this.root.updateScroll();
        }
    }

    public void eraseActorsAt(int x, int y) {
        this.root.eraseActorsAt(x, y);
    }

    public void eraseActorsAt(Rectangle r) {
        this.root.eraseActorsAt(r);
    }

    public void addActorAt(int x, int y) {
        Resource s;
        ActorInScene act = this.root.makeNewActor(x, y);
        if (this.root.eraseActorsBelow()) {
            s = (Sprite)act.Sactor.value;
            this.root.eraseActorsAt(new Rectangle(x, y, ((Sprite)s).getImageAt(0).getIconWidth(), ((Sprite)s).getImageAt(0).getIconHeight()));
        }
        if (this.root.snapToGrid()) {
            s = (Scene)this.root.file.value;
            if (x % ((Scene)s).snapX > ((Scene)s).snapX / 2) {
                x /= ((Scene)s).snapX;
                ++x;
                x *= ((Scene)s).snapX;
            } else {
                x /= ((Scene)s).snapX;
                x *= ((Scene)s).snapX;
            }
            if (y % ((Scene)s).snapY > ((Scene)s).snapY / 2) {
                y /= ((Scene)s).snapY;
                ++y;
                y *= ((Scene)s).snapY;
            } else {
                y /= ((Scene)s).snapY;
                y *= ((Scene)s).snapY;
            }
        }
        ((Scene)this.root.file.value).actors.add(act);
    }

    public void addTileAt(int x, int y) {
        Tile tile = this.root.makeNewTile(x, y);
        ((Scene)this.root.file.value).tiles.add(tile);
    }

    public int getWidth() {
        double zoom = this.root.getZoom();
        return (int)((double)this.root.getMapWidth() / zoom + (double)(this.root.isGridVisible() && !this.root.isIsometric() ? 1 : 0));
    }

    public int getHeight() {
        double zoom = this.root.getZoom();
        return (int)((double)this.root.getMapHeight() / zoom + (double)(this.root.isGridVisible() && !this.root.isIsometric() ? 1 : 0));
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public int getMinimumDepth() {
        Object a;
        int result = Integer.MAX_VALUE;
        Scene scn = (Scene)this.root.file.value;
        Enumeration e = scn.actors.elements();
        while (e.hasMoreElements()) {
            a = (ActorInScene)e.nextElement();
            Actor b = (Actor)((ActorInScene)a).Sactor.value;
            if (b.depth >= result) continue;
            result = b.depth;
        }
        e = scn.tiles.elements();
        while (e.hasMoreElements()) {
            a = (Tile)e.nextElement();
            if (((Tile)a).depth >= result) continue;
            result = ((Tile)a).depth;
        }
        return result;
    }

    public int getMaximumDepth() {
        Object a;
        int result = Integer.MIN_VALUE;
        Scene scn = (Scene)this.root.file.value;
        Enumeration e = scn.actors.elements();
        while (e.hasMoreElements()) {
            a = (ActorInScene)e.nextElement();
            Actor b = (Actor)((ActorInScene)a).Sactor.value;
            if (b.depth <= result) continue;
            result = b.depth;
        }
        e = scn.tiles.elements();
        while (e.hasMoreElements()) {
            a = (Tile)e.nextElement();
            if (((Tile)a).depth <= result) continue;
            result = ((Tile)a).depth;
        }
        return result;
    }

    public int getNextDepth(int Depth) {
        Object a;
        int result = Integer.MIN_VALUE;
        Scene scn = (Scene)this.root.file.value;
        Enumeration e = scn.actors.elements();
        while (e.hasMoreElements()) {
            a = (ActorInScene)e.nextElement();
            Actor b = (Actor)((ActorInScene)a).Sactor.value;
            if (b.depth <= result || b.depth >= Depth) continue;
            b.depth = result;
        }
        e = scn.tiles.elements();
        while (e.hasMoreElements()) {
            a = (Tile)e.nextElement();
            if (((Tile)a).depth <= result || ((Tile)a).depth >= Depth) continue;
            ((Tile)a).depth = result;
        }
        return result;
    }

    public void update(Graphics g) {
        super.update(g);
        super.setSize(this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawField(g);
        this.drawActors(g);
        if (this.root.isGridVisible()) {
            this.drawGrid(g);
        }
    }

    public void drawActors(Graphics g) {
        Scene scn = (Scene)this.root.file.value;
        if (scn.actors.isEmpty() && scn.tiles.isEmpty()) {
            return;
        }
        int dep = this.getMaximumDepth();
        int mindep = this.getMinimumDepth();
        while (dep >= mindep) {
            Object ascn;
            Enumeration e = scn.actors.elements();
            while (e.hasMoreElements()) {
                ascn = (ActorInScene)e.nextElement();
                Actor b = (Actor)((ActorInScene)ascn).Sactor.value;
                if (b.depth != dep) continue;
                try {
                    Sprite f = (Sprite)b.sprite.value;
                    ImageIcon h = f.getImageAt(0);
                    if (h == null) continue;
                    g.drawImage(h.getImage(), (int)((double)(((ActorInScene)ascn).x - f.originX) / this.root.getZoom()), (int)((double)(((ActorInScene)ascn).y - f.originY) / this.root.getZoom()), (int)((double)h.getIconWidth() / this.root.getZoom()), (int)((double)h.getIconHeight() / this.root.getZoom()), h.getImageObserver());
                }
                catch (NullPointerException ex) {}
            }
            e = scn.tiles.elements();
            while (e.hasMoreElements()) {
                ascn = (Tile)e.nextElement();
                if (((Tile)ascn).depth != dep) continue;
                try {
                    ImageIcon h = ((Tile)ascn).getTilesetImage();
                    if (h == null) continue;
                    g.drawImage(h.getImage(), (int)((double)((Tile)ascn).dx / this.root.getZoom()), (int)((double)((Tile)ascn).dy / this.root.getZoom()), (int)((double)((Tile)ascn).width / this.root.getZoom()), (int)((double)((Tile)ascn).height / this.root.getZoom()), ((Tile)ascn).sx + ((Tileset)((Tile)ascn).tileset.value).startx, ((Tile)ascn).sy + ((Tileset)((Tile)ascn).tileset.value).starty, ((Tile)ascn).width, ((Tile)ascn).height, h.getImageObserver());
                }
                catch (NullPointerException ex) {}
            }
            if (dep <= mindep) break;
            dep = this.getNextDepth(dep);
        }
    }

    public void drawField(Graphics g) {
        g.setColor(this.root.getMapBGColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            Scene scn = (Scene)this.root.file.value;
            for (Object o : scn.backgrounds) {
                this.drawBackground(g, (BackgroundInScene)o);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void drawBackground(Graphics g, BackgroundInScene bg) {
        block8: {
            int vrep;
            int hrep;
            ImageIcon i;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            i = (ImageIcon)bg.image.value;
                                            if (i == null) {
                                                return;
                                            }
                                            hrep = bg.hmode;
                                            vrep = bg.vmode;
                                            if (hrep != 0 || vrep != 0) break block7;
                                            g.drawImage(i.getImage(), 0, 0, (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                                            break block8;
                                        }
                                        if (hrep != 2 || vrep != 0) break block9;
                                        g.drawImage(i.getImage(), 0, 0, (int)((double)((Scene)this.root.file.value).width / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                                        break block8;
                                    }
                                    if (hrep != 2 || vrep != 2) break block10;
                                    g.drawImage(i.getImage(), 0, 0, (int)((double)((Scene)this.root.file.value).width / this.root.getZoom()), (int)((double)((Scene)this.root.file.value).height / this.root.getZoom()), i.getImageObserver());
                                    break block8;
                                }
                                if (hrep != 0 || vrep != 2) break block11;
                                g.drawImage(i.getImage(), 0, 0, (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)((Scene)this.root.file.value).height / this.root.getZoom()), i.getImageObserver());
                                break block8;
                            }
                            if (hrep != 1 || vrep != 0) break block12;
                            int j = 0;
                            while (j * i.getIconWidth() < ((Scene)this.root.file.value).width) {
                                g.drawImage(i.getImage(), (int)((double)(j * i.getIconWidth()) / this.root.getZoom()), 0, (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                                ++j;
                            }
                            break block8;
                        }
                        if (hrep != 1 || vrep != 2) break block13;
                        int j = 0;
                        while (j * i.getIconWidth() < ((Scene)this.root.file.value).width) {
                            g.drawImage(i.getImage(), (int)((double)(j * i.getIconWidth()) / this.root.getZoom()), 0, (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)((Scene)this.root.file.value).height / this.root.getZoom()), i.getImageObserver());
                            ++j;
                        }
                        break block8;
                    }
                    if (hrep != 0 || vrep != 1) break block14;
                    int j = 0;
                    while (j * i.getIconHeight() < ((Scene)this.root.file.value).height) {
                        g.drawImage(i.getImage(), 0, (int)((double)(j * i.getIconHeight()) / this.root.getZoom()), (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                        ++j;
                    }
                    break block8;
                }
                if (hrep != 2 || vrep != 1) break block15;
                int j = 0;
                while (j * i.getIconHeight() < ((Scene)this.root.file.value).height) {
                    g.drawImage(i.getImage(), 0, (int)((double)(j * i.getIconHeight()) / this.root.getZoom()), (int)((double)((Scene)this.root.file.value).width / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                    ++j;
                }
                break block8;
            }
            if (hrep != 1 || vrep != 1) break block8;
            int j = 0;
            while (j * i.getIconWidth() < ((Scene)this.root.file.value).width) {
                int k = 0;
                while (k * i.getIconHeight() < ((Scene)this.root.file.value).height) {
                    g.drawImage(i.getImage(), (int)((double)(j * i.getIconWidth()) / this.root.getZoom()), (int)((double)(k * i.getIconHeight()) / this.root.getZoom()), (int)((double)i.getIconWidth() / this.root.getZoom()), (int)((double)i.getIconHeight() / this.root.getZoom()), i.getImageObserver());
                    ++k;
                }
                ++j;
            }
        }
    }

    public void drawGrid(Graphics g) {
        Color c = this.root.getMapBGColor();
        int k = c.getRed() + c.getBlue() + c.getGreen();
        if ((k /= 3) > 150) {
            g.setColor(Colorfeel.GridDarkColor);
        } else {
            g.setColor(Colorfeel.GridLightColor);
        }
        int truew = this.root.getMapWidth();
        int trueh = this.root.getMapHeight();
        int snapx = this.root.getSnapX();
        int snapy = this.root.getSnapY();
        double zoom = this.root.getZoom();
        if (zoom == 0.0) {
            zoom = 0.5;
        }
        if (!this.root.isIsometric()) {
            int i;
            for (i = 0; i <= truew / snapx; ++i) {
                g.drawLine((int)((double)(i * snapx) / zoom), 0, (int)((double)(i * snapx) / zoom), this.getHeight());
            }
            for (i = 0; i <= trueh / snapy; ++i) {
                g.drawLine(0, (int)((double)(i * snapy) / zoom), this.getWidth(), (int)((double)(i * snapy) / zoom));
            }
        } else if (truew / snapx >= trueh / snapy) {
            int i;
            for (i = 0 - truew / snapx; i <= truew / snapx; ++i) {
                g.drawLine((int)((double)(i * snapx) / zoom), 0, (int)((double)(i * snapx) / zoom) + this.getHeight(), this.getHeight());
            }
            for (i = 0 - truew / snapx; i <= truew / snapx; ++i) {
                g.drawLine(this.getWidth(), (int)((double)(i * snapy) / zoom), 0, (int)((double)(i * snapy) / zoom) + this.getWidth());
            }
        } else {
            int i;
            for (i = 0 - trueh / snapy - snapy / 2; i <= trueh / snapy + snapy / 2; ++i) {
                g.drawLine((int)((double)(i * snapx) / zoom), 0, (int)((double)(i * snapx) / zoom) + this.getHeight(), this.getHeight());
            }
            for (i = 0 - trueh / snapy - snapy / 2; i <= trueh / snapy + snapy / 2; ++i) {
                g.drawLine(this.getWidth(), (int)((double)(i * snapy) / zoom), 0, (int)((double)(i * snapy) / zoom) + this.getWidth());
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent evt) {
        double zoom = this.root.getZoom();
        this.root.BottomLeft.setText("X:" + (int)((double)evt.getX() * zoom) + " Y:" + (int)((double)evt.getY() * zoom));
    }
}

