/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gcreator.editors.SceneEditor;
import org.gcreator.fileclass.res.Tileset;

public class TileChooser
extends JComponent {
    private SceneEditor sceneeditor;

    public TileChooser(SceneEditor editor) {
        this.sceneeditor = editor;
    }

    public Tileset getSourceTileset() {
        try {
            return this.sceneeditor.getTileset();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ImageIcon getSourceImage() {
        Tileset t = this.getSourceTileset();
        if (t == null) {
            return null;
        }
        return t.getImage();
    }

    public int getPreferredWidth() {
        int w = 0;
        try {
            w = this.getSourceImage().getIconWidth();
        }
        catch (NullPointerException e) {
            return 0;
        }
        return w -= this.getSourceTileset().startx;
    }

    public int getPreferredHeight() {
        int h = 0;
        try {
            h = this.getSourceImage().getIconHeight();
        }
        catch (NullPointerException e) {
            return 0;
        }
        return h;
    }

    public int getWidth() {
        return this.getPreferredWidth();
    }

    public int getHeight() {
        return this.getPreferredHeight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public void paint(Graphics g) {
        ImageIcon img = this.getSourceImage();
        g.clearRect(0, 0, this.getPreferredWidth(), this.getPreferredHeight());
        if (img == null) {
            return;
        }
        g.drawImage(img.getImage(), 0, 0, img.getImageObserver());
        int x = (Integer)this.sceneeditor.jSpinner13.getValue();
        int y = (Integer)this.sceneeditor.jSpinner14.getValue();
        int w = (Integer)this.sceneeditor.jSpinner15.getValue();
        int h = (Integer)this.sceneeditor.jSpinner16.getValue();
        g.setColor(Color.WHITE);
        g.drawRect(x - 2, y - 2, w + 4, h + 4);
        g.drawRect(x, y, w, h);
        g.setColor(Color.BLACK);
        g.drawRect(x - 1, y - 1, w + 2, h + 2);
    }
}

