/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.datatransfer.Transferable;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gcreator.components.impl.WorkspaceCellRenderer;
import org.gcreator.core.gcreator;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.Group;
import org.gcreator.units.ObjectNode;

public class WorkspaceTree
extends JTree {
    public WorkspaceTree(TreeNode root) {
        super(root);
        this.setScrollsOnExpand(true);
        int ver = Integer.parseInt(gcreator.getJavaVersion().replaceAll("1\\.([0-9])\\..*", "$1"));
        if (ver >= 6) {
            this.setDragEnabled(true);
            this.setDropMode(DropMode.ON_OR_INSERT);
        }
        this.getSelectionModel().setSelectionMode(1);
        try {
            if (ver >= 6) {
                this.setDropMode(DropMode.ON_OR_INSERT);
                this.setTransferHandler(new TransferHandler(){

                    protected Transferable createTransferable(JComponent c) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)WorkspaceTree.this.getLastSelectedPathComponent();
                        if (!(node instanceof ObjectNode)) {
                            return null;
                        }
                        ObjectNode f = (ObjectNode)node;
                        if (f.object instanceof GFile) {
                            System.out.println("" + ((GFile)f.object).name);
                            return (GFile)f.object;
                        }
                        return null;
                    }

                    public int getSourceActions(JComponent c) {
                        return 2;
                    }

                    public boolean canImport(TransferHandler.TransferSupport support) {
                        TreePath drop = ((JTree.DropLocation)support.getDropLocation()).getPath();
                        if (drop == null) {
                            return false;
                        }
                        if (!(drop.getLastPathComponent() instanceof ObjectNode)) {
                            return false;
                        }
                        ObjectNode dropNode = (ObjectNode)drop.getLastPathComponent();
                        ObjectNode dragNode = (ObjectNode)((JTree)support.getComponent()).getLastSelectedPathComponent();
                        if (dropNode.object instanceof Group) {
                            return ((Group)dropNode.object).allowsFileType(((GFile)dragNode.object).type);
                        }
                        return false;
                    }

                    public boolean importData(TransferHandler.TransferSupport support) {
                        if (!this.canImport(support)) {
                            return false;
                        }
                        JTree.DropLocation drop = (JTree.DropLocation)support.getDropLocation();
                        int dropIndex = drop.getChildIndex();
                        ObjectNode dropNode = (ObjectNode)drop.getPath().getLastPathComponent();
                        ObjectNode dragNode = (ObjectNode)((JTree)support.getComponent()).getLastSelectedPathComponent();
                        if (dropIndex == -1) {
                            dropIndex = dropNode.getChildCount();
                        }
                        if (dropNode == dragNode.getParent() && dropIndex > dragNode.getParent().getIndex(dragNode)) {
                            --dropIndex;
                        }
                        dropNode.insert(dragNode, dropIndex);
                        WorkspaceTree.this.expandPath(new TreePath(dropNode.getPath()));
                        WorkspaceTree.this.updateUI();
                        return true;
                    }
                });
            } else {
                System.out.println(ver);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.setCellRenderer(new WorkspaceCellRenderer());
        this.expandRow(0);
    }
}

