/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.editors;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gcreator.components.ColorSelection;
import org.gcreator.components.ImageDisplayer;
import org.gcreator.components.JFileFilter;
import org.gcreator.components.TabPanel;
import org.gcreator.core.Aurwindow;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.Project;
import org.gcreator.fileclass.res.GImage;
import org.gcreator.managers.LangSupporter;
import org.jdesktop.layout.GroupLayout;

public class ImageEditor
extends TabPanel {
    private ImageDisplayer displayer;
    public GImage image;
    public static JFileChooser jFileChooser1 = null;
    private ButtonGroup buttonGroup1;
    private ColorSelection colorSelection1;
    private JLabel heightLabel;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;
    private JTextField jTextField1;
    private JLabel widthLabel;

    public Color getTransparencyColor() {
        return this.colorSelection1.getBackground();
    }

    public boolean getTransparent() {
        return this.jCheckBox1.isSelected();
    }

    public ImageEditor(GFile file, Project project) {
        this.project = project;
        this.file = file;
        this.displayer = new ImageDisplayer(this, file);
        this.initComponents();
        this.project = project;
        if (file.value == null) {
            this.image = new GImage(file.name);
            this.image.readXml(file.xml);
            file.value = this.image;
        } else if (file.value instanceof GImage) {
            this.image = (GImage)file.value;
        }
        this.file = file;
        this.jScrollPane1.setViewportView(this.displayer);
        this.jTextField1.setText(file.name);
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ImageEditor.this.updateName();
            }

            public void insertUpdate(DocumentEvent evt) {
                ImageEditor.this.updateName();
            }

            public void removeUpdate(DocumentEvent evt) {
                ImageEditor.this.updateName();
            }
        });
        int w = 0;
        int h = 0;
        try {
            ImageIcon img = ((GImage)file.value).image;
            w = img.getIconWidth();
            h = img.getIconHeight();
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        this.widthLabel.setText("Width: " + w);
        this.heightLabel.setText("Height: " + h);
        this.load();
    }

    public void load() {
        if (this.image == null) {
            this.image = new GImage(this.file.name);
            return;
        }
        this.colorSelection1.setBackground(this.image.transparentColor);
        this.jCheckBox1.setSelected(this.image.transparent);
    }

    public boolean wasModified() {
        return false;
    }

    public boolean canSave() {
        return false;
    }

    public boolean Save() {
        return true;
    }

    public void updateName() {
        this.file.name = this.jTextField1.getText();
        Aurwindow.workspace.updateUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.colorSelection1 = new ColorSelection();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jSpinner1 = new JSpinner();
        this.heightLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.widthLabel = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Transparency"));
        this.colorSelection1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.colorSelection1.setToolTipText("Transparent Colour");
        this.colorSelection1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ImageEditor.this.colorSelection1MouseClicked(evt);
            }
        });
        GroupLayout colorSelection1Layout = new GroupLayout(this.colorSelection1);
        this.colorSelection1.setLayout(colorSelection1Layout);
        colorSelection1Layout.setHorizontalGroup(colorSelection1Layout.createParallelGroup(1).add(0, 36, Short.MAX_VALUE));
        colorSelection1Layout.setVerticalGroup(colorSelection1Layout.createParallelGroup(1).add(0, 34, Short.MAX_VALUE));
        this.jCheckBox1.setText("Transparent");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageEditor.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.colorSelection1, -2, -1, -2).add(18, 18, 18).add(this.jCheckBox1).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.colorSelection1, -1, -1, Short.MAX_VALUE).add(this.jCheckBox1, -1, 36, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Image"));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ImageEditor.this.jSpinner1StateChanged(evt);
            }
        });
        this.heightLabel.setText("height");
        this.jLabel1.setText(LangSupporter.activeLang.getEntry(119));
        this.widthLabel.setText("width");
        this.jTextField1.setText("jTextField1");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageEditor.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jButton1.setText(LangSupporter.activeLang.getEntry(118));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageEditor.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(10, 10, 10).add(this.widthLabel).addPreferredGap(0).add(this.heightLabel)).add(jPanel2Layout.createSequentialGroup().add(this.jButton1).addPreferredGap(0).add(this.jTextField1, -2, 162, -2).addPreferredGap(0).add(this.jLabel1).add(10, 10, 10).add(this.jSpinner1, -2, 35, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(3).add(this.jButton1).add(this.jTextField1, -2, -1, -2).add(this.jLabel1).add(this.jSpinner1, -2, 23, -2)).addPreferredGap(0, 10, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.widthLabel).add(this.heightLabel))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 611, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jPanel2, -2, -1, -2).addPreferredGap(1).add(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1, false).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add(this.jScrollPane1, -1, 287, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (jFileChooser1 == null) {
            jFileChooser1 = new JFileChooser();
        }
        try {
            jFileChooser1.resetChoosableFileFilters();
            JFileFilter filter = new JFileFilter(".*\\.gif|.*\\.jpg|.*\\.png", "Image Files (*.png, *.gif, *.jpg)");
            jFileChooser1.addChoosableFileFilter(filter);
            JFileFilter filter2 = new JFileFilter(".*\\.*", "Any Files (*.*)");
            jFileChooser1.addChoosableFileFilter(filter2);
            jFileChooser1.setFileFilter(filter);
            jFileChooser1.showDialog(this, "OK");
            if (jFileChooser1.getSelectedFile() != null) {
                File _file = jFileChooser1.getSelectedFile();
                this.file.type = _file.getName().substring(_file.getName().lastIndexOf(".") + 1);
                if (this.file.type.toLowerCase().equals("gif")) {
                    System.out.println("GIF!");
                    ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
                    reader.setInput(new FileImageInputStream(_file));
                    System.out.println("No: " + reader.getNumImages(true));
                    BufferedImage[] b = new BufferedImage[reader.getNumImages(true)];
                    for (int i = 0; i < reader.getNumImages(true); ++i) {
                        b[i] = reader.read(i);
                    }
                    ((GImage)this.file.value).image = new ImageIcon(b[0]);
                } else {
                    ((GImage)this.file.value).image = new ImageIcon(ImageIO.read(_file));
                }
                Aurwindow.workspace.updateUI();
                this.jScrollPane1.updateUI();
                System.out.println(this.file.name + "." + this.file.type);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int w = 0;
        int h = 0;
        if (this.file.value != null) {
            w = ((GImage)this.file.value).image.getIconWidth();
            h = ((GImage)this.file.value).image.getIconHeight();
        }
        this.widthLabel.setText("Width: " + w);
        this.heightLabel.setText("Height: " + h);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.file.name = this.jTextField1.getText();
        Aurwindow.workspace.updateUI();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.updateScroll();
    }

    private void colorSelection1MouseClicked(MouseEvent evt) {
        this.displayer.updateUI();
        this.image.transparentColor = this.colorSelection1.getBackground();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.image.transparent = this.jCheckBox1.isSelected();
    }

    public void updateScroll() {
        System.out.println("Update");
        if ((Integer)this.jSpinner1.getValue() > 5) {
            this.jSpinner1.setValue(5);
        } else if ((Integer)this.jSpinner1.getValue() < -5) {
            this.jSpinner1.setValue(-5);
        }
        this.displayer.zoom = this.getZoom();
        this.displayer.updateUI();
        this.jScrollPane1.updateUI();
    }

    public double getZoom() {
        int x = (Integer)this.jSpinner1.getValue();
        switch (x) {
            case 5: {
                return 6.0;
            }
            case 4: {
                return 5.0;
            }
            case 3: {
                return 4.0;
            }
            case 2: {
                return 3.0;
            }
            case 1: {
                return 2.0;
            }
            case 0: {
                return 1.0;
            }
            case -1: {
                return 0.5;
            }
            case -2: {
                return 0.33;
            }
            case -3: {
                return 0.25;
            }
            case -4: {
                return 0.2;
            }
        }
        return 0.16;
    }
}

