/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.editors;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gcreator.components.SubimagePreview;
import org.gcreator.components.TabPanel;
import org.gcreator.components.resource.ResourceChooser;
import org.gcreator.core.Aurwindow;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.Project;
import org.gcreator.fileclass.res.GImage;
import org.gcreator.fileclass.res.Sprite;
import org.gcreator.managers.LangSupporter;
import org.jdesktop.layout.GroupLayout;

public class SpriteEditor
extends TabPanel {
    public Sprite sprite;
    boolean changed;
    private SubimagePreview prev;
    private ResourceChooser res;
    private boolean dragging = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton6;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    public JSpinner jSpinner1;
    public JSpinner jSpinner2;
    public JSpinner jSpinner3;
    public JSpinner jSpinner4;
    public JSpinner jSpinner5;
    public JSpinner jSpinner6;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public SpriteEditor(GFile file, Project project) {
        this.project = project;
        this.file = file;
        if (file.value != null) {
            if (file.value instanceof String) {
                Sprite spr = new Sprite(file.name);
                spr.readXml((String)file.value);
                file.value = spr;
            } else {
                this.sprite = (Sprite)file.value;
            }
        } else {
            file.value = new Sprite(file.name);
            this.sprite = file.value;
        }
        this.initComponents();
        this.load();
        try {
            this.jTextField1.setText(file.name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.prev = new SubimagePreview(this);
        this.jScrollPane1.setViewportView(this.prev);
        this.res = new ResourceChooser(project, "image");
        this.jPanel13.add(this.res);
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                SpriteEditor.this.updateName();
            }

            public void insertUpdate(DocumentEvent evt) {
                SpriteEditor.this.updateName();
            }

            public void removeUpdate(DocumentEvent evt) {
                SpriteEditor.this.updateName();
            }
        });
        this.jButton3.setText("");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/org/gcreator/resources/subimageright.png")));
        this.jButton4.setText("");
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/org/gcreator/resources/subimageleft.png")));
    }

    public void updateName() {
        this.sprite.name = this.file.name = this.jTextField1.getText();
        Aurwindow.workspace.updateUI();
    }

    public boolean Save() {
        this.sprite.BBBottom = (Integer)this.jSpinner6.getValue();
        this.sprite.BBRight = (Integer)this.jSpinner5.getValue();
        this.sprite.BBTop = (Integer)this.jSpinner4.getValue();
        this.sprite.BBleft = (Integer)this.jSpinner3.getValue();
        this.sprite.originX = (Integer)this.jSpinner1.getValue();
        this.sprite.originY = (Integer)this.jSpinner2.getValue();
        this.sprite.precise = this.jCheckBox1.isSelected();
        return true;
    }

    public boolean wasModified() {
        return this.changed;
    }

    public void load() {
        if (this.sprite == null) {
            this.sprite = new Sprite(this.file.name);
            return;
        }
        System.out.println("Loading");
        this.jSpinner1.setValue(this.sprite.originX);
        this.jSpinner2.setValue(this.sprite.originY);
        this.jSpinner6.setValue(this.sprite.BBBottom);
        this.jSpinner5.setValue(this.sprite.BBRight);
        this.jSpinner4.setValue(this.sprite.BBTop);
        this.jSpinner3.setValue(this.sprite.BBleft);
        this.jCheckBox1.setSelected(this.sprite.precise);
        this.jLabel2.setText("Width: " + this.sprite.width);
        this.jLabel3.setText("Height: " + this.sprite.height);
        this.jLabel4.setText("Subimages: " + this.sprite.countImages());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jButton4 = new JButton();
        this.jTextField2 = new JTextField();
        this.jButton1 = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jSpinner3 = new JSpinner();
        this.jSpinner4 = new JSpinner();
        this.jSpinner5 = new JSpinner();
        this.jSpinner6 = new JSpinner();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jButton6 = new JButton();
        this.jSpinner1 = new JSpinner();
        this.jSpinner2 = new JSpinner();
        this.jLabel1.setText("Name:");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                SpriteEditor.this.jScrollPane1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                SpriteEditor.this.jScrollPane1MouseReleased(evt);
            }
        });
        this.jScrollPane1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                SpriteEditor.this.jScrollPane1MouseDragged(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Image"));
        this.jPanel13.setLayout(new BorderLayout());
        this.jButton2.setText(LangSupporter.activeLang.getEntry(133));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Height:");
        this.jLabel2.setText("Width:");
        this.jLabel4.setText("Subimages:");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Show:");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton4ActionPerformed(evt);
            }
        });
        this.jTextField2.setEditable(false);
        this.jTextField2.setHorizontalAlignment(0);
        this.jTextField2.setText("0");
        this.jButton1.setText(LangSupporter.activeLang.getEntry(135));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(1).add(this.jPanel13, -1, 190, Short.MAX_VALUE).add(this.jButton2, -1, 190, Short.MAX_VALUE).add(jPanel4Layout.createSequentialGroup().add(this.jLabel2, -2, 57, -2).addPreferredGap(0).add(this.jLabel3, -1, 115, Short.MAX_VALUE).add(12, 12, 12)).add(2, jPanel4Layout.createSequentialGroup().add(2, 2, 2).add(this.jLabel4, -1, 178, Short.MAX_VALUE).addContainerGap()).add(jPanel4Layout.createSequentialGroup().add(81, 81, 81).add(this.jTextField2, -2, 26, -2).addPreferredGap(1).add(this.jButton4, -1, 71, Short.MAX_VALUE).add(2, 2, 2)).add(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(2, 2, 2).add(jPanel4Layout.createParallelGroup(1).add(this.jLabel5).add(this.jButton1, -1, 186, Short.MAX_VALUE).add(this.jButton3, -2, 71, -2)).add(2, 2, 2))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(this.jPanel13, -2, 24, -2).addPreferredGap(0).add(this.jButton2).addPreferredGap(0).add(jPanel4Layout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel3)).addPreferredGap(0).add(this.jLabel4).addPreferredGap(0, 145, Short.MAX_VALUE).add(this.jTextField2, -2, -1, -2).add(51, 51, 51)).add(jPanel4Layout.createParallelGroup(1).add(2, jPanel4Layout.createSequentialGroup().addContainerGap(216, Short.MAX_VALUE).add(this.jLabel5).addPreferredGap(0).add(jPanel4Layout.createParallelGroup(3).add(this.jButton3, -2, 22, -2).add(this.jButton4, -2, 22, -2)).addPreferredGap(0).add(this.jButton1).add(21, 21, 21))));
        this.jTabbedPane1.addTab("General", this.jPanel4);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Bounding Box"));
        this.jLabel8.setText("Left:");
        this.jLabel9.setText("Right:");
        this.jLabel10.setText("Top:");
        this.jLabel11.setText("Bottom:");
        this.jSpinner3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner3StateChanged(evt);
            }
        });
        this.jSpinner4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner4StateChanged(evt);
            }
        });
        this.jSpinner5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner5StateChanged(evt);
            }
        });
        this.jSpinner6.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner6StateChanged(evt);
            }
        });
        this.jButton8.setText("Automatic");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButton9.setText("Full Image");
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton9ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(this.jLabel11).add(this.jLabel9).add(this.jLabel8).add(this.jLabel10)).add(31, 31, 31).add(jPanel2Layout.createParallelGroup(1).add(this.jSpinner6, -1, 81, Short.MAX_VALUE).add(this.jSpinner4, -1, 81, Short.MAX_VALUE).add(this.jSpinner3, -1, 81, Short.MAX_VALUE).add(this.jSpinner5, -1, 81, Short.MAX_VALUE))).add(this.jButton8, -1, 150, Short.MAX_VALUE).add(2, this.jButton9, -1, 150, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jButton8).addPreferredGap(0).add(this.jButton9).addPreferredGap(0, 28, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel10).add(this.jSpinner4, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel11).add(this.jSpinner6, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel9).add(this.jSpinner5, -2, -1, -2)).addPreferredGap(0).add(jPanel2Layout.createParallelGroup(3).add(this.jLabel8).add(this.jSpinner3, -2, -1, -2))));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Precise collision checking");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jCheckBox1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SpriteEditor.this.jCheckBox1PropertyChange(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().addContainerGap().add(jPanel5Layout.createParallelGroup(1).add(this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.jCheckBox1)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(2, jPanel5Layout.createSequentialGroup().addContainerGap().add(this.jPanel2, -2, -1, -2).addPreferredGap(0, 90, Short.MAX_VALUE).add(this.jCheckBox1).addContainerGap()));
        this.jTabbedPane1.addTab("Collision", this.jPanel5);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Origin"));
        this.jLabel6.setText("X:");
        this.jLabel7.setText("Y:");
        this.jButton6.setText("Centre");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpriteEditor.this.jButton6ActionPerformed(evt);
            }
        });
        this.jSpinner1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpriteEditor.this.jSpinner1MouseClicked(evt);
            }
        });
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner1StateChanged(evt);
            }
        });
        this.jSpinner1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                SpriteEditor.this.jSpinner1KeyTyped(evt);
            }
        });
        this.jSpinner2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpriteEditor.this.jSpinner2MouseClicked(evt);
            }
        });
        this.jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SpriteEditor.this.jSpinner2StateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0).add(this.jSpinner1, -2, 46, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.jButton6).add(jPanel1Layout.createSequentialGroup().add(12, 12, 12).add(this.jLabel7, -2, 18, -2).addPreferredGap(0).add(this.jSpinner2, -1, 60, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel6).add(this.jSpinner2, -2, -1, -2).add(this.jLabel7).add(this.jSpinner1, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jButton6)));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(1).add(jPanel6Layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(1).add(jPanel6Layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addContainerGap(249, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Other", this.jPanel6);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jTextField1, -2, 111, -2)).add(this.jTabbedPane1, -2, 211, -2)).addPreferredGap(0).add(this.jScrollPane1, -1, 422, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(layout.createParallelGroup(2).add(1, layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -1, 394, Short.MAX_VALUE)).add(1, layout.createSequentialGroup().add(12, 12, 12).add(layout.createParallelGroup(3).add(this.jLabel1, -2, 17, -2).add(this.jTextField1, -2, 20, -2)).addPreferredGap(0).add(this.jTabbedPane1, -1, 367, Short.MAX_VALUE))).addContainerGap()));
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.file.name = this.jTextField1.getText();
        Aurwindow.workspace.updateUI();
    }

    private void jSpinner1MouseClicked(MouseEvent evt) {
        this.changed = true;
    }

    private void jSpinner1KeyTyped(KeyEvent evt) {
        this.changed = true;
    }

    private void jSpinner2MouseClicked(MouseEvent evt) {
        this.changed = true;
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.sprite.precise = this.jCheckBox1.isSelected();
    }

    private void jCheckBox1PropertyChange(PropertyChangeEvent evt) {
        this.sprite.precise = this.jCheckBox1.isSelected();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.sprite.originX = (Integer)this.jSpinner1.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jSpinner2StateChanged(ChangeEvent evt) {
        this.sprite.originY = (Integer)this.jSpinner2.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jSpinner4StateChanged(ChangeEvent evt) {
        this.sprite.BBTop = (Integer)this.jSpinner4.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jSpinner6StateChanged(ChangeEvent evt) {
        this.sprite.BBBottom = (Integer)this.jSpinner6.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jSpinner5StateChanged(ChangeEvent evt) {
        this.sprite.BBRight = (Integer)this.jSpinner5.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jSpinner3StateChanged(ChangeEvent evt) {
        this.sprite.BBleft = (Integer)this.jSpinner3.getValue();
        this.jScrollPane1.updateUI();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.jSpinner1.setValue(this.sprite.width / 2);
        this.jSpinner2.setValue(this.sprite.height / 2);
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.jSpinner3.setValue(this.sprite.width - 1);
        this.jSpinner4.setValue(0);
        this.jSpinner5.setValue(0);
        this.jSpinner6.setValue(this.sprite.height - 1);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        GFile a = this.res.getFile();
        Object o = a.value;
        if (this.sprite.countImages() == 0) {
            this.sprite.width = ((GImage)o).image.getIconWidth();
            this.sprite.height = ((GImage)o).image.getIconHeight();
            this.jLabel2.setText("Width:" + this.sprite.width);
            this.jLabel3.setText("Height:" + this.sprite.height);
            this.jButton9ActionPerformed(evt);
        }
        if (this.sprite.width == ((GImage)o).image.getIconWidth() && this.sprite.height == ((GImage)o).image.getIconHeight()) {
            this.sprite.addToList(this.res.getFile());
        } else {
            System.out.println("Image not right size!");
        }
        this.jLabel4.setText("Subimages:" + this.sprite.countImages());
        this.jScrollPane1.updateUI();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int id = this.getViewedId();
        this.sprite.Simages.remove(id);
        if (id >= this.sprite.countImages()) {
            id = 0;
        }
        this.jLabel4.setText("Subimages: " + this.sprite.countImages());
        this.setViewedId(id);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        int id = this.getViewedId() + 1;
        if (id >= this.sprite.countImages()) {
            id = 0;
        }
        this.setViewedId(id);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        int id = this.getViewedId() - 1;
        if (id < 0) {
            id = Math.max(0, this.sprite.countImages() - 1);
        }
        this.setViewedId(id);
    }

    private void jScrollPane1MouseDragged(MouseEvent evt) {
        if (!this.dragging) {
            return;
        }
        int x = evt.getX() - 2;
        int y = evt.getY() - 2;
        this.sprite.originX = x;
        this.sprite.originY = y;
        this.jSpinner1.setValue(x);
        this.jSpinner2.setValue(y);
        this.prev.repaint();
    }

    private void jScrollPane1MousePressed(MouseEvent evt) {
        if (evt.getX() > this.sprite.width || evt.getY() > this.sprite.height) {
            return;
        }
        this.dragging = true;
        this.jScrollPane1MouseDragged(evt);
    }

    private void jScrollPane1MouseReleased(MouseEvent evt) {
        this.dragging = false;
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.setAutomaticBounds();
    }

    public int getViewedId() {
        try {
            return Integer.parseInt(this.jTextField2.getText());
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void setViewedId(int id) {
        this.jTextField2.setText("" + id);
        this.jScrollPane1.updateUI();
    }

    public ImageIcon getImageAt(int id) {
        return this.sprite.getImageAt(id);
    }

    public ImageIcon getCurrentImage() {
        return this.getImageAt(this.getViewedId());
    }

    private void setAutomaticBounds() {
    }
}

