/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.fileclass.res;

import java.awt.Color;
import javax.swing.ImageIcon;
import org.gcreator.fileclass.res.Resource;

public class GImage
extends Resource {
    static final long serialVersionUID = 1L;
    public ImageIcon image;
    public int width;
    public int height;
    public boolean transparent;
    public Color transparentColor;

    public GImage(String name) {
        this.name = name;
        this.image = new ImageIcon();
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public String writeXml() {
        String xml = "";
        xml = xml + "<?xml version=\"1.0\"?>\n";
        xml = xml + "<gimage>\n";
        xml = xml + "<transparent>" + this.transparent + "</transparent>\n";
        xml = xml + "<color>" + this.transparentColor.getRed() + ", " + this.transparentColor.getGreen() + ", " + this.transparentColor.getBlue() + "</color>\n";
        xml = xml + "</gimage>\n";
        return xml;
    }

    public void readXml(String xml) {
        String[] lines = xml.split("\n");
        if (!lines[0].matches("<\\?xml version=\"1\\.0\"\\?>")) {
            return;
        }
        if (!lines[1].matches("<gimage>")) {
            return;
        }
        if (lines.length < 3) {
            return;
        }
        int i = 3;
        while (i < lines.length) {
            String line = lines[i];
            System.out.println(line);
            if (line == null || line.equals("")) continue;
            if (line.equals("</gimage>")) break;
            if (line.matches("<transparent>(true|false)</transparent>")) {
                String trans = line.replaceAll("<transparent>(true|false)</transparent>", "$1");
                this.transparent = Boolean.parseBoolean(trans);
            } else if (line.matches("<color>[0-9]*, [0-9]*, [0-9]</color>")) {
                String sred = line.replaceAll("<color>([0-9]*), [0-9]*, [0-9]*</color>", "$1");
                String sgreen = line.replaceAll("<color>[0-9]*, ([0-9]*), [0-9]*</color>", "$1");
                String sblue = line.replaceAll("<color>[0-9]*, [0-9]*, ([0-9]*)</color>", "$1");
                int red = Integer.parseInt(sred);
                int green = Integer.parseInt(sgreen);
                int blue = Integer.parseInt(sblue);
                this.transparentColor = new Color(red, green, blue);
            }
            ++i;
        }
    }

    public String exportToHtml(boolean xhtml) {
        return "";
    }

    public Object clone() {
        GImage a = new GImage(this.name);
        a.height = this.height;
        a.width = this.width;
        a.transparent = this.transparent;
        a.transparentColor = this.transparentColor;
        return a;
    }
}

