/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.managers;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.gcreator.components.impl.Toolbar;
import org.gcreator.components.impl.ToolbarButton;
import org.gcreator.components.impl.ToolbarItem;
import org.gcreator.components.impl.ToolbarSeparator;
import org.gcreator.core.Aurwindow;
import org.gcreator.core.gcreator;

public class ToolbarManager {
    public static Vector<Toolbar> toolbars = new Vector();
    public static Vector<ToolbarButton> toolbuttons = new Vector();

    public static void destroyToolbars() {
        ToolbarManager.hideAll();
        gcreator.window.topContainer.removeAll();
        gcreator.window.bottomContainer.removeAll();
        gcreator.window.leftContainer.removeAll();
        gcreator.window.rightContainer.removeAll();
    }

    public static void hideAll() {
        Enumeration<Toolbar> e = toolbars.elements();
        while (e.hasMoreElements()) {
            Toolbar t = e.nextElement();
            t.hideAll();
        }
    }

    public static void showAll() {
        Enumeration<Toolbar> e = toolbars.elements();
        while (e.hasMoreElements()) {
            Toolbar t = e.nextElement();
            t.showAll();
        }
    }

    public static void makeToolbars(Aurwindow window) {
        for (Toolbar toolbar : toolbars) {
            toolbar.make(window);
        }
    }

    public static void makeToolbars() {
        ToolbarManager.makeToolbars(gcreator.window);
    }

    public static void remakeToolbars() {
        ToolbarManager.destroyToolbars();
        ToolbarManager.makeToolbars();
    }

    public static void parseToolbarFile(String fname) throws IOException {
        File file = new File(fname);
        if (!file.exists() || file.isDirectory()) {
            return;
        }
        String o = "";
        FileReader reader = new FileReader(file);
        int i = 0;
        while ((i = reader.read()) != -1) {
            o = o + (char)i;
        }
        reader.close();
        o = o.replaceAll("\r", "");
        o = o.replaceAll(";.+?\n", "\n");
        o = o.replaceAll("\n\n", "\n");
        String[] os = o.split("\n");
        boolean pfile = false;
        Object v = null;
        Toolbar t = null;
        boolean tvisible = false;
        boolean ivisible = false;
        boolean bold = false;
        int version = 100;
        for (String line : os) {
            if (line.equals("")) continue;
            if (!pfile) {
                if (line.equals("[G-Creator Toolbar List]")) {
                    pfile = true;
                    continue;
                }
                System.out.println("Not a G-Creator Toolbar List\n->" + line + "<-");
                break;
            }
            if (v == null && line.matches("^Version=[0-9]+(\\.[0-9]+)*$")) {
                String ver = line.replaceAll("^Version=([0-9]+(\\.[0-9]+)*)$", "$1");
                if (ver.matches("1\\.0\\.0")) {
                    version = 100;
                    continue;
                }
                if (ver.matches("1\\.0\\.1")) {
                    version = 101;
                    continue;
                }
                System.out.println("Unsupported version " + ver + "! Currently supported version is 1.0.0");
                break;
            }
            if (t == null) {
                if (line.equals("[Toolbar]")) {
                    t = new Toolbar();
                    t.name = null;
                    toolbars.add(t);
                    tvisible = false;
                    ivisible = false;
                    bold = false;
                    continue;
                }
                System.out.println("Unexpected string");
                break;
            }
            if (line.equals("[Toolbar]")) {
                t = new Toolbar();
                t.name = null;
                toolbars.add(t);
                tvisible = false;
                ivisible = false;
                bold = false;
                continue;
            }
            if (!line.matches("[a-zA-Z0-9_]+=[^;\\[\\]]+")) {
                System.out.println("Invalid format in " + t + "\nShould be in format 'Property=Value'");
                break;
            }
            String key = line.replaceAll("([a-zA-Z0-9_]+)=[^;\\[\\]]+", "$1");
            String value = line.replaceAll("[a-zA-Z0-9_]+=([^;\\[\\]]+)", "$1");
            if (key.equals("Name")) {
                t.name = value;
                continue;
            }
            if (key.equals("Position")) {
                if (!(value.equals("Top") || value.equals("Bottom") || value.equals("Left") || value.equals("Right"))) {
                    System.out.println("Invalid position " + value);
                    break;
                }
                t.first = value.equals("Top") || value.equals("Left");
                if (value.equals("Top") || value.equals("Bottom")) {
                    t.horizontal = true;
                    continue;
                }
                t.horizontal = false;
                continue;
            }
            if (key.equals("Rollover")) {
                if (value.equals("True")) {
                    t.rollover = true;
                    continue;
                }
                if (value.equals("False")) {
                    t.rollover = false;
                    continue;
                }
                System.out.println("Invalid boolean property: " + value);
                break;
            }
            if (key.equals("Floatable")) {
                if (value.equals("True")) {
                    t.floatable = true;
                    continue;
                }
                if (value.equals("False")) {
                    t.floatable = false;
                    continue;
                }
                System.out.println("Invalid boolean property: " + value);
                break;
            }
            if (key.equals("TextVisible")) {
                if (value.equals("True")) {
                    tvisible = true;
                    continue;
                }
                if (value.equals("False")) {
                    tvisible = false;
                    continue;
                }
                System.out.println("Invalid boolean property: " + value);
                break;
            }
            if (key.equals("ImageVisible")) {
                if (value.equals("True")) {
                    ivisible = true;
                    continue;
                }
                if (value.equals("False")) {
                    ivisible = false;
                    continue;
                }
                System.out.println("Invalid boolean property: " + value);
                break;
            }
            if (key.equals("Bold") && version >= 101) {
                if (value.equals("True")) {
                    bold = true;
                    continue;
                }
                if (value.equals("False")) {
                    bold = false;
                    continue;
                }
                System.out.println("Invalid boolean property: " + value);
                break;
            }
            if (key.equals("Item")) {
                boolean found = false;
                for (ToolbarButton btn : toolbuttons) {
                    if (!btn.getID().equals(value)) continue;
                    btn.setTextVisible(tvisible);
                    btn.setImageVisible(ivisible);
                    btn.setBold(bold);
                    t.items.add(btn);
                    found = true;
                    break;
                }
                if (found) continue;
                System.out.println("Unknown item " + value + "\nAre you missing a plugin?");
                continue;
            }
            if (key.equals("Separator")) {
                t.items.add(new ToolbarSeparator());
                continue;
            }
            System.out.println("Unknown property: " + key);
        }
    }

    public static void writeToolbarFile(String fname) throws IOException {
        File file = new File(fname);
        if (file.isDirectory()) {
            return;
        }
        FileWriter writer = new FileWriter(file);
        writer.write(";Starting File\n");
        writer.write("[G-Creator Toolbar List]\n");
        writer.write(";Property=Value\n");
        writer.write("Version=1.0.1\n");
        writer.write("\n");
        for (Toolbar toolbar : toolbars) {
            writer.write("[Toolbar]\n");
            if (toolbar.name != null) {
                writer.write("Name=" + toolbar.name + "\n");
            }
            writer.write("Position=");
            writer.write((toolbar.horizontal ? (toolbar.first ? "Top" : "Bottom") : (toolbar.first ? "Left" : "Right")) + "\n");
            writer.write("Rollover=" + (toolbar.rollover ? "True" : "False") + "\n");
            writer.write("Floatable=" + (toolbar.floatable ? "True" : "False") + "\n");
            toolbar.items.trimToSize();
            if (toolbar.items.capacity() == 0) continue;
            Boolean curtextvisible = null;
            Boolean curimgvisible = null;
            Boolean curbold = null;
            for (ToolbarItem item : toolbar.items) {
                if (item instanceof ToolbarSeparator) {
                    writer.write("Separator=Standard\n");
                    continue;
                }
                ToolbarButton btn = (ToolbarButton)item;
                if (curtextvisible == null || curtextvisible.booleanValue() != btn.isTextVisible()) {
                    writer.write("TextVisible=" + ((curtextvisible = Boolean.valueOf(btn.isTextVisible())) != false ? "True" : "False") + "\n");
                }
                if (curimgvisible == null || curimgvisible.booleanValue() != btn.isImageVisible()) {
                    writer.write("ImageVisible=" + ((curimgvisible = Boolean.valueOf(btn.isImageVisible())) != false ? "True" : "False") + "\n");
                }
                if (curbold == null || curbold.booleanValue() != btn.isBold()) {
                    writer.write("Bold=" + ((curbold = Boolean.valueOf(btn.isBold())) != false ? "True" : "False") + "\n");
                }
                writer.write("Item=" + btn.getID() + "\n");
            }
            writer.write("\n");
        }
        writer.close();
    }
}

