/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code {
    public final boolean debugCode;
    public final boolean stackMap;
    final Types types;
    final Symtab syms;
    public int max_stack = 0;
    public int max_locals = 0;
    public byte[] code = new byte[64];
    public int cp = 0;
    ListBuffer<char[]> catchInfo = new ListBuffer();
    List<char[]> lineInfo = List.nil();
    public CRTable crt;
    public boolean fatcode;
    private boolean alive = true;
    State state;
    private boolean fixedPc = false;
    public int nextreg = 0;
    Chain pendingJumps = null;
    int pendingStatPos = 0;
    boolean pendingStackMap = false;
    boolean varDebugInfo;
    boolean lineDebugInfo;
    final Pool pool;
    final Symbol.MethodSymbol meth;
    StackMapFrame[] stackMapBuffer = null;
    int stackMapBufferSize = 0;
    int lastStackMap = -1;
    static Type jsrReturnValue = new Type(4, null);
    LocalVar[] lvar;
    LocalVar[] varBuffer;
    int varBufferSize;

    public boolean checkLimits(int n, Log log) {
        if (this.cp > 65535) {
            log.error(n, "limit.code", new Object[0]);
            return true;
        }
        if (this.max_locals > 65535) {
            log.error(n, "limit.locals", new Object[0]);
            return true;
        }
        if (this.max_stack > 65535) {
            log.error(n, "limit.stack", new Object[0]);
            return true;
        }
        return false;
    }

    public Code(Symbol.MethodSymbol methodSymbol, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, CRTable cRTable, Symtab symtab, Types types, Pool pool) {
        this.meth = methodSymbol;
        this.fatcode = bl;
        this.lineDebugInfo = bl2;
        this.varDebugInfo = bl3;
        this.crt = cRTable;
        this.syms = symtab;
        this.types = types;
        this.debugCode = bl5;
        this.stackMap = bl4;
        this.state = new State();
        this.lvar = new LocalVar[20];
        this.pool = pool;
    }

    public static int typecode(Type type) {
        switch (type.tag) {
            case 1: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 22: 
            case 23: {
                return 4;
            }
        }
        throw new AssertionError((Object)("typecode " + type.tag));
    }

    public static int truncate(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return n;
    }

    public static int width(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return type == null ? 1 : Code.width(Code.typecode(type));
    }

    public static int width(List<Type> list) {
        int n = 0;
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            n += Code.width((Type)list2.head);
            list2 = list2.tail;
        }
        return n;
    }

    public static int arraycode(Type type) {
        switch (type.tag) {
            case 1: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 3: {
                return 9;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 1;
            }
        }
        throw new AssertionError((Object)("arraycode " + type));
    }

    public int curPc() {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.pendingStatPos != 0) {
            this.markStatBegin();
        }
        this.fixedPc = true;
        return this.cp;
    }

    private void emit1(int n) {
        if (!this.alive) {
            return;
        }
        if (this.cp == this.code.length) {
            byte[] byArray = new byte[this.cp * 2];
            System.arraycopy(this.code, 0, byArray, 0, this.cp);
            this.code = byArray;
        }
        this.code[this.cp++] = (byte)n;
    }

    private void emit2(int n) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 2 > this.code.length) {
            this.emit1(n >> 8);
            this.emit1(n);
        } else {
            this.code[this.cp++] = (byte)(n >> 8);
            this.code[this.cp++] = (byte)n;
        }
    }

    public void emit4(int n) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 4 > this.code.length) {
            this.emit1(n >> 24);
            this.emit1(n >> 16);
            this.emit1(n >> 8);
            this.emit1(n);
        } else {
            this.code[this.cp++] = (byte)(n >> 24);
            this.code[this.cp++] = (byte)(n >> 16);
            this.code[this.cp++] = (byte)(n >> 8);
            this.code[this.cp++] = (byte)n;
        }
    }

    private void emitop(int n) {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.alive) {
            if (this.pendingStatPos != 0) {
                this.markStatBegin();
            }
            if (this.pendingStackMap) {
                this.pendingStackMap = false;
                this.emitStackMap();
            }
            if (this.debugCode) {
                System.err.println("emit@" + this.cp + " stack=" + this.state.stacksize + ": " + Code.mnem(n));
            }
            this.emit1(n);
        }
    }

    void postop() {
        assert (this.alive | this.state.stacksize == 0);
    }

    public void emitMultianewarray(int n, int n2, Type type) {
        this.emitop(197);
        if (!this.alive) {
            return;
        }
        this.emit2(n2);
        this.emit1(n);
        this.state.pop(n);
        this.state.push(type);
    }

    public void emitNewarray(int n, Type type) {
        this.emitop(188);
        if (!this.alive) {
            return;
        }
        this.emit1(n);
        this.state.pop(1);
        this.state.push(type);
    }

    public void emitAnewarray(int n, Type type) {
        this.emitop(189);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(1);
        this.state.push(type);
    }

    public void emitInvokeinterface(int n, Type type) {
        int n2 = Code.width(type.argtypes());
        this.emitop(185);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.emit1(n2 + 1);
        this.emit1(0);
        this.state.pop(n2 + 1);
        this.state.push(type.restype());
    }

    public void emitInvokespecial(int n, Type type) {
        int n2 = Code.width(type.argtypes());
        this.emitop(183);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        Symbol symbol = (Symbol)this.pool.pool[n];
        this.state.pop(n2);
        if (symbol.isConstructor()) {
            this.state.markInitialized((UninitializedType)this.state.peek());
        }
        this.state.pop(1);
        this.state.push(type.restype());
    }

    public void emitInvokestatic(int n, Type type) {
        int n2 = Code.width(type.argtypes());
        this.emitop(184);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(n2);
        this.state.push(type.restype());
    }

    public void emitInvokevirtual(int n, Type type) {
        int n2 = Code.width(type.argtypes());
        this.emitop(182);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(n2 + 1);
        this.state.push(type.restype());
    }

    public void emitop0(int n) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 50: {
                this.state.pop(1);
                Type type = this.state.stack[this.state.stacksize - 1];
                this.state.pop(1);
                this.state.push(this.types.erasure(this.types.elemtype(type)));
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            case 1: {
                this.state.push(this.syms.botType);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.state.push(this.syms.intType);
                break;
            }
            case 9: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.state.push(this.syms.longType);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 14: 
            case 15: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 42: {
                this.state.push(this.lvar[0].sym.type);
                break;
            }
            case 43: {
                this.state.push(this.lvar[1].sym.type);
                break;
            }
            case 44: {
                this.state.push(this.lvar[2].sym.type);
                break;
            }
            case 45: {
                this.state.push(this.lvar[3].sym.type);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 47: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 48: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 49: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 121: 
            case 123: 
            case 125: {
                this.state.pop(1);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                assert (this.state.nlocks == 0);
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 191: {
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: {
                this.state.pop(2);
                break;
            }
            case 173: 
            case 175: {
                assert (this.state.nlocks == 0);
                this.state.pop(2);
                this.markDead();
                break;
            }
            case 89: {
                this.state.push(this.state.stack[this.state.stacksize - 1]);
                break;
            }
            case 177: {
                assert (this.state.nlocks == 0);
                this.markDead();
                break;
            }
            case 190: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.state.pop(1);
                break;
            }
            case 83: {
                this.state.pop(3);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.state.pop(2);
                break;
            }
            case 148: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 136: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 133: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 134: {
                this.state.pop(1);
                this.state.push(this.syms.floatType);
                break;
            }
            case 135: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 137: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 138: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 139: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 140: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 141: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 142: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 143: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 144: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 170: 
            case 171: {
                this.state.pop(1);
                break;
            }
            case 90: {
                Type type = this.state.pop1();
                Type type2 = this.state.pop1();
                this.state.push(type);
                this.state.push(type2);
                this.state.push(type);
                break;
            }
            case 84: {
                this.state.pop(3);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.state.pop(1);
                break;
            }
            case 79: 
            case 81: 
            case 85: 
            case 86: {
                this.state.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.state.pop(4);
                break;
            }
            case 92: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type3 = this.state.pop1();
                    this.state.push(type3);
                    this.state.push(type);
                    this.state.push(type3);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                this.state.push(type);
                this.state.push(type);
                break;
            }
            case 93: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type4 = this.state.pop1();
                    Type type5 = this.state.pop1();
                    this.state.push(type4);
                    this.state.push(type);
                    this.state.push(type5);
                    this.state.push(type4);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                Type type6 = this.state.pop1();
                this.state.push(type);
                this.state.push(type6);
                this.state.push(type);
                break;
            }
            case 94: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type7 = this.state.pop1();
                    if (this.state.stack[this.state.stacksize - 1] != null) {
                        Type type8 = this.state.pop1();
                        Type type9 = this.state.pop1();
                        this.state.push(type7);
                        this.state.push(type);
                        this.state.push(type9);
                        this.state.push(type8);
                        this.state.push(type7);
                        this.state.push(type);
                        break;
                    }
                    Type type10 = this.state.pop2();
                    this.state.push(type7);
                    this.state.push(type);
                    this.state.push(type10);
                    this.state.push(type7);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type11 = this.state.pop1();
                    Type type12 = this.state.pop1();
                    this.state.push(type);
                    this.state.push(type12);
                    this.state.push(type11);
                    this.state.push(type);
                    break;
                }
                Type type13 = this.state.pop2();
                this.state.push(type);
                this.state.push(type13);
                this.state.push(type);
                break;
            }
            case 91: {
                Type type = this.state.pop1();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type14 = this.state.pop1();
                    Type type15 = this.state.pop1();
                    this.state.push(type);
                    this.state.push(type15);
                    this.state.push(type14);
                    this.state.push(type);
                    break;
                }
                Type type16 = this.state.pop2();
                this.state.push(type);
                this.state.push(type16);
                this.state.push(type);
                break;
            }
            case 149: 
            case 150: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 151: 
            case 152: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 95: {
                Type type = this.state.pop1();
                Type type17 = this.state.pop1();
                this.state.push(type);
                this.state.push(type17);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.state.pop(2);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            case 196: {
                return;
            }
            case 194: 
            case 195: {
                this.state.pop(1);
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    public void emitop1(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit1(n2);
        switch (n) {
            case 16: {
                this.state.push(this.syms.intType);
                break;
            }
            case 18: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    private Type typeForPool(Object object) {
        if (object instanceof Integer) {
            return this.syms.intType;
        }
        if (object instanceof Float) {
            return this.syms.floatType;
        }
        if (object instanceof String) {
            return this.syms.stringType;
        }
        if (object instanceof Long) {
            return this.syms.longType;
        }
        if (object instanceof Double) {
            return this.syms.doubleType;
        }
        if (object instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (object instanceof Type.ArrayType) {
            return this.syms.classType;
        }
        throw new AssertionError(object);
    }

    public void emitop1w(int n, int n2) {
        if (n2 > 255) {
            this.emitop(196);
            this.emitop(n);
            this.emit2(n2);
        } else {
            this.emitop(n);
            this.emit1(n2);
        }
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 21: {
                this.state.push(this.syms.intType);
                break;
            }
            case 22: {
                this.state.push(this.syms.longType);
                break;
            }
            case 23: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 24: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 25: {
                this.state.push(this.lvar[n2].sym.type);
                break;
            }
            case 55: 
            case 57: {
                this.state.pop(2);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.state.pop(1);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    public void emitop1w(int n, int n2, int n3) {
        if (n2 > 255 || n3 < -128 || n3 > 127) {
            this.emitop(196);
            this.emitop(n);
            this.emit2(n2);
            this.emit2(n3);
        } else {
            this.emitop(n);
            this.emit1(n2);
            this.emit1(n3);
        }
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 132: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void emitop2(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit2(n2);
        switch (n) {
            case 178: {
                this.state.push(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 179: {
                this.state.pop(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 187: {
                this.state.push(UninitializedType.uninitializedObject(((Symbol)this.pool.pool[n2]).erasure(this.types), this.cp - 3));
                break;
            }
            case 17: {
                this.state.push(this.syms.intType);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.state.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.state.pop(2);
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 181: {
                this.state.pop(((Symbol)this.pool.pool[n2]).erasure(this.types));
                this.state.pop(1);
                break;
            }
            case 180: {
                this.state.pop(1);
                this.state.push(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 192: {
                this.state.pop(1);
                Object object = this.pool.pool[n2];
                Type type = object instanceof Symbol ? ((Symbol)object).erasure(this.types) : this.types.erasure((Type)object);
                this.state.push(type);
                break;
            }
            case 20: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            case 193: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 19: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            case 168: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void emitop4(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit4(n2);
        switch (n) {
            case 200: {
                this.markDead();
                break;
            }
            case 201: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void align(int n) {
        if (this.alive) {
            while (this.cp % n != 0) {
                this.emitop0(0);
            }
        }
    }

    private void put1(int n, int n2) {
        this.code[n] = (byte)n2;
    }

    private void put2(int n, int n2) {
        this.put1(n, n2 >> 8);
        this.put1(n + 1, n2);
    }

    public void put4(int n, int n2) {
        this.put1(n, n2 >> 24);
        this.put1(n + 1, n2 >> 16);
        this.put1(n + 2, n2 >> 8);
        this.put1(n + 3, n2);
    }

    private int get1(int n) {
        return this.code[n] & 0xFF;
    }

    private int get2(int n) {
        return this.get1(n) << 8 | this.get1(n + 1);
    }

    public int get4(int n) {
        return this.get1(n) << 24 | this.get1(n + 1) << 16 | this.get1(n + 2) << 8 | this.get1(n + 3);
    }

    public boolean isAlive() {
        return this.alive || this.pendingJumps != null;
    }

    public void markDead() {
        this.alive = false;
    }

    public int entryPoint() {
        int n = this.curPc();
        this.alive = true;
        this.pendingStackMap = true;
        return n;
    }

    public int entryPoint(State state) {
        int n = this.curPc();
        this.alive = true;
        this.state = state.dup();
        assert (state.stacksize <= this.max_stack);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = true;
        return n;
    }

    public int entryPoint(State state, Type type) {
        int n = this.curPc();
        this.alive = true;
        this.state = state.dup();
        assert (state.stacksize <= this.max_stack);
        this.state.push(type);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = true;
        return n;
    }

    public void emitStackMap() {
        int n;
        Object object;
        int n2 = this.curPc();
        if (!this.stackMap) {
            return;
        }
        if (this.lastStackMap == n2) {
            this.stackMapBuffer[--this.stackMapBufferSize] = null;
        }
        this.lastStackMap = n2;
        if (this.stackMapBuffer == null) {
            this.stackMapBuffer = new StackMapFrame[20];
        } else if (this.stackMapBuffer.length == this.stackMapBufferSize) {
            object = new StackMapFrame[this.stackMapBufferSize << 1];
            System.arraycopy(this.stackMapBuffer, 0, object, 0, this.stackMapBufferSize);
            this.stackMapBuffer = object;
        }
        StackMapFrame stackMapFrame = new StackMapFrame();
        this.stackMapBuffer[this.stackMapBufferSize++] = stackMapFrame;
        object = stackMapFrame;
        object.pc = n2;
        int n3 = 0;
        for (n = this.max_locals - 1; n >= 0; --n) {
            if (!this.state.defined.isMember(n) || this.lvar[n] == null) continue;
            n3 = n + Code.width(this.lvar[n].sym.erasure(this.types));
            break;
        }
        object.locals = new Type[n3];
        for (n = 0; n < n3; ++n) {
            if (!this.state.defined.isMember(n) || this.lvar[n] == null) continue;
            Type type = this.lvar[n].sym.type;
            if (!(type instanceof UninitializedType)) {
                type = this.types.erasure(type);
            }
            object.locals[n] = type;
        }
        object.stack = new Type[this.state.stacksize];
        for (n = 0; n < this.state.stacksize; ++n) {
            object.stack[n] = this.state.stack[n];
        }
        if (this.debugCode) {
            this.state.dump(n2);
        }
    }

    public static int negate(int n) {
        if (n == 198) {
            return 199;
        }
        if (n == 199) {
            return 198;
        }
        return (n + 1 ^ 1) - 1;
    }

    public int emitJump(int n) {
        if (this.fatcode) {
            if (n == 167 || n == 168) {
                this.emitop4(n + 200 - 167, 0);
            } else {
                this.emitop2(Code.negate(n), 8);
                this.emitop4(200, 0);
                this.alive = true;
                this.pendingStackMap = true;
            }
            return this.cp - 5;
        }
        this.emitop2(n, 0);
        return this.cp - 3;
    }

    public Chain branch(int n) {
        Chain chain = null;
        if (n == 167) {
            chain = this.pendingJumps;
            this.pendingJumps = null;
        }
        if (n != 168 && this.isAlive()) {
            chain = new Chain(this.emitJump(n), chain, this.state.dup());
            this.fixedPc = this.fatcode;
            if (n == 167) {
                this.alive = false;
            }
        }
        return chain;
    }

    public void resolve(Chain chain, int n) {
        boolean bl = false;
        State state = this.state;
        while (chain != null) {
            assert (this.state != chain.state);
            assert (n > chain.pc || this.state.stacksize == 0);
            if (n >= this.cp) {
                n = this.cp;
            } else if (this.get1(n) == 167) {
                n = this.fatcode ? (n += this.get4(n + 1)) : (n += this.get2(n + 1));
            }
            if (this.get1(chain.pc) == 167 && chain.pc + 3 == n && n == this.cp && !this.fixedPc) {
                this.cp -= 3;
                n -= 3;
            } else {
                if (this.fatcode) {
                    this.put4(chain.pc + 1, n - chain.pc);
                } else if (n - chain.pc < Short.MIN_VALUE || n - chain.pc > Short.MAX_VALUE) {
                    this.fatcode = true;
                } else {
                    this.put2(chain.pc + 1, n - chain.pc);
                }
                assert (!this.alive || chain.state.stacksize == state.stacksize && chain.state.nlocks == state.nlocks);
            }
            this.fixedPc = true;
            if (this.cp == n) {
                bl = true;
                if (this.debugCode) {
                    System.err.println("resolving chain state=" + chain.state);
                }
                if (this.alive) {
                    state = chain.state.join(state);
                } else {
                    state = chain.state;
                    this.alive = true;
                }
            }
            chain = chain.next;
        }
        assert (!bl || this.state != state);
        if (this.state != state) {
            this.setDefined(state.defined);
            this.state = state;
            this.pendingStackMap = true;
        }
    }

    public void resolve(Chain chain) {
        assert (!this.alive || chain == null || this.state.stacksize == chain.state.stacksize && this.state.nlocks == chain.state.nlocks);
        this.pendingJumps = Code.mergeChains(chain, this.pendingJumps);
    }

    public void resolvePending() {
        Chain chain = this.pendingJumps;
        this.pendingJumps = null;
        this.resolve(chain, this.cp);
    }

    public static Chain mergeChains(Chain chain, Chain chain2) {
        if (chain2 == null) {
            return chain;
        }
        if (chain == null) {
            return chain2;
        }
        assert (chain.state.stacksize == chain2.state.stacksize && chain.state.nlocks == chain2.state.nlocks);
        if (chain.pc < chain2.pc) {
            return new Chain(chain2.pc, Code.mergeChains(chain, chain2.next), chain2.state);
        }
        return new Chain(chain.pc, Code.mergeChains(chain.next, chain2), chain.state);
    }

    public void addCatch(char c, char c2, char c3, char c4) {
        this.catchInfo.append(new char[]{c, c2, c3, c4});
    }

    public void addLineNumber(char c, char c2) {
        if (this.lineDebugInfo) {
            if (this.lineInfo.nonEmpty() && ((char[])this.lineInfo.head)[0] == c) {
                this.lineInfo = this.lineInfo.tail;
            }
            if (this.lineInfo.isEmpty() || ((char[])this.lineInfo.head)[1] != c2) {
                this.lineInfo = this.lineInfo.prepend(new char[]{c, c2});
            }
        }
    }

    public void statBegin(int n) {
        if (n != 0) {
            this.pendingStatPos = n;
        }
    }

    public void markStatBegin() {
        int n = Position.line(this.pendingStatPos);
        this.pendingStatPos = 0;
        if (this.alive && this.lineDebugInfo) {
            char c = (char)this.cp;
            char c2 = (char)n;
            if (c == this.cp && c2 == n) {
                this.addLineNumber(c, c2);
            }
        }
    }

    private void addLocalVar(Symbol.VarSymbol varSymbol) {
        int n = varSymbol.adr;
        if (n + 1 >= this.lvar.length) {
            int n2 = this.lvar.length << 1;
            if (n2 <= n) {
                n2 = n + 10;
            }
            LocalVar[] localVarArray = new LocalVar[n2];
            System.arraycopy(this.lvar, 0, localVarArray, 0, this.lvar.length);
            this.lvar = localVarArray;
        }
        assert (this.lvar[n] == null);
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        this.lvar[n] = new LocalVar(varSymbol);
        this.state.defined.excl(n);
    }

    public void setDefined(Bits bits) {
        if (this.alive && bits != this.state.defined) {
            Bits bits2 = this.state.defined.dup().xorSet(bits);
            int n = bits2.nextBit(0);
            while (n >= 0) {
                if (n >= this.nextreg) {
                    this.state.defined.excl(n);
                } else if (this.state.defined.isMember(n)) {
                    this.setUndefined(n);
                } else {
                    this.setDefined(n);
                }
                n = bits2.nextBit(n + 1);
            }
        }
    }

    public void setDefined(int n) {
        LocalVar localVar = this.lvar[n];
        if (localVar == null) {
            this.state.defined.excl(n);
        } else {
            this.state.defined.incl(n);
            if (this.cp < 65535 && localVar.start_pc == '\uffff') {
                localVar.start_pc = (char)this.cp;
            }
        }
    }

    public void setUndefined(int n) {
        this.state.defined.excl(n);
        if (n < this.lvar.length && this.lvar[n] != null && this.lvar[n].start_pc != '\uffff') {
            LocalVar localVar = this.lvar[n];
            char c = (char)(this.curPc() - localVar.start_pc);
            if (c > '\u0000' && c < '\uffff') {
                this.lvar[n] = localVar.dup();
                localVar.length = c;
                this.putVar(localVar);
            } else {
                localVar.start_pc = (char)65535;
            }
        }
    }

    private void endScope(int n) {
        LocalVar localVar = this.lvar[n];
        if (localVar != null) {
            char c;
            this.lvar[n] = null;
            if (localVar.start_pc != '\uffff' && (c = (char)(this.curPc() - localVar.start_pc)) < '\uffff') {
                localVar.length = c;
                this.putVar(localVar);
            }
        }
        this.state.defined.excl(n);
    }

    void putVar(LocalVar localVar) {
        if (!this.varDebugInfo) {
            return;
        }
        if ((localVar.sym.flags() & 0x1000L) != 0L) {
            return;
        }
        if (this.varBuffer == null) {
            this.varBuffer = new LocalVar[20];
        } else if (this.varBufferSize >= this.varBuffer.length) {
            LocalVar[] localVarArray = new LocalVar[this.varBufferSize * 2];
            System.arraycopy(this.varBuffer, 0, localVarArray, 0, this.varBuffer.length);
            this.varBuffer = localVarArray;
        }
        this.varBuffer[this.varBufferSize++] = localVar;
    }

    private int newLocal(int n) {
        int n2 = this.nextreg;
        int n3 = Code.width(n);
        this.nextreg = n2 + n3;
        if (this.nextreg > this.max_locals) {
            this.max_locals = this.nextreg;
        }
        return n2;
    }

    private int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public int newLocal(Symbol.VarSymbol varSymbol) {
        int n = varSymbol.adr = this.newLocal(varSymbol.erasure(this.types));
        this.addLocalVar(varSymbol);
        return n;
    }

    public void newRegSegment() {
        this.nextreg = this.max_locals;
    }

    public void endScopes(int n) {
        int n2 = this.nextreg;
        for (int i = this.nextreg = n; i < n2; ++i) {
            this.endScope(i);
        }
    }

    public static String mnem(int n) {
        return Mneumonics.mnem[n];
    }

    public static class Chain {
        public final int pc;
        State state;
        public final Chain next;

        public Chain(int n, Chain chain, State state) {
            this.pc = n;
            this.next = chain;
            this.state = state;
        }
    }

    static class LocalVar {
        final Symbol.VarSymbol sym;
        final char reg;
        char start_pc = (char)65535;
        char length = (char)65535;

        LocalVar(Symbol.VarSymbol varSymbol) {
            this.sym = varSymbol;
            this.reg = (char)varSymbol.adr;
        }

        public LocalVar dup() {
            return new LocalVar(this.sym);
        }

        public String toString() {
            return "" + this.sym + " in register " + this.reg + " starts at pc=" + this.start_pc + " length=" + this.length;
        }
    }

    private static class Mneumonics {
        private static final String[] mnem = new String[203];

        private Mneumonics() {
        }

        static {
            Mneumonics.mnem[0] = "nop";
            Mneumonics.mnem[1] = "aconst_null";
            Mneumonics.mnem[2] = "iconst_m1";
            Mneumonics.mnem[3] = "iconst_0";
            Mneumonics.mnem[4] = "iconst_1";
            Mneumonics.mnem[5] = "iconst_2";
            Mneumonics.mnem[6] = "iconst_3";
            Mneumonics.mnem[7] = "iconst_4";
            Mneumonics.mnem[8] = "iconst_5";
            Mneumonics.mnem[9] = "lconst_0";
            Mneumonics.mnem[10] = "lconst_1";
            Mneumonics.mnem[11] = "fconst_0";
            Mneumonics.mnem[12] = "fconst_1";
            Mneumonics.mnem[13] = "fconst_2";
            Mneumonics.mnem[14] = "dconst_0";
            Mneumonics.mnem[15] = "dconst_1";
            Mneumonics.mnem[16] = "bipush";
            Mneumonics.mnem[17] = "sipush";
            Mneumonics.mnem[18] = "ldc1";
            Mneumonics.mnem[19] = "ldc2";
            Mneumonics.mnem[20] = "ldc2w";
            Mneumonics.mnem[21] = "iload";
            Mneumonics.mnem[22] = "lload";
            Mneumonics.mnem[23] = "fload";
            Mneumonics.mnem[24] = "dload";
            Mneumonics.mnem[25] = "aload";
            Mneumonics.mnem[26] = "iload_0";
            Mneumonics.mnem[30] = "lload_0";
            Mneumonics.mnem[34] = "fload_0";
            Mneumonics.mnem[38] = "dload_0";
            Mneumonics.mnem[42] = "aload_0";
            Mneumonics.mnem[27] = "iload_1";
            Mneumonics.mnem[31] = "lload_1";
            Mneumonics.mnem[35] = "fload_1";
            Mneumonics.mnem[39] = "dload_1";
            Mneumonics.mnem[43] = "aload_1";
            Mneumonics.mnem[28] = "iload_2";
            Mneumonics.mnem[32] = "lload_2";
            Mneumonics.mnem[36] = "fload_2";
            Mneumonics.mnem[40] = "dload_2";
            Mneumonics.mnem[44] = "aload_2";
            Mneumonics.mnem[29] = "iload_3";
            Mneumonics.mnem[33] = "lload_3";
            Mneumonics.mnem[37] = "fload_3";
            Mneumonics.mnem[41] = "dload_3";
            Mneumonics.mnem[45] = "aload_3";
            Mneumonics.mnem[46] = "iaload";
            Mneumonics.mnem[47] = "laload";
            Mneumonics.mnem[48] = "faload";
            Mneumonics.mnem[49] = "daload";
            Mneumonics.mnem[50] = "aaload";
            Mneumonics.mnem[51] = "baload";
            Mneumonics.mnem[52] = "caload";
            Mneumonics.mnem[53] = "saload";
            Mneumonics.mnem[54] = "istore";
            Mneumonics.mnem[55] = "lstore";
            Mneumonics.mnem[56] = "fstore";
            Mneumonics.mnem[57] = "dstore";
            Mneumonics.mnem[58] = "astore";
            Mneumonics.mnem[59] = "istore_0";
            Mneumonics.mnem[63] = "lstore_0";
            Mneumonics.mnem[67] = "fstore_0";
            Mneumonics.mnem[71] = "dstore_0";
            Mneumonics.mnem[75] = "astore_0";
            Mneumonics.mnem[60] = "istore_1";
            Mneumonics.mnem[64] = "lstore_1";
            Mneumonics.mnem[68] = "fstore_1";
            Mneumonics.mnem[72] = "dstore_1";
            Mneumonics.mnem[76] = "astore_1";
            Mneumonics.mnem[61] = "istore_2";
            Mneumonics.mnem[65] = "lstore_2";
            Mneumonics.mnem[69] = "fstore_2";
            Mneumonics.mnem[73] = "dstore_2";
            Mneumonics.mnem[77] = "astore_2";
            Mneumonics.mnem[62] = "istore_3";
            Mneumonics.mnem[66] = "lstore_3";
            Mneumonics.mnem[70] = "fstore_3";
            Mneumonics.mnem[74] = "dstore_3";
            Mneumonics.mnem[78] = "astore_3";
            Mneumonics.mnem[79] = "iastore";
            Mneumonics.mnem[80] = "lastore";
            Mneumonics.mnem[81] = "fastore";
            Mneumonics.mnem[82] = "dastore";
            Mneumonics.mnem[83] = "aastore";
            Mneumonics.mnem[84] = "bastore";
            Mneumonics.mnem[85] = "castore";
            Mneumonics.mnem[86] = "sastore";
            Mneumonics.mnem[87] = "pop";
            Mneumonics.mnem[88] = "pop2";
            Mneumonics.mnem[89] = "dup";
            Mneumonics.mnem[90] = "dup_x1";
            Mneumonics.mnem[91] = "dup_x2";
            Mneumonics.mnem[92] = "dup2";
            Mneumonics.mnem[93] = "dup2_x1";
            Mneumonics.mnem[94] = "dup2_x2";
            Mneumonics.mnem[95] = "swap";
            Mneumonics.mnem[96] = "iadd";
            Mneumonics.mnem[97] = "ladd";
            Mneumonics.mnem[98] = "fadd";
            Mneumonics.mnem[99] = "dadd";
            Mneumonics.mnem[100] = "isub";
            Mneumonics.mnem[101] = "lsub";
            Mneumonics.mnem[102] = "fsub";
            Mneumonics.mnem[103] = "dsub";
            Mneumonics.mnem[104] = "imul";
            Mneumonics.mnem[105] = "lmul";
            Mneumonics.mnem[106] = "fmul";
            Mneumonics.mnem[107] = "dmul";
            Mneumonics.mnem[108] = "idiv";
            Mneumonics.mnem[109] = "ldiv";
            Mneumonics.mnem[110] = "fdiv";
            Mneumonics.mnem[111] = "ddiv";
            Mneumonics.mnem[112] = "imod";
            Mneumonics.mnem[113] = "lmod";
            Mneumonics.mnem[114] = "fmod";
            Mneumonics.mnem[115] = "dmod";
            Mneumonics.mnem[116] = "ineg";
            Mneumonics.mnem[117] = "lneg";
            Mneumonics.mnem[118] = "fneg";
            Mneumonics.mnem[119] = "dneg";
            Mneumonics.mnem[120] = "ishl";
            Mneumonics.mnem[121] = "lshl";
            Mneumonics.mnem[122] = "ishr";
            Mneumonics.mnem[123] = "lshr";
            Mneumonics.mnem[124] = "iushr";
            Mneumonics.mnem[125] = "lushr";
            Mneumonics.mnem[126] = "iand";
            Mneumonics.mnem[127] = "land";
            Mneumonics.mnem[128] = "ior";
            Mneumonics.mnem[129] = "lor";
            Mneumonics.mnem[130] = "ixor";
            Mneumonics.mnem[131] = "lxor";
            Mneumonics.mnem[132] = "iinc";
            Mneumonics.mnem[133] = "i2l";
            Mneumonics.mnem[134] = "i2f";
            Mneumonics.mnem[135] = "i2d";
            Mneumonics.mnem[136] = "l2i";
            Mneumonics.mnem[137] = "l2f";
            Mneumonics.mnem[138] = "l2d";
            Mneumonics.mnem[139] = "f2i";
            Mneumonics.mnem[140] = "f2l";
            Mneumonics.mnem[141] = "f2d";
            Mneumonics.mnem[142] = "d2i";
            Mneumonics.mnem[143] = "d2l";
            Mneumonics.mnem[144] = "d2f";
            Mneumonics.mnem[145] = "int2byte";
            Mneumonics.mnem[146] = "int2char";
            Mneumonics.mnem[147] = "int2short";
            Mneumonics.mnem[148] = "lcmp";
            Mneumonics.mnem[149] = "fcmpl";
            Mneumonics.mnem[150] = "fcmpg";
            Mneumonics.mnem[151] = "dcmpl";
            Mneumonics.mnem[152] = "dcmpg";
            Mneumonics.mnem[153] = "ifeq";
            Mneumonics.mnem[154] = "ifne";
            Mneumonics.mnem[155] = "iflt";
            Mneumonics.mnem[156] = "ifge";
            Mneumonics.mnem[157] = "ifgt";
            Mneumonics.mnem[158] = "ifle";
            Mneumonics.mnem[159] = "if_icmpeq";
            Mneumonics.mnem[160] = "if_icmpne";
            Mneumonics.mnem[161] = "if_icmplt";
            Mneumonics.mnem[162] = "if_icmpge";
            Mneumonics.mnem[163] = "if_icmpgt";
            Mneumonics.mnem[164] = "if_icmple";
            Mneumonics.mnem[165] = "if_acmpeq";
            Mneumonics.mnem[166] = "if_acmpne";
            Mneumonics.mnem[167] = "goto_";
            Mneumonics.mnem[168] = "jsr";
            Mneumonics.mnem[169] = "ret";
            Mneumonics.mnem[170] = "tableswitch";
            Mneumonics.mnem[171] = "lookupswitch";
            Mneumonics.mnem[172] = "ireturn";
            Mneumonics.mnem[173] = "lreturn";
            Mneumonics.mnem[174] = "freturn";
            Mneumonics.mnem[175] = "dreturn";
            Mneumonics.mnem[176] = "areturn";
            Mneumonics.mnem[177] = "return_";
            Mneumonics.mnem[178] = "getstatic";
            Mneumonics.mnem[179] = "putstatic";
            Mneumonics.mnem[180] = "getfield";
            Mneumonics.mnem[181] = "putfield";
            Mneumonics.mnem[182] = "invokevirtual";
            Mneumonics.mnem[183] = "invokespecial";
            Mneumonics.mnem[184] = "invokestatic";
            Mneumonics.mnem[185] = "invokeinterface";
            Mneumonics.mnem[187] = "new_";
            Mneumonics.mnem[188] = "newarray";
            Mneumonics.mnem[189] = "anewarray";
            Mneumonics.mnem[190] = "arraylength";
            Mneumonics.mnem[191] = "athrow";
            Mneumonics.mnem[192] = "checkcast";
            Mneumonics.mnem[193] = "instanceof_";
            Mneumonics.mnem[194] = "monitorenter";
            Mneumonics.mnem[195] = "monitorexit";
            Mneumonics.mnem[196] = "wide";
            Mneumonics.mnem[197] = "multianewarray";
            Mneumonics.mnem[198] = "if_acmp_null";
            Mneumonics.mnem[199] = "if_acmp_nonnull";
            Mneumonics.mnem[200] = "goto_w";
            Mneumonics.mnem[201] = "jsr_w";
            Mneumonics.mnem[202] = "breakpoint";
        }
    }

    static class StackMapFrame {
        int pc;
        Type[] locals;
        Type[] stack;

        StackMapFrame() {
        }
    }

    class State
    implements Cloneable {
        Bits defined = new Bits();
        Type[] stack = new Type[16];
        int stacksize;
        int[] locks;
        int nlocks;

        State() {
        }

        State dup() {
            try {
                State state = (State)super.clone();
                state.defined = this.defined.dup();
                state.stack = (Type[])this.stack.clone();
                if (this.locks != null) {
                    state.locks = (int[])this.locks.clone();
                }
                if (Code.this.debugCode) {
                    System.err.println("duping state " + this);
                    this.dump();
                }
                return state;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }

        void lock(int n) {
            if (this.locks == null) {
                this.locks = new int[20];
            } else if (this.locks.length == this.nlocks) {
                int[] nArray = new int[this.locks.length << 1];
                System.arraycopy(this.locks, 0, nArray, 0, this.locks.length);
                this.locks = nArray;
            }
            this.locks[this.nlocks] = n;
            ++this.nlocks;
        }

        void unlock(int n) {
            --this.nlocks;
            assert (this.locks[this.nlocks] == n);
            this.locks[this.nlocks] = -1;
        }

        void push(Type type) {
            if (Code.this.debugCode) {
                System.err.println("   pushing " + type);
            }
            switch (type.tag) {
                case 9: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: 
                case 8: {
                    type = Code.this.syms.intType;
                    break;
                }
            }
            if (this.stacksize + 2 >= this.stack.length) {
                Type[] typeArray = new Type[2 * this.stack.length];
                System.arraycopy(this.stack, 0, typeArray, 0, this.stack.length);
                this.stack = typeArray;
            }
            this.stack[this.stacksize++] = type;
            switch (Code.width(type)) {
                case 1: {
                    break;
                }
                case 2: {
                    this.stack[this.stacksize++] = null;
                    break;
                }
                default: {
                    throw new AssertionError(type);
                }
            }
            if (this.stacksize > Code.this.max_stack) {
                Code.this.max_stack = this.stacksize;
            }
        }

        Type pop1() {
            if (Code.this.debugCode) {
                System.err.println("   popping 1");
            }
            --this.stacksize;
            Type type = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            assert (type != null && Code.width(type) == 1);
            return type;
        }

        Type peek() {
            return this.stack[this.stacksize - 1];
        }

        Type pop2() {
            if (Code.this.debugCode) {
                System.err.println("   popping 2");
            }
            this.stacksize -= 2;
            Type type = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            assert (this.stack[this.stacksize + 1] == null);
            assert (type != null && Code.width(type) == 2);
            return type;
        }

        void pop(int n) {
            if (Code.this.debugCode) {
                System.err.println("   popping " + n);
            }
            while (n > 0) {
                this.stack[--this.stacksize] = null;
                --n;
            }
        }

        void pop(Type type) {
            this.pop(Code.width(type));
        }

        void forceStackTop(Type type) {
            switch (type.tag) {
                case 10: 
                case 11: {
                    int n = Code.width(type);
                    Type type2 = this.stack[this.stacksize - n];
                    assert (Code.this.types.isSubType(Code.this.types.erasure(type2), Code.this.types.erasure(type)));
                    this.stack[this.stacksize - n] = type;
                    break;
                }
            }
        }

        void markInitialized(UninitializedType uninitializedType) {
            int n;
            Type type = uninitializedType.initializedType();
            for (n = 0; n < this.stacksize; ++n) {
                if (this.stack[n] != uninitializedType) continue;
                this.stack[n] = type;
            }
            for (n = 0; n < Code.this.lvar.length; ++n) {
                LocalVar localVar = Code.this.lvar[n];
                if (localVar == null || localVar.sym.type != uninitializedType) continue;
                Symbol.VarSymbol varSymbol = localVar.sym;
                varSymbol = varSymbol.clone(varSymbol.owner);
                varSymbol.type = type;
                LocalVar localVar2 = Code.this.lvar[n] = new LocalVar(varSymbol);
                localVar2.start_pc = localVar.start_pc;
            }
        }

        State join(State state) {
            int n;
            this.defined = this.defined.andSet(state.defined);
            assert (this.stacksize == state.stacksize);
            assert (this.nlocks == state.nlocks);
            for (int i = 0; i < this.stacksize; i += n) {
                Type type = this.stack[i];
                Type type2 = state.stack[i];
                Type type3 = type == type2 ? type : (Code.this.types.isSubType(type, type2) ? type2 : (Code.this.types.isSubType(type2, type) ? type : this.error()));
                n = Code.width(type3);
                this.stack[i] = type3;
                if (n == 2) assert (this.stack[i + 1] == null);
            }
            return this;
        }

        Type error() {
            throw new AssertionError((Object)"inconsistent stack types at join point");
        }

        void dump() {
            this.dump(-1);
        }

        void dump(int n) {
            int n2;
            int n3;
            System.err.print("stackMap for " + Code.this.meth.owner + "." + Code.this.meth);
            if (n == -1) {
                System.out.println();
            } else {
                System.out.println(" at " + n);
            }
            System.err.println(" stack (from bottom):");
            for (n3 = 0; n3 < this.stacksize; ++n3) {
                System.err.println("  " + n3 + ": " + this.stack[n3]);
            }
            n3 = 0;
            for (n2 = Code.this.max_locals - 1; n2 >= 0; --n2) {
                if (!this.defined.isMember(n2)) continue;
                n3 = n2;
                break;
            }
            if (n3 >= 0) {
                System.err.println(" locals:");
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                System.err.print("  " + n2 + ": ");
                if (this.defined.isMember(n2)) {
                    LocalVar localVar = Code.this.lvar[n2];
                    if (localVar == null) {
                        System.err.println("(none)");
                        continue;
                    }
                    if (localVar.sym == null) {
                        System.err.println("UNKNOWN!");
                        continue;
                    }
                    System.err.println("" + localVar.sym + " of type " + localVar.sym.erasure(Code.this.types));
                    continue;
                }
                System.err.println("undefined");
            }
            if (this.nlocks != 0) {
                System.err.print(" locks:");
                for (n2 = 0; n2 < this.nlocks; ++n2) {
                    System.err.print(" " + this.locks[n2]);
                }
                System.err.println();
            }
        }
    }
}

