/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public abstract class Tree {
    public static final int TOPLEVEL = 1;
    public static final int IMPORT = 2;
    public static final int CLASSDEF = 3;
    public static final int METHODDEF = 4;
    public static final int VARDEF = 5;
    public static final int SKIP = 6;
    public static final int BLOCK = 7;
    public static final int DOLOOP = 8;
    public static final int WHILELOOP = 9;
    public static final int FORLOOP = 10;
    public static final int FOREACHLOOP = 11;
    public static final int LABELLED = 12;
    public static final int SWITCH = 13;
    public static final int CASE = 14;
    public static final int SYNCHRONIZED = 15;
    public static final int TRY = 16;
    public static final int CATCH = 17;
    public static final int CONDEXPR = 18;
    public static final int IF = 19;
    public static final int EXEC = 20;
    public static final int BREAK = 21;
    public static final int CONTINUE = 22;
    public static final int RETURN = 23;
    public static final int THROW = 24;
    public static final int ASSERT = 25;
    public static final int APPLY = 26;
    public static final int NEWCLASS = 27;
    public static final int NEWARRAY = 28;
    public static final int PARENS = 29;
    public static final int ASSIGN = 30;
    public static final int TYPECAST = 31;
    public static final int TYPETEST = 32;
    public static final int INDEXED = 33;
    public static final int SELECT = 34;
    public static final int IDENT = 35;
    public static final int LITERAL = 36;
    public static final int TYPEIDENT = 37;
    public static final int TYPEARRAY = 38;
    public static final int TYPEAPPLY = 39;
    public static final int TYPEPARAMETER = 40;
    public static final int TYPEARGUMENT = 41;
    public static final int TYPEBOUNDKIND = 42;
    public static final int ANNOTATION = 43;
    public static final int MODIFIERS = 44;
    public static final int ERRONEOUS = 45;
    public static final int POS = 46;
    public static final int NEG = 47;
    public static final int NOT = 48;
    public static final int COMPL = 49;
    public static final int PREINC = 50;
    public static final int PREDEC = 51;
    public static final int POSTINC = 52;
    public static final int POSTDEC = 53;
    public static final int NULLCHK = 54;
    public static final int OR = 55;
    public static final int AND = 56;
    public static final int BITOR = 57;
    public static final int BITXOR = 58;
    public static final int BITAND = 59;
    public static final int EQ = 60;
    public static final int NE = 61;
    public static final int LT = 62;
    public static final int GT = 63;
    public static final int LE = 64;
    public static final int GE = 65;
    public static final int SL = 66;
    public static final int SR = 67;
    public static final int USR = 68;
    public static final int PLUS = 69;
    public static final int MINUS = 70;
    public static final int MUL = 71;
    public static final int DIV = 72;
    public static final int MOD = 73;
    public static final int BITOR_ASG = 74;
    public static final int BITXOR_ASG = 75;
    public static final int BITAND_ASG = 76;
    public static final int SL_ASG = 83;
    public static final int SR_ASG = 84;
    public static final int USR_ASG = 85;
    public static final int PLUS_ASG = 86;
    public static final int MINUS_ASG = 87;
    public static final int MUL_ASG = 88;
    public static final int DIV_ASG = 89;
    public static final int MOD_ASG = 90;
    public static final int LETEXPR = 91;
    public static final int ASGOffset = 17;
    public int pos;
    public Type type;
    public int tag;

    public Tree(int n) {
        this.tag = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        new Pretty(new PrintWriter(stringWriter), false).printExpr(this);
        return stringWriter.toString();
    }

    public Tree setPos(int n) {
        this.pos = n;
        return this;
    }

    public Tree setType(Type type) {
        this.type = type;
        return this;
    }

    public abstract void accept(Visitor var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Annotation
    extends Tree {
        public Tree annotationType;
        public List<Tree> args;

        public Annotation(Tree tree, List<Tree> list) {
            super(43);
            this.annotationType = tree;
            this.args = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitAnnotation(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Apply
    extends Tree {
        public List<Tree> typeargs;
        public Tree meth;
        public List<Tree> args;
        public Type varargsElement;

        public Apply(List<Tree> list, Tree tree, List<Tree> list2) {
            super(26);
            this.typeargs = list;
            this.meth = tree;
            this.args = list2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitApply(this);
        }
    }

    public static class Assert
    extends Tree {
        public Tree cond;
        public Tree detail;

        public Assert(Tree tree, Tree tree2) {
            super(25);
            this.cond = tree;
            this.detail = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitAssert(this);
        }
    }

    public static class Assign
    extends Tree {
        public Tree lhs;
        public Tree rhs;

        public Assign(Tree tree, Tree tree2) {
            super(30);
            this.lhs = tree;
            this.rhs = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitAssign(this);
        }
    }

    public static class Assignop
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public Assignop(int n, Tree tree, Tree tree2, Symbol symbol) {
            super(n);
            this.lhs = tree;
            this.rhs = tree2;
            this.operator = symbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitAssignop(this);
        }
    }

    public static class Binary
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public Binary(int n, Tree tree, Tree tree2, Symbol symbol) {
            super(n);
            this.lhs = tree;
            this.rhs = tree2;
            this.operator = symbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitBinary(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Block
    extends Tree {
        public long flags;
        public List<Tree> stats;
        public int endpos = 0;

        public Block(long l, List<Tree> list) {
            super(7);
            this.stats = list;
            this.flags = l;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitBlock(this);
        }
    }

    public static class Break
    extends Tree {
        public Name label;
        public Tree target;

        public Break(Name name, Tree tree) {
            super(21);
            this.label = name;
            this.target = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitBreak(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Case
    extends Tree {
        public Tree pat;
        public List<Tree> stats;

        public Case(Tree tree, List<Tree> list) {
            super(14);
            this.pat = tree;
            this.stats = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCase(this);
        }
    }

    public static class Catch
    extends Tree {
        public VarDef param;
        public Tree body;

        public Catch(VarDef varDef, Tree tree) {
            super(17);
            this.param = varDef;
            this.body = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitCatch(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public List<TypeParameter> typarams;
        public Tree extending;
        public List<Tree> implementing;
        public List<Tree> defs;
        public Symbol.ClassSymbol sym;

        public ClassDef(Modifiers modifiers, Name name, List<TypeParameter> list, Tree tree, List<Tree> list2, List<Tree> list3, Symbol.ClassSymbol classSymbol) {
            super(3);
            this.mods = modifiers;
            this.name = name;
            this.typarams = list;
            this.extending = tree;
            this.implementing = list2;
            this.defs = list3;
            this.sym = classSymbol;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitClassDef(this);
        }
    }

    public static class Conditional
    extends Tree {
        public Tree cond;
        public Tree truepart;
        public Tree falsepart;

        public Conditional(Tree tree, Tree tree2, Tree tree3) {
            super(18);
            this.cond = tree;
            this.truepart = tree2;
            this.falsepart = tree3;
        }

        public void accept(Visitor visitor) {
            visitor.visitConditional(this);
        }
    }

    public static class Continue
    extends Tree {
        public Name label;
        public Tree target;

        public Continue(Name name, Tree tree) {
            super(22);
            this.label = name;
            this.target = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitContinue(this);
        }
    }

    public static class DoLoop
    extends Tree {
        public Tree body;
        public Tree cond;

        public DoLoop(Tree tree, Tree tree2) {
            super(8);
            this.body = tree;
            this.cond = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitDoLoop(this);
        }
    }

    public static class Erroneous
    extends Tree {
        public Erroneous() {
            super(45);
        }

        public void accept(Visitor visitor) {
            visitor.visitErroneous(this);
        }
    }

    public static class Exec
    extends Tree {
        public Tree expr;

        public Exec(Tree tree) {
            super(20);
            this.expr = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitExec(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public TopLevel TopLevel(List<Annotation> var1, Tree var2, List<Tree> var3);

        public Import Import(Tree var1, boolean var2);

        public ClassDef ClassDef(Modifiers var1, Name var2, List<TypeParameter> var3, Tree var4, List<Tree> var5, List<Tree> var6);

        public MethodDef MethodDef(Modifiers var1, Name var2, Tree var3, List<TypeParameter> var4, List<VarDef> var5, List<Tree> var6, Block var7, Tree var8);

        public VarDef VarDef(Modifiers var1, Name var2, Tree var3, Tree var4);

        public Skip Skip();

        public Block Block(long var1, List<Tree> var3);

        public DoLoop DoLoop(Tree var1, Tree var2);

        public WhileLoop WhileLoop(Tree var1, Tree var2);

        public ForLoop ForLoop(List<Tree> var1, Tree var2, List<Tree> var3, Tree var4);

        public ForeachLoop ForeachLoop(VarDef var1, Tree var2, Tree var3);

        public Labelled Labelled(Name var1, Tree var2);

        public Switch Switch(Tree var1, List<Case> var2);

        public Case Case(Tree var1, List<Tree> var2);

        public Synchronized Synchronized(Tree var1, Tree var2);

        public Try Try(Tree var1, List<Catch> var2, Tree var3);

        public Catch Catch(VarDef var1, Tree var2);

        public Conditional Conditional(Tree var1, Tree var2, Tree var3);

        public If If(Tree var1, Tree var2, Tree var3);

        public Exec Exec(Tree var1);

        public Break Break(Name var1);

        public Continue Continue(Name var1);

        public Return Return(Tree var1);

        public Throw Throw(Tree var1);

        public Apply Apply(List<Tree> var1, Tree var2, List<Tree> var3);

        public NewClass NewClass(Tree var1, List<Tree> var2, Tree var3, List<Tree> var4, ClassDef var5);

        public NewArray NewArray(Tree var1, List<Tree> var2, List<Tree> var3);

        public Parens Parens(Tree var1);

        public Assign Assign(Tree var1, Tree var2);

        public Assignop Assignop(int var1, Tree var2, Tree var3);

        public Unary Unary(int var1, Tree var2);

        public Binary Binary(int var1, Tree var2, Tree var3);

        public TypeCast TypeCast(Tree var1, Tree var2);

        public TypeTest TypeTest(Tree var1, Tree var2);

        public Indexed Indexed(Tree var1, Tree var2);

        public Select Select(Tree var1, Name var2);

        public Ident Ident(Name var1);

        public Literal Literal(int var1, Object var2);

        public TypeIdent TypeIdent(int var1);

        public TypeArray TypeArray(Tree var1);

        public TypeApply TypeApply(Tree var1, List<Tree> var2);

        public TypeParameter TypeParameter(Name var1, List<Tree> var2);

        public TypeArgument TypeArgument(TypeBoundKind var1, Tree var2);

        public TypeBoundKind TypeBoundKind(BoundKind var1);

        public Annotation Annotation(Tree var1, List<Tree> var2);

        public Modifiers Modifiers(long var1, List<Annotation> var3);

        public Erroneous Erroneous();

        public LetExpr LetExpr(List<VarDef> var1, Tree var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoop
    extends Tree {
        public List<Tree> init;
        public Tree cond;
        public List<Tree> step;
        public Tree body;

        public ForLoop(List<Tree> list, Tree tree, List<Tree> list2, Tree tree2) {
            super(10);
            this.init = list;
            this.cond = tree;
            this.step = list2;
            this.body = tree2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitForLoop(this);
        }
    }

    public static class ForeachLoop
    extends Tree {
        public VarDef var;
        public Tree expr;
        public Tree body;

        public ForeachLoop(VarDef varDef, Tree tree, Tree tree2) {
            super(10);
            this.var = varDef;
            this.expr = tree;
            this.body = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitForeachLoop(this);
        }
    }

    public static class Ident
    extends Tree {
        public Name name;
        public Symbol sym;

        public Ident(Name name, Symbol symbol) {
            super(35);
            this.name = name;
            this.sym = symbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitIdent(this);
        }
    }

    public static class If
    extends Tree {
        public Tree cond;
        public Tree thenpart;
        public Tree elsepart;

        public If(Tree tree, Tree tree2, Tree tree3) {
            super(19);
            this.cond = tree;
            this.thenpart = tree2;
            this.elsepart = tree3;
        }

        public void accept(Visitor visitor) {
            visitor.visitIf(this);
        }
    }

    public static class Import
    extends Tree {
        public boolean staticImport;
        public Tree qualid;

        public Import(Tree tree, boolean bl) {
            super(2);
            this.qualid = tree;
            this.staticImport = bl;
        }

        public void accept(Visitor visitor) {
            visitor.visitImport(this);
        }
    }

    public static class Indexed
    extends Tree {
        public Tree indexed;
        public Tree index;

        public Indexed(Tree tree, Tree tree2) {
            super(33);
            this.indexed = tree;
            this.index = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitIndexed(this);
        }
    }

    public static class Labelled
    extends Tree {
        public Name label;
        public Tree body;

        public Labelled(Name name, Tree tree) {
            super(12);
            this.label = name;
            this.body = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitLabelled(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LetExpr
    extends Tree {
        public List<VarDef> defs;
        public Tree expr;

        public LetExpr(List<VarDef> list, Tree tree) {
            super(91);
            this.defs = list;
            this.expr = tree;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitLetExpr(this);
        }
    }

    public static class Literal
    extends Tree {
        public int typetag;
        public Object value;

        public Literal(int n, Object object) {
            super(36);
            this.typetag = n;
            this.value = object;
        }

        public void accept(Visitor visitor) {
            visitor.visitLiteral(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public Tree restype;
        public List<TypeParameter> typarams;
        public List<VarDef> params;
        public List<Tree> thrown;
        public Block body;
        public Tree defaultValue;
        public Symbol.MethodSymbol sym;

        public MethodDef(Modifiers modifiers, Name name, Tree tree, List<TypeParameter> list, List<VarDef> list2, List<Tree> list3, Block block, Tree tree2, Symbol.MethodSymbol methodSymbol) {
            super(4);
            this.mods = modifiers;
            this.name = name;
            this.restype = tree;
            this.typarams = list;
            this.params = list2;
            this.thrown = list3;
            this.body = block;
            this.defaultValue = tree2;
            this.sym = methodSymbol;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMethodDef(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Modifiers
    extends Tree {
        public long flags;
        public List<Annotation> annotations;

        public Modifiers(long l, List<Annotation> list) {
            super(44);
            this.flags = l;
            this.annotations = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitModifiers(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArray
    extends Tree {
        public Tree elemtype;
        public List<Tree> dims;
        public List<Tree> elems;

        public NewArray(Tree tree, List<Tree> list, List<Tree> list2) {
            super(28);
            this.elemtype = tree;
            this.dims = list;
            this.elems = list2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewArray(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewClass
    extends Tree {
        public Tree encl;
        public List<Tree> typeargs;
        public Tree clazz;
        public List<Tree> args;
        public ClassDef def;
        public Symbol constructor;
        public Type varargsElement;

        public NewClass(Tree tree, List<Tree> list, Tree tree2, List<Tree> list2, ClassDef classDef) {
            super(27);
            this.encl = tree;
            this.typeargs = list;
            this.clazz = tree2;
            this.args = list2;
            this.def = classDef;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewClass(this);
        }
    }

    public static class Parens
    extends Tree {
        public Tree expr;

        public Parens(Tree tree) {
            super(29);
            this.expr = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitParens(this);
        }
    }

    public static class Return
    extends Tree {
        public Tree expr;

        public Return(Tree tree) {
            super(23);
            this.expr = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitReturn(this);
        }
    }

    public static class Select
    extends Tree {
        public Tree selected;
        public Name name;
        public Symbol sym;

        public Select(Tree tree, Name name, Symbol symbol) {
            super(34);
            this.selected = tree;
            this.name = name;
            this.sym = symbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitSelect(this);
        }
    }

    public static class Skip
    extends Tree {
        public Skip() {
            super(6);
        }

        public void accept(Visitor visitor) {
            visitor.visitSkip(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Switch
    extends Tree {
        public Tree selector;
        public List<Case> cases;

        public Switch(Tree tree, List<Case> list) {
            super(13);
            this.selector = tree;
            this.cases = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSwitch(this);
        }
    }

    public static class Synchronized
    extends Tree {
        public Tree lock;
        public Tree body;

        public Synchronized(Tree tree, Tree tree2) {
            super(15);
            this.lock = tree;
            this.body = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitSynchronized(this);
        }
    }

    public static class Throw
    extends Tree {
        public Tree expr;

        public Throw(Tree tree) {
            super(24);
            this.expr = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitThrow(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopLevel
    extends Tree {
        public List<Annotation> packageAnnotations;
        public Tree pid;
        public List<Tree> defs;
        public Name sourcefile;
        public Symbol.PackageSymbol packge;
        public Scope namedImportScope;
        public Scope starImportScope;
        public long flags;
        public Map<Tree, String> docComments = null;
        public Map<Tree, Integer> endPositions = null;

        public TopLevel(List<Annotation> list, Tree tree, List<Tree> list2, Name name, Symbol.PackageSymbol packageSymbol, Scope scope, Scope scope2) {
            super(1);
            this.packageAnnotations = list;
            this.pid = tree;
            this.defs = list2;
            this.sourcefile = name;
            this.packge = packageSymbol;
            this.namedImportScope = scope;
            this.starImportScope = scope2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTopLevel(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Try
    extends Tree {
        public Tree body;
        public List<Catch> catchers;
        public Tree finalizer;

        public Try(Tree tree, List<Catch> list, Tree tree2) {
            super(16);
            this.body = tree;
            this.catchers = list;
            this.finalizer = tree2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTry(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeApply
    extends Tree {
        public Tree clazz;
        public List<Tree> arguments;

        public TypeApply(Tree tree, List<Tree> list) {
            super(39);
            this.clazz = tree;
            this.arguments = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTypeApply(this);
        }
    }

    public static class TypeArgument
    extends Tree {
        public BoundKind kind;
        public Tree inner;

        public TypeArgument(TypeBoundKind typeBoundKind, Tree tree) {
            super(41);
            this.kind = typeBoundKind.kind;
            this.inner = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeArgument(this);
        }
    }

    public static class TypeArray
    extends Tree {
        public Tree elemtype;

        public TypeArray(Tree tree) {
            super(38);
            this.elemtype = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeArray(this);
        }
    }

    public static class TypeBoundKind
    extends Tree {
        public BoundKind kind;

        public TypeBoundKind(BoundKind boundKind) {
            super(42);
            this.kind = boundKind;
        }

        public void accept(Visitor visitor) {
            visitor.visitTree(this);
        }
    }

    public static class TypeCast
    extends Tree {
        public Tree clazz;
        public Tree expr;

        public TypeCast(Tree tree, Tree tree2) {
            super(31);
            this.clazz = tree;
            this.expr = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeCast(this);
        }
    }

    public static class TypeIdent
    extends Tree {
        public int typetag;

        public TypeIdent(int n) {
            super(37);
            this.typetag = n;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeIdent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeParameter
    extends Tree {
        public Name name;
        public List<Tree> bounds;

        public TypeParameter(Name name, List<Tree> list) {
            super(40);
            this.name = name;
            this.bounds = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTypeParameter(this);
        }
    }

    public static class TypeTest
    extends Tree {
        public Tree expr;
        public Tree clazz;

        public TypeTest(Tree tree, Tree tree2) {
            super(32);
            this.expr = tree;
            this.clazz = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeTest(this);
        }
    }

    public static class Unary
    extends Tree {
        public Tree arg;
        public Symbol operator;

        public Unary(int n, Tree tree) {
            super(n);
            this.arg = tree;
        }

        public void accept(Visitor visitor) {
            visitor.visitUnary(this);
        }
    }

    public static class VarDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public Tree vartype;
        public Tree init;
        public Symbol.VarSymbol sym;

        public VarDef(Modifiers modifiers, Name name, Tree tree, Tree tree2, Symbol.VarSymbol varSymbol) {
            super(5);
            this.mods = modifiers;
            this.name = name;
            this.vartype = tree;
            this.init = tree2;
            this.sym = varSymbol;
        }

        public void accept(Visitor visitor) {
            visitor.visitVarDef(this);
        }
    }

    public static abstract class Visitor {
        public void visitTopLevel(TopLevel topLevel) {
            this.visitTree(topLevel);
        }

        public void visitImport(Import import_) {
            this.visitTree(import_);
        }

        public void visitClassDef(ClassDef classDef) {
            this.visitTree(classDef);
        }

        public void visitMethodDef(MethodDef methodDef) {
            this.visitTree(methodDef);
        }

        public void visitVarDef(VarDef varDef) {
            this.visitTree(varDef);
        }

        public void visitSkip(Skip skip) {
            this.visitTree(skip);
        }

        public void visitBlock(Block block) {
            this.visitTree(block);
        }

        public void visitDoLoop(DoLoop doLoop) {
            this.visitTree(doLoop);
        }

        public void visitWhileLoop(WhileLoop whileLoop) {
            this.visitTree(whileLoop);
        }

        public void visitForLoop(ForLoop forLoop) {
            this.visitTree(forLoop);
        }

        public void visitForeachLoop(ForeachLoop foreachLoop) {
            this.visitTree(foreachLoop);
        }

        public void visitLabelled(Labelled labelled) {
            this.visitTree(labelled);
        }

        public void visitSwitch(Switch switch_) {
            this.visitTree(switch_);
        }

        public void visitCase(Case case_) {
            this.visitTree(case_);
        }

        public void visitSynchronized(Synchronized synchronized_) {
            this.visitTree(synchronized_);
        }

        public void visitTry(Try try_) {
            this.visitTree(try_);
        }

        public void visitCatch(Catch catch_) {
            this.visitTree(catch_);
        }

        public void visitConditional(Conditional conditional) {
            this.visitTree(conditional);
        }

        public void visitIf(If if_) {
            this.visitTree(if_);
        }

        public void visitExec(Exec exec) {
            this.visitTree(exec);
        }

        public void visitBreak(Break break_) {
            this.visitTree(break_);
        }

        public void visitContinue(Continue continue_) {
            this.visitTree(continue_);
        }

        public void visitReturn(Return return_) {
            this.visitTree(return_);
        }

        public void visitThrow(Throw throw_) {
            this.visitTree(throw_);
        }

        public void visitAssert(Assert assert_) {
            this.visitTree(assert_);
        }

        public void visitApply(Apply apply) {
            this.visitTree(apply);
        }

        public void visitNewClass(NewClass newClass) {
            this.visitTree(newClass);
        }

        public void visitNewArray(NewArray newArray) {
            this.visitTree(newArray);
        }

        public void visitParens(Parens parens) {
            this.visitTree(parens);
        }

        public void visitAssign(Assign assign) {
            this.visitTree(assign);
        }

        public void visitAssignop(Assignop assignop) {
            this.visitTree(assignop);
        }

        public void visitUnary(Unary unary) {
            this.visitTree(unary);
        }

        public void visitBinary(Binary binary) {
            this.visitTree(binary);
        }

        public void visitTypeCast(TypeCast typeCast) {
            this.visitTree(typeCast);
        }

        public void visitTypeTest(TypeTest typeTest) {
            this.visitTree(typeTest);
        }

        public void visitIndexed(Indexed indexed) {
            this.visitTree(indexed);
        }

        public void visitSelect(Select select) {
            this.visitTree(select);
        }

        public void visitIdent(Ident ident) {
            this.visitTree(ident);
        }

        public void visitLiteral(Literal literal) {
            this.visitTree(literal);
        }

        public void visitTypeIdent(TypeIdent typeIdent) {
            this.visitTree(typeIdent);
        }

        public void visitTypeArray(TypeArray typeArray) {
            this.visitTree(typeArray);
        }

        public void visitTypeApply(TypeApply typeApply) {
            this.visitTree(typeApply);
        }

        public void visitTypeParameter(TypeParameter typeParameter) {
            this.visitTree(typeParameter);
        }

        public void visitTypeArgument(TypeArgument typeArgument) {
            this.visitTree(typeArgument);
        }

        public void visitAnnotation(Annotation annotation) {
            this.visitTree(annotation);
        }

        public void visitModifiers(Modifiers modifiers) {
            this.visitTree(modifiers);
        }

        public void visitErroneous(Erroneous erroneous) {
            this.visitTree(erroneous);
        }

        public void visitLetExpr(LetExpr letExpr) {
            this.visitTree(letExpr);
        }

        public void visitTree(Tree tree) {
            assert (false);
        }
    }

    public static class WhileLoop
    extends Tree {
        public Tree cond;
        public Tree body;

        public WhileLoop(Tree tree, Tree tree2) {
            super(9);
            this.cond = tree;
            this.body = tree2;
        }

        public void accept(Visitor visitor) {
            visitor.visitWhileLoop(this);
        }
    }
}

