/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.lang.reflect.Method;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class dataObject;
    private static Method getNodeDelegate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{SaveCookie.class};
    }

    protected void performAction(Node[] nodeArray) {
        SaveCookie saveCookie = (SaveCookie)nodeArray[0].getCookie(SaveCookie.class);
        if (!$assertionsDisabled && saveCookie == null) {
            throw new AssertionError((Object)("SaveCookie must be present on " + nodeArray[0] + ". " + "See http://www.netbeans.org/issues/show_bug.cgi?id=68285 for details on overriding " + nodeArray[0].getClass().getName() + ".getCookie correctly."));
        }
        if (saveCookie == null) {
            return;
        }
        try {
            saveCookie.save();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)SaveAction.class, (String)"MSG_saved", (Object)this.getSaveMessage(nodeArray[0])));
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage((Class)SaveAction.class, (String)"EXC_notsaved", (Object)this.getSaveMessage(nodeArray[0])));
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(Node node) {
        Object object;
        if (dataObject == null) {
            object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (object == null) {
                object = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, (ClassLoader)object);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if (getNodeDelegate != null && (object = node.getCookie(dataObject)) != null) {
            try {
                node = (Node)getNodeDelegate.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return node.getDisplayName();
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage((Class)SaveAction.class, (String)"Save");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }

    static {
        $assertionsDisabled = !SaveAction.class.desiredAssertionStatus();
    }
}

