/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.editor.mimelookup.MimePathLookup;

public final class MimePath {
    public static final MimePath EMPTY = new MimePath();
    private static final Object LOCK = new Object();
    private static final ArrayList<MimePath> LRU = new ArrayList();
    static final int MAX_LRU_SIZE = 3;
    private static final String REG_NAME = "[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}";
    private static final Pattern MIME_TYPE_PATTERN = Pattern.compile("^[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}/{1}[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}$");
    private final MimePath[] mimePaths;
    private final String path;
    private final String mimeType;
    private Map<String, SoftReference<MimePath>> mimeType2mimePathRef;
    private MimePathLookup lookup;
    private final String LOOKUP_LOCK = new String("MimePath.LOOKUP_LOCK");

    public static MimePath get(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        return MimePath.get(EMPTY, string);
    }

    public static MimePath get(MimePath mimePath, String string) {
        return mimePath.getEmbedded(string);
    }

    public static MimePath parse(String string) {
        return MimePath.parseImpl(string);
    }

    private MimePath(MimePath mimePath, String string) {
        int n = mimePath.size();
        this.mimePaths = new MimePath[n + 1];
        System.arraycopy(mimePath.mimePaths, 0, this.mimePaths, 0, n);
        this.mimePaths[n] = this;
        String string2 = mimePath.path;
        this.path = string2 != null && string2.length() > 0 ? (string2 + '/' + string).intern() : string.intern();
        this.mimeType = string;
    }

    private MimePath() {
        this.mimePaths = new MimePath[0];
        this.path = "";
        this.mimeType = "";
    }

    public String getPath() {
        return this.path;
    }

    public int size() {
        return this.mimePaths.length;
    }

    public String getMimeType(int n) {
        return this.mimePaths[n].mimeType;
    }

    public MimePath getPrefix(int n) {
        return n == 0 ? EMPTY : this.mimePaths[n - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimePath getEmbedded(String string) {
        Object object = LOCK;
        synchronized (object) {
            MimePath mimePath;
            Reference reference;
            if (this.mimeType2mimePathRef == null) {
                this.mimeType2mimePathRef = new HashMap<String, SoftReference<MimePath>>();
            }
            if ((reference = (Reference)this.mimeType2mimePathRef.get(string)) == null || (mimePath = (MimePath)reference.get()) == null) {
                Matcher matcher = MIME_TYPE_PATTERN.matcher(string);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid mimeType=\"" + string + "\"");
                }
                mimePath = new MimePath(this, string);
                this.mimeType2mimePathRef.put(string, new SoftReference<MimePath>(mimePath));
                LRU.add(0, mimePath);
                if (LRU.size() > 3) {
                    LRU.remove(LRU.size() - 1);
                }
            }
            return mimePath;
        }
    }

    private static MimePath parseImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        MimePath mimePath = EMPTY;
        int n = string.length();
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = -1;
            for (n3 = n2; n3 < n; ++n3) {
                if (string.charAt(n3) != '/') continue;
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                if (n3 == n2) break;
                throw new IllegalArgumentException("mimeType '" + string.substring(n2) + "' does not contain '/'.");
            }
            ++n3;
            while (n3 < n) {
                if (string.charAt(n3) == '/') {
                    if (n3 != n4 + 1) break;
                    throw new IllegalArgumentException("Two successive slashes in '" + string.substring(n2) + "'");
                }
                ++n3;
            }
            if (n3 == n4 + 1) {
                throw new IllegalArgumentException("Empty string after '/' in '" + string.substring(n2) + "'");
            }
            String string2 = string.substring(n2, n3);
            mimePath = MimePath.get(mimePath, string2);
            n2 = n3 + 1;
        }
        return mimePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MimePathLookup getLookup() {
        String string = this.LOOKUP_LOCK;
        synchronized (string) {
            if (this.lookup == null) {
                this.lookup = new MimePathLookup(this);
            }
            return this.lookup;
        }
    }
}

