/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.WeakHashMap;

public final class ClassName
implements Comparable,
Comparator,
Serializable {
    static final long serialVersionUID = -8444469778945723553L;
    private final String type;
    private final transient String internalName;
    private volatile transient String externalName;
    private volatile transient String packageName;
    private volatile transient String simpleName;
    private static final WeakHashMap<String, WeakReference<ClassName>> cache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassName getClassName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ClassName className = ClassName.getCacheEntry(string);
        if (className == null) {
            WeakHashMap<String, WeakReference<ClassName>> weakHashMap = cache;
            synchronized (weakHashMap) {
                className = ClassName.getCacheEntry(string);
                if (className == null) {
                    String string2;
                    int n = string.indexOf(76);
                    char c = string.charAt(string.length() - 1);
                    if (n != -1 && c == ';') {
                        string2 = string.substring(n + 1, string.length() - 1);
                        if (n > 0) {
                            string2 = string.substring(0, n) + string2;
                        }
                        if ((className = ClassName.getCacheEntry(string2)) != null) {
                            return className;
                        }
                    } else {
                        string2 = string;
                    }
                    className = new ClassName(string2);
                    cache.put(string2, new WeakReference<ClassName>(className));
                }
            }
        }
        return className;
    }

    private static ClassName getCacheEntry(String string) {
        WeakReference<ClassName> weakReference = cache.get(string);
        return weakReference != null ? (ClassName)weakReference.get() : null;
    }

    private ClassName(String string) {
        this.type = string;
        int n = string.lastIndexOf(91);
        this.internalName = n > -1 ? string.substring(n + 1) : string;
    }

    public String getType() {
        return this.type;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getExternalName() {
        return this.getExternalName(false);
    }

    public String getExternalName(boolean bl) {
        int n;
        this.initExternalName();
        if (bl && (n = this.externalName.indexOf(91)) != -1) {
            return this.externalName.substring(0, n);
        }
        return this.externalName;
    }

    private synchronized void initExternalName() {
        if (this.externalName == null) {
            this.externalName = this.externalizeClassName();
        }
    }

    public String getPackage() {
        if (this.packageName == null) {
            this.initPackage();
        }
        return this.packageName;
    }

    private synchronized void initPackage() {
        int n = this.internalName.lastIndexOf(47);
        this.packageName = n != -1 ? this.internalName.substring(0, n).replace('/', '.') : "";
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            this.initSimpleName();
        }
        return this.simpleName;
    }

    private synchronized void initSimpleName() {
        String string = this.getPackage();
        int n = string.length();
        String string2 = this.getExternalName();
        this.simpleName = n == 0 ? string2 : string2.substring(n + 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ClassName ? this.type.equals(((ClassName)object).type) : false;
    }

    public int compareTo(Object object) {
        return this.type.compareTo(((ClassName)object).type);
    }

    public int compare(Object object, Object object2) {
        return ((ClassName)object).compareTo(object2);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.getExternalName();
    }

    private String externalizeClassName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.type);
        int n2 = 0;
        boolean bl = true;
        int n3 = stringBuffer.length();
        block4: for (n = 0; n < n3; ++n) {
            char c = stringBuffer.charAt(n);
            switch (c) {
                case '[': {
                    if (!bl) continue block4;
                    ++n2;
                    continue block4;
                }
                case '$': 
                case '/': {
                    stringBuffer.setCharAt(n, '.');
                    bl = false;
                    continue block4;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (n2 > 0) {
            stringBuffer.delete(0, n2);
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("[]");
            }
        }
        return stringBuffer.toString();
    }

    static void clearCache() {
        cache.clear();
    }

    private Object readResolve() throws ObjectStreamException {
        return ClassName.getClassName(this.internalName);
    }
}

