/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.CloseAllButThisAction;
import org.netbeans.core.windows.actions.CloseAllDocumentsAction;
import org.netbeans.core.windows.actions.CloseWindowAction;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.netbeans.core.windows.actions.UndockWindowAction;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.openide.actions.SaveAction;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

public abstract class ActionUtils {
    private static HashMap<Object, Object> sharedAccelerators = new HashMap();
    private static Container slidingContext;

    private ActionUtils() {
    }

    public static Action[] createDefaultPopupActions(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        int n = modeImpl != null ? modeImpl.getKind() : 1;
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        if (n == 1) {
            arrayList.add(new CloseAllDocumentsAction(false));
            CloseAllButThisAction closeAllButThisAction = new CloseAllButThisAction(topComponent);
            if (modeImpl != null && modeImpl.getOpenedTopComponents().size() == 1) {
                closeAllButThisAction.setEnabled(false);
            }
            arrayList.add(closeAllButThisAction);
            arrayList.add(null);
            arrayList.add(new SaveDocumentAction(topComponent));
            arrayList.add(new CloneDocumentAction(topComponent));
            arrayList.add(null);
            arrayList.add(new CloseWindowAction(topComponent));
            arrayList.add(new MaximizeWindowAction(topComponent));
            arrayList.add(new UndockWindowAction(topComponent));
        } else if (n == 0) {
            arrayList.add(new CloseWindowAction(topComponent));
            if (modeImpl.getState() == 0) {
                arrayList.add(new MaximizeWindowAction(topComponent));
            }
            arrayList.add(new UndockWindowAction(topComponent));
        } else if (n == 2) {
            arrayList.add(new CloseWindowAction(topComponent));
            if (modeImpl.getState() == 0) {
                arrayList.add(new MaximizeWindowAction(topComponent));
            }
            arrayList.add(new UndockWindowAction(topComponent));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public static void setSlidingContext(Container container) {
        slidingContext = container;
    }

    public static void closeAllDocuments() {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>();
        for (Mode mode : windowManagerImpl.getModes()) {
            ModeImpl modeImpl = (ModeImpl)mode;
            if (modeImpl.getKind() != 1) continue;
            hashSet.addAll(modeImpl.getOpenedTopComponents());
        }
        for (TopComponent topComponent : hashSet) {
            topComponent.close();
        }
    }

    public static void closeAllExcept(TopComponent topComponent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>();
        for (Mode mode : windowManagerImpl.getModes()) {
            ModeImpl modeImpl = (ModeImpl)mode;
            if (modeImpl.getKind() != 1) continue;
            hashSet.addAll(modeImpl.getOpenedTopComponents());
        }
        for (TopComponent topComponent2 : hashSet) {
            if (topComponent2 == topComponent) continue;
            topComponent2.close();
        }
    }

    static void closeWindow(TopComponent topComponent) {
        topComponent.close();
    }

    private static void saveDocument(TopComponent topComponent) {
        SaveCookie saveCookie = ActionUtils.getSaveCookie(topComponent);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static SaveCookie getSaveCookie(TopComponent topComponent) {
        Lookup lookup = topComponent.getLookup();
        Object object = lookup.lookup(SaveCookie.class);
        if (object instanceof SaveCookie) {
            return (SaveCookie)object;
        }
        return null;
    }

    static void cloneWindow(TopComponent topComponent) {
        if (topComponent instanceof TopComponent.Cloneable) {
            TopComponent topComponent2 = ((TopComponent.Cloneable)topComponent).cloneComponent();
            topComponent2.open();
            topComponent2.requestActive();
        }
    }

    static void putSharedAccelerator(Object object, Object object2) {
        sharedAccelerators.put(object, object2);
    }

    static Object getSharedAccelerator(Object object) {
        return sharedAccelerators.get(object);
    }

    public static final class AutoHideWindowAction
    extends AbstractAction
    implements Presenter.Popup {
        private final SlideController slideController;
        private final int tabIndex;
        private boolean state;
        private JCheckBoxMenuItem menuItem;

        public AutoHideWindowAction(SlideController slideController, int n, boolean bl) {
            this.slideController = slideController;
            this.tabIndex = n;
            this.state = bl;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_AutoHideWindowAction"));
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.state = !this.state;
            this.getMenuItem().setSelected(this.state);
            this.slideController.userToggledAutoHide(this.tabIndex, this.state);
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuItem();
        }

        private JCheckBoxMenuItem getMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"), this.state);
                this.menuItem.setAccelerator(KeyStroke.getKeyStroke(8, 128));
                this.menuItem.addActionListener(this);
            }
            return this.menuItem;
        }
    }

    private static class CloneDocumentAction
    extends AbstractAction {
        private final TopComponent tc;

        public CloneDocumentAction(TopComponent topComponent) {
            this.tc = topComponent;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloneDocumentAction"));
            this.setEnabled(topComponent instanceof TopComponent.Cloneable);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionUtils.cloneWindow(this.tc);
        }
    }

    private static class SaveDocumentAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final TopComponent tc;
        private Action saveAction;

        public SaveDocumentAction(TopComponent topComponent) {
            this.tc = topComponent;
            this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_SaveDocumentAction"));
            this.saveAction = SaveAction.get(SaveAction.class);
            this.putValue("AcceleratorKey", this.saveAction.getValue("AcceleratorKey"));
            PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.saveAction);
            this.saveAction.addPropertyChangeListener(propertyChangeListener);
            this.setEnabled(ActionUtils.getSaveCookie(topComponent) != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionUtils.saveDocument(this.tc);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("AcceleratorKey".equals(propertyChangeEvent.getPropertyName())) {
                this.putValue("AcceleratorKey", this.saveAction.getValue("AcceleratorKey"));
            }
        }
    }
}

