/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.AWTKeyStroke;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.KeyboardPopupSwitcher;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RecentViewListAction
extends AbstractAction
implements PropertyChangeListener {
    public RecentViewListAction() {
        this.putValue("Name", NbBundle.getMessage(RecentViewListAction.class, (String)"CTL_RecentViewListAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        TopComponent[] topComponentArray = this.getRecentDocuments();
        if (topComponentArray.length < 2) {
            return;
        }
        if (!"immediately".equals(actionEvent.getActionCommand()) && !(actionEvent.getSource() instanceof JMenuItem) && (object = Utilities.stringToKey((String)actionEvent.getActionCommand())) != null) {
            int n = ((AWTKeyStroke)object).getKeyCode();
            int n2 = 16;
            int n3 = 0;
            int n4 = ((AWTKeyStroke)object).getModifiers();
            if ((2 & n4) != 0) {
                n3 = 17;
            } else if ((8 & n4) != 0) {
                n3 = 18;
            } else if ((4 & n4) != 0) {
                n3 = 4;
            }
            if (n3 != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    Frame frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() instanceof Frame ? (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : WindowManager.getDefault().getMainWindow();
                    KeyboardPopupSwitcher.selectItem(this.createSwitcherItems(topComponentArray), n3, n);
                }
                return;
            }
        }
        object = topComponentArray[1];
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode((TopComponent)object);
        if (modeImpl != null && modeImpl != windowManagerImpl.getCurrentMaximizedMode()) {
            windowManagerImpl.switchMaximizedMode(null);
        }
        object.requestActive();
    }

    private SwitcherTableItem[] createSwitcherItems(TopComponent[] topComponentArray) {
        SwitcherTableItem[] switcherTableItemArray = new SwitcherTableItem[topComponentArray.length];
        for (int i = 0; i < topComponentArray.length; ++i) {
            String string;
            TopComponent topComponent = topComponentArray[i];
            String string2 = topComponent.getDisplayName();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = topComponent.getName();
            }
            if ((string = topComponent.getHtmlDisplayName()) == null) {
                string = string2;
            }
            Image image = topComponent.getIcon();
            String string3 = topComponent.getToolTipText();
            ImageIcon imageIcon = image != null ? new ImageIcon(image) : null;
            switcherTableItemArray[i] = new SwitcherTableItem((SwitcherTableItem.Activatable)new ActivatableTC(topComponent), string2, string, (Icon)imageIcon, false, string3 != null ? string3 : string2);
        }
        return switcherTableItemArray;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("opened".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    public static String getStringRep4Unixes() {
        if (Utilities.isUnix()) {
            return "Actions/Window/org-netbeans-core-windows-actions-RecentViewListAction.instance";
        }
        return null;
    }

    private void updateEnabled() {
        this.setEnabled(this.isMoreThanOneDocOpened());
    }

    private boolean isMoreThanOneDocOpened() {
        for (ModeImpl modeImpl : WindowManagerImpl.getInstance().getModes()) {
            if (modeImpl.getKind() != 1) continue;
            return modeImpl.getOpenedTopComponents().size() > 1;
        }
        return false;
    }

    private TopComponent[] getRecentDocuments() {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent[] topComponentArray = windowManagerImpl.getRecentViewList();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (int i = 0; i < topComponentArray.length; ++i) {
            ModeImpl modeImpl;
            TopComponent topComponent = topComponentArray[i];
            if (topComponent == null || (modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent)) == null || modeImpl.getKind() != 1) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[0]);
    }

    private class ActivatableTC
    implements SwitcherTableItem.Activatable {
        private TopComponent tc;

        private ActivatableTC(TopComponent topComponent) {
            this.tc = topComponent;
        }

        public void activate() {
            if (this.tc != null) {
                this.tc.requestActive();
            }
        }
    }
}

