/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class PropertiesOpen
extends CloneableOpenSupport
implements OpenCookie,
CloseCookie {
    PropertiesDataObject propDataObject;
    PropertyChangeListener modifL;
    protected transient UndoRedo.Manager undoRedoManager;
    transient Object atomicUndoRedoFlag;

    public PropertiesOpen(PropertiesDataObject propertiesDataObject) {
        super((CloneableOpenSupport.Env)new Environment(propertiesDataObject));
        this.propDataObject = propertiesDataObject;
        this.modifL = new ModifiedListener();
        this.propDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.modifL, (Object)((Object)this.propDataObject)));
    }

    protected boolean canClose() {
        SaveCookie saveCookie = (SaveCookie)this.propDataObject.getCookie(SaveCookie.class);
        if (saveCookie == null) {
            return true;
        }
        this.stopEditing();
        if (!this.shouldAskSave()) {
            return true;
        }
        String string = NbBundle.getMessage(PropertiesOpen.class, (String)"CTL_Question");
        String string2 = NbBundle.getMessage(PropertiesOpen.class, (String)"MSG_SaveFile", (Object)this.propDataObject.getName());
        String string3 = NbBundle.getMessage(PropertiesOpen.class, (String)"CTL_Save");
        String string4 = NbBundle.getMessage(PropertiesOpen.class, (String)"CTL_Discard");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string2, string, true, new Object[]{string3, string4, NotifyDescriptor.CANCEL_OPTION}, (Object)string3, 0, null, (ActionListener)null);
        dialogDescriptor.setMessageType(3);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == string3) {
            try {
                saveCookie.save();
                this.propDataObject.updateModificationStatus();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return false;
            }
        }
        this.propDataObject.updateModificationStatus();
        return object == string3 || object == string4;
    }

    private void stopEditing() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof PropertiesCloneableTopComponent)) continue;
            BundleEditPanel bundleEditPanel = (BundleEditPanel)((PropertiesCloneableTopComponent)((Object)e)).getComponent(0);
            bundleEditPanel.stopEditing();
        }
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        return new PropertiesCloneableTopComponent(this.propDataObject);
    }

    protected String messageOpening() {
        return NbBundle.getMessage(PropertiesOpen.class, (String)"LBL_ObjectOpen", (Object)this.propDataObject.getName(), (Object)this.propDataObject.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(PropertiesOpen.class, (String)"LBL_ObjectOpened");
    }

    public synchronized boolean hasOpenedTableComponent() {
        return !this.allEditors.isEmpty();
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedoManager != null) {
            return this.undoRedoManager;
        }
        return new CompoundUndoRedoManager(this.propDataObject);
    }

    private synchronized void closeDocuments() {
        this.closeEntry((PropertiesFileEntry)this.propDataObject.getPrimaryEntry());
        Iterator iterator = this.propDataObject.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            this.closeEntry((PropertiesFileEntry)((Object)iterator.next()));
        }
    }

    private void closeEntry(PropertiesFileEntry propertiesFileEntry) {
        PropertiesEditorSupport propertiesEditorSupport = propertiesFileEntry.getPropertiesEditor();
        if (propertiesEditorSupport.hasOpenedEditorComponent()) {
            return;
        }
        propertiesEditorSupport.forceNotifyClosed();
        if (propertiesFileEntry.getFile().isValid() && !propertiesFileEntry.getFile().isVirtual()) {
            propertiesFileEntry.getHandler().autoParse();
        }
    }

    private boolean shouldAskSave() {
        PropertiesFileEntry propertiesFileEntry2 = (PropertiesFileEntry)this.propDataObject.getPrimaryEntry();
        SaveCookie saveCookie = propertiesFileEntry2.getCookie(SaveCookie.class);
        if (saveCookie != null && !propertiesFileEntry2.getPropertiesEditor().hasOpenedEditorComponent()) {
            return true;
        }
        for (PropertiesFileEntry propertiesFileEntry2 : this.propDataObject.secondaryEntries()) {
            saveCookie = propertiesFileEntry2.getCookie(SaveCookie.class);
            if (saveCookie == null || propertiesFileEntry2.getPropertiesEditor().hasOpenedEditorComponent()) continue;
            return true;
        }
        return false;
    }

    private static class CompoundUndoRedoManager
    implements UndoRedo {
        private WeakSet<UndoRedo.Manager> managers = new WeakSet(5);

        public CompoundUndoRedoManager(PropertiesDataObject propertiesDataObject) {
            this.init(propertiesDataObject);
        }

        private void init(PropertiesDataObject propertiesDataObject) {
            this.managers.add((Object)((PropertiesFileEntry)propertiesDataObject.getPrimaryEntry()).getPropertiesEditor().getUndoRedoManager());
            Iterator iterator = propertiesDataObject.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                this.managers.add((Object)((PropertiesFileEntry)((Object)iterator.next())).getPropertiesEditor().getUndoRedoManager());
            }
        }

        public synchronized void reset(PropertiesDataObject propertiesDataObject) {
            this.managers.clear();
            this.init(propertiesDataObject);
        }

        private UndoRedo getNextUndo() {
            PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager = null;
            long l = 0L;
            for (PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager2 : this.managers) {
                long l2 = undoRedoStampFlagManager2.getTimeStampOfEditToBeUndone();
                if (l2 <= l) continue;
                l = l2;
                undoRedoStampFlagManager = undoRedoStampFlagManager2;
            }
            return undoRedoStampFlagManager;
        }

        private UndoRedo getNextRedo() {
            PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager = null;
            long l = 0L;
            for (PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager2 : this.managers) {
                long l2 = undoRedoStampFlagManager2.getTimeStampOfEditToBeRedone();
                if (l2 <= l) continue;
                l = l2;
                undoRedoStampFlagManager = undoRedoStampFlagManager2;
            }
            return undoRedoStampFlagManager;
        }

        public synchronized boolean canUndo() {
            for (UndoRedo.Manager manager : this.managers) {
                if (!manager.canUndo()) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean canRedo() {
            for (UndoRedo.Manager manager : this.managers) {
                if (!manager.canRedo()) continue;
                return true;
            }
            return false;
        }

        public synchronized void undo() throws CannotUndoException {
            PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager = (PropertiesEditorSupport.UndoRedoStampFlagManager)this.getNextUndo();
            if (undoRedoStampFlagManager == null) {
                throw new CannotUndoException();
            }
            Object object = undoRedoStampFlagManager.getAtomicFlagOfEditToBeUndone();
            if (object == null) {
                undoRedoStampFlagManager.undo();
            } else {
                boolean bl;
                do {
                    bl = false;
                    for (PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager2 : this.managers) {
                        if (!object.equals(undoRedoStampFlagManager2.getAtomicFlagOfEditToBeUndone())) continue;
                        undoRedoStampFlagManager2.undo();
                        bl = true;
                    }
                } while (bl);
            }
        }

        public synchronized void redo() throws CannotRedoException {
            PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager = (PropertiesEditorSupport.UndoRedoStampFlagManager)this.getNextRedo();
            if (undoRedoStampFlagManager == null) {
                throw new CannotRedoException();
            }
            Object object = undoRedoStampFlagManager.getAtomicFlagOfEditToBeRedone();
            if (object == null) {
                undoRedoStampFlagManager.redo();
            } else {
                boolean bl;
                do {
                    bl = false;
                    for (PropertiesEditorSupport.UndoRedoStampFlagManager undoRedoStampFlagManager2 : this.managers) {
                        if (!object.equals(undoRedoStampFlagManager2.getAtomicFlagOfEditToBeRedone())) continue;
                        undoRedoStampFlagManager2.redo();
                        bl = true;
                    }
                } while (bl);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public synchronized String getUndoPresentationName() {
            UndoRedo undoRedo = this.getNextUndo();
            if (undoRedo == null) {
                return "Undo";
            }
            return undoRedo.getUndoPresentationName();
        }

        public synchronized String getRedoPresentationName() {
            UndoRedo undoRedo = this.getNextRedo();
            if (undoRedo == null) {
                return "Redo";
            }
            return undoRedo.getRedoPresentationName();
        }
    }

    private static class Environment
    implements CloneableOpenSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -1934890789745432531L;
        private DataObject dataObject;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;

        public Environment(PropertiesDataObject propertiesDataObject) {
            this.dataObject = propertiesDataObject;
            propertiesDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)propertiesDataObject)));
            propertiesDataObject.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this, (Object)((Object)propertiesDataObject)));
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().removeVetoableChangeListener(vetoableChangeListener);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.dataObject.getCookie(OpenCookie.class);
        }

        public boolean isValid() {
            return this.dataObject.isValid();
        }

        public boolean isModified() {
            return this.dataObject.isModified();
        }

        public void markModified() throws IOException {
            this.dataObject.setModified(true);
        }

        public void unmarkModified() {
            this.dataObject.setModified(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (this.dataObject.isModified()) {
                    this.dataObject.addVetoableChangeListener((VetoableChangeListener)this);
                } else {
                    this.dataObject.removeVetoableChangeListener((VetoableChangeListener)this);
                }
            } else if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.FALSE.equals(propertyChangeEvent.getOldValue())) {
                    return;
                }
                PropertiesOpen propertiesOpen = (PropertiesOpen)this.findCloneableOpenSupport();
                if (propertiesOpen != null) {
                    this.unmarkModified();
                    propertiesOpen.close(false);
                }
            } else {
                this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            this.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        private void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            this.veto().fireVetoableChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            if (this.vetoSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.vetoSupp == null) {
                        this.vetoSupp = new VetoableChangeSupport(this);
                    }
                }
            }
            return this.vetoSupp;
        }
    }

    private final class ModifiedListener
    implements SaveCookie,
    PropertyChangeListener {
        private ModifiedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource().equals((Object)PropertiesOpen.this.propDataObject)) {
                ((CompoundUndoRedoManager)PropertiesOpen.this.getUndoRedo()).reset(PropertiesOpen.this.propDataObject);
            }
            if (propertyChangeEvent.getSource() == PropertiesOpen.this.propDataObject && "modified".equals(propertyChangeEvent.getPropertyName())) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.addSaveCookie();
                } else {
                    this.removeSaveCookie();
                }
            }
        }

        public void save() throws IOException {
            PropertiesOpen.this.stopEditing();
            this.saveDocument();
        }

        public void saveDocument() throws IOException {
            PropertiesFileEntry propertiesFileEntry = (PropertiesFileEntry)PropertiesOpen.this.propDataObject.getPrimaryEntry();
            SaveCookie saveCookie = propertiesFileEntry.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            Iterator iterator = PropertiesOpen.this.propDataObject.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                saveCookie = ((PropertiesFileEntry)((Object)iterator.next())).getCookie(SaveCookie.class);
                if (saveCookie == null) continue;
                saveCookie.save();
            }
        }

        private void addSaveCookie() {
            if (PropertiesOpen.this.propDataObject.getCookie(SaveCookie.class) == null) {
                PropertiesOpen.this.propDataObject.getCookieSet0().add((Node.Cookie)this);
            }
        }

        private void removeSaveCookie() {
            if (PropertiesOpen.this.propDataObject.getCookie(SaveCookie.class) == this) {
                PropertiesOpen.this.propDataObject.getCookieSet0().remove((Node.Cookie)this);
            }
        }
    }

    public static class PropertiesCloneableTopComponent
    extends CloneableTopComponent {
        private PropertiesDataObject propDataObject;
        private transient PropertyChangeListener dataObjectListener;
        static final long serialVersionUID = 2836248291419024296L;

        public PropertiesCloneableTopComponent() {
        }

        public PropertiesCloneableTopComponent(PropertiesDataObject propertiesDataObject) {
            this.propDataObject = propertiesDataObject;
            this.initialize();
        }

        public void open() {
            if (this.discard()) {
                return;
            }
            super.open();
        }

        public void requestActive() {
            super.requestActive();
            this.getComponent(0).requestFocusInWindow();
        }

        public boolean canClose() {
            ((BundleEditPanel)this.getComponent(0)).stopEditing();
            return super.canClose();
        }

        private void initialize() {
            this.initComponents();
            this.setupActions();
            this.setActivatedNodes(new Node[]{this.propDataObject.getNodeDelegate()});
            this.dataObjectListener = new NameUpdater();
            this.propDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dataObjectListener, (Object)((Object)this.propDataObject)));
            this.updateName();
        }

        private void setupActions() {
            JTable jTable = ((BundleEditPanel)this.getComponent(0)).getTable();
            FindAction findAction = (FindAction)SystemAction.get(FindAction.class);
            FindPerformer findPerformer = FindPerformer.getFindPerformer(jTable);
            this.getActionMap().put(findAction.getActionMapKey(), findPerformer);
        }

        private void updateName() {
            assert (EventQueue.isDispatchThread());
            String string = this.propDataObject.getName();
            String string2 = this.displayName();
            String string3 = this.htmlDisplayName();
            String string4 = this.messageToolTip();
            Enumeration enumeration = this.getReference().getComponents();
            while (enumeration.hasMoreElements()) {
                CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
                cloneableTopComponent.setName(string);
                cloneableTopComponent.setDisplayName(string2);
                cloneableTopComponent.setHtmlDisplayName(string3);
                cloneableTopComponent.setToolTipText(string4);
            }
        }

        private void updateDisplayName() {
            assert (EventQueue.isDispatchThread());
            String string = this.displayName();
            String string2 = this.htmlDisplayName();
            Enumeration enumeration = this.getReference().getComponents();
            while (enumeration.hasMoreElements()) {
                CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
                cloneableTopComponent.setDisplayName(string);
                cloneableTopComponent.setHtmlDisplayName(string2);
            }
        }

        private String addModifiedInfo(String string) {
            boolean bl = this.propDataObject.getCookie(SaveCookie.class) != null;
            int n = bl ? 1 : 3;
            return NbBundle.getMessage(PropertiesCloneableTopComponent.class, (String)"LBL_EditorName", (Object)new Integer(n), (Object)string);
        }

        private String displayName() {
            String string = this.propDataObject.getNodeDelegate().getDisplayName();
            return this.addModifiedInfo(string);
        }

        private String htmlDisplayName() {
            Node node = this.propDataObject.getNodeDelegate();
            String string = node.getHtmlDisplayName();
            if (string != null) {
                if (!string.startsWith("<html>")) {
                    string = "<html>" + string;
                }
            } else {
                string = node.getDisplayName();
            }
            return this.addModifiedInfo(string);
        }

        private String messageToolTip() {
            FileObject fileObject = this.propDataObject.getPrimaryFile();
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }

        protected boolean closeLast() {
            if (!this.propDataObject.getOpenSupport().canClose()) {
                return false;
            }
            this.propDataObject.getOpenSupport().closeDocuments();
            return true;
        }

        protected CloneableTopComponent createClonedObject() {
            return new PropertiesCloneableTopComponent(this.propDataObject);
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/properties/propertiesEditorMode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.modifying");
        }

        protected String preferredID() {
            return this.getName();
        }

        public int getPersistenceType() {
            return 1;
        }

        public UndoRedo getUndoRedo() {
            return this.propDataObject.getOpenSupport().getUndoRedo();
        }

        private void initComponents() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            BundleEditPanel bundleEditPanel = new BundleEditPanel(this.propDataObject, new PropertiesTableModel(this.propDataObject.getBundleStructure()));
            gridBagLayout.setConstraints(bundleEditPanel, gridBagConstraints);
            this.add(bundleEditPanel);
        }

        private boolean discard() {
            return this.propDataObject == null;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeObject((Object)this.propDataObject);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.propDataObject = (PropertiesDataObject)((Object)objectInput.readObject());
            this.initialize();
        }

        final class NameUpdater
        implements PropertyChangeListener,
        FileStatusListener,
        Runnable {
            private static final int NO_ACTION = 0;
            private static final int ACTION_UPDATE_NAME = 1;
            private static final int ACTION_UPDATE_DISPLAY_NAME = 2;
            private FileStatusListener weakL;
            private FileSystem previous;
            private final int action;

            NameUpdater() {
                this(0);
                this.updateStatusListener();
            }

            NameUpdater(int n) {
                this.action = n;
            }

            private void updateStatusListener() {
                if (this.previous != null) {
                    this.previous.removeFileStatusListener(this.weakL);
                }
                try {
                    this.previous = PropertiesCloneableTopComponent.this.propDataObject.getPrimaryFile().getFileSystem();
                    if (this.weakL == null) {
                        this.weakL = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)this.previous);
                    }
                    this.previous.addFileStatusListener(this.weakL);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    this.previous = null;
                }
            }

            public void annotationChanged(FileStatusEvent fileStatusEvent) {
                if (!fileStatusEvent.isNameChange()) {
                    return;
                }
                boolean bl = false;
                for (FileObject fileObject : PropertiesCloneableTopComponent.this.propDataObject.files()) {
                    if (!fileStatusEvent.hasChanged(fileObject)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(2));
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!PropertiesCloneableTopComponent.this.propDataObject.isValid()) {
                    return;
                }
                String string = propertyChangeEvent.getPropertyName();
                if (string == null) {
                    return;
                }
                if (string.equals("name")) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(1));
                } else if (string.equals("primaryFile")) {
                    this.updateStatusListener();
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(1));
                } else if (string.equals("cookie") || string.equals("files")) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(2));
                }
            }

            public void run() {
                assert (EventQueue.isDispatchThread());
                if (this.action == 1) {
                    PropertiesCloneableTopComponent.this.updateName();
                } else if (this.action == 2) {
                    PropertiesCloneableTopComponent.this.updateDisplayName();
                } else assert (false);
            }
        }
    }

    public class PropertiesOpenAt
    implements OpenCookie {
        private PropertiesFileEntry entry;
        private String key;

        PropertiesOpenAt(PropertiesFileEntry propertiesFileEntry, String string) {
            this.entry = propertiesFileEntry;
            this.key = string;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void open() {
            final PropertiesCloneableTopComponent propertiesCloneableTopComponent = (PropertiesCloneableTopComponent)PropertiesOpen.super.openCloneableTopComponent();
            propertiesCloneableTopComponent.requestActive();
            BundleStructure bundleStructure = PropertiesOpen.this.propDataObject.getBundleStructure();
            int n = bundleStructure.getEntryIndexByFileName(this.entry.getFile().getName());
            int n2 = bundleStructure.getKeyIndexByName(this.key);
            if (n != -1 && n2 != -1) {
                final int n3 = n2;
                final int n4 = n + 1;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Rectangle rectangle;
                        JTable jTable = ((BundleEditPanel)propertiesCloneableTopComponent.getComponent(0)).getTable();
                        if (jTable.getAutoscrolls() && (rectangle = jTable.getCellRect(n3, n4, false)) != null) {
                            jTable.scrollRectToVisible(rectangle);
                        }
                        jTable.getColumnModel().getSelectionModel().setSelectionInterval(n3, n4);
                        jTable.getSelectionModel().setSelectionInterval(n3, n4);
                        jTable.editCellAt(n3, n4);
                    }
                });
            }
        }
    }
}

