/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.Util;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PropertiesTableModel
extends AbstractTableModel {
    static final long serialVersionUID = -7882925922830244768L;
    private BundleStructure structure;
    private PropertyBundleListener bundleListener;

    public PropertiesTableModel(BundleStructure bundleStructure) {
        this.structure = bundleStructure;
        this.bundleListener = new TablePropertyBundleListener();
        bundleStructure.addPropertyBundleListener((PropertyBundleListener)WeakListeners.create(PropertyBundleListener.class, (EventListener)this.bundleListener, (Object)bundleStructure));
    }

    public Class getColumnClass(int n) {
        return StringPair.class;
    }

    public int getRowCount() {
        return this.structure.getKeyCount();
    }

    public int getColumnCount() {
        return this.structure.getEntryCount() + 1;
    }

    public Object getValueAt(int n, int n2) {
        Element.ItemElem itemElem;
        BundleStructure bundleStructure = this.structure;
        if (n2 == 0) {
            return this.stringPairForKey(n);
        }
        try {
            itemElem = bundleStructure.getItem(n2 - 1, bundleStructure.keyAt(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            itemElem = null;
        }
        return this.stringPairForValue(itemElem);
    }

    private StringPair stringPairForKey(int n) {
        BundleStructure bundleStructure = this.structure;
        Element.ItemElem itemElem = bundleStructure.getItem(0, bundleStructure.keyAt(n));
        StringPair stringPair = itemElem == null ? new StringPair("", bundleStructure.keyAt(n), true) : new StringPair(itemElem.getComment(), bundleStructure.keyAt(n), true);
        if (this.structure.getEntryCount() > 1) {
            stringPair.setCommentEditable(false);
        }
        return stringPair;
    }

    private StringPair stringPairForValue(Element.ItemElem itemElem) {
        if (itemElem == null) {
            return new StringPair(null, null);
        }
        return new StringPair(itemElem.getComment(), itemElem.getValue());
    }

    public String getColumnName(int n) {
        String string = n == this.structure.getSortIndex() ? "     " : " ";
        if (n == 0) {
            return string + NbBundle.getBundle(PropertiesTableModel.class).getString("LAB_KeyColumnLabel");
        }
        if (this.structure.getEntryCount() == 1) {
            return string + NbBundle.getBundle(PropertiesTableModel.class).getString("LBL_ColumnValue");
        }
        PropertiesFileEntry propertiesFileEntry = this.structure.getNthEntry(n - 1);
        return propertiesFileEntry == null ? "" : string + Util.getLocaleLabel((MultiDataObject.Entry)propertiesFileEntry);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.equals(this.getValueAt(n, n2))) {
            return;
        }
        if (n2 == 0) {
            BundleStructure bundleStructure = this.structure;
            String string = bundleStructure.keyAt(n);
            if (string == null) {
                return;
            }
            String string2 = ((StringPair)object).getValue();
            if (string2 == null) {
                return;
            }
            for (int i = 0; i < this.structure.getEntryCount(); ++i) {
                Element.ItemElem itemElem;
                PropertiesStructure propertiesStructure;
                PropertiesFileEntry propertiesFileEntry = this.structure.getNthEntry(i);
                if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null) continue;
                if (!string.equals(string2)) {
                    propertiesStructure.renameItem(string, string2);
                    this.structure.sort(-1);
                }
                if (i != 0 || (itemElem = propertiesStructure.getItem(string2)) == null || !((StringPair)object).isCommentEditable() || itemElem.getComment().equals(((StringPair)object).getComment())) continue;
                itemElem.setComment(((StringPair)object).getComment());
            }
        } else {
            PropertiesStructure propertiesStructure;
            PropertiesFileEntry propertiesFileEntry = this.structure.getNthEntry(n2 - 1);
            String string = this.structure.keyAt(n);
            if (propertiesFileEntry != null && string != null && (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) != null) {
                Element.ItemElem itemElem = propertiesStructure.getItem(string);
                if (itemElem != null) {
                    itemElem.setValue(((StringPair)object).getValue());
                    itemElem.setComment(((StringPair)object).getComment());
                    this.structure.sort(-1);
                } else if (((StringPair)object).getValue().length() > 0 || ((StringPair)object).getComment().length() > 0) {
                    propertiesStructure.addItem(string, ((StringPair)object).getValue(), ((StringPair)object).getComment());
                    this.structure.sort(-1);
                }
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return !this.structure.isReadOnly();
        }
        PropertiesFileEntry propertiesFileEntry = this.structure.getNthEntry(n2 - 1);
        return propertiesFileEntry.getFile().canWrite();
    }

    public void fireTableColumnChanged(int n) {
        int n2 = n;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof JTable)) continue;
            JTable jTable = (JTable)objectArray[i];
            try {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
                n2 = tableColumn.getModelIndex();
                tableColumn.setHeaderValue(jTable.getModel().getColumnName(n2));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            jTable.getTableHeader().repaint();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, n2));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("------------------------------ TABLE MODEL DUMP -----------------------\n");
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                StringPair stringPair = (StringPair)this.getValueAt(i, j);
                stringBuffer.append("[" + stringPair.getValue() + "]");
                if (j == 0) {
                    stringBuffer.append(" : ");
                    continue;
                }
                if (j == this.getColumnCount() - 1) {
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(",");
            }
        }
        stringBuffer.append("---------------------------- END TABLE MODEL DUMP ---------------------\n");
        return stringBuffer.toString();
    }

    private void cancelEditingInTables(CancelSelector cancelSelector) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            BundleEditPanel.BundleTable bundleTable;
            if (!(objectArray[i] instanceof BundleEditPanel.BundleTable) || !cancelSelector.doCancelEditing((bundleTable = (BundleEditPanel.BundleTable)objectArray[i]).getEditingRow(), bundleTable.getEditingColumn())) continue;
            bundleTable.removeEditorSilent();
        }
    }

    private CancelSelector getDefaultCancelSelector() {
        return new CancelSelector(){

            public boolean doCancelEditing(int n, int n2) {
                return n >= 0 && n < PropertiesTableModel.this.getRowCount() && n2 >= 0 && n2 < PropertiesTableModel.this.getColumnCount();
            }
        };
    }

    private static interface CancelSelector {
        public boolean doCancelEditing(int var1, int var2);
    }

    static class StringPair
    implements Serializable {
        private String comment;
        private String value;
        private boolean keyType;
        private boolean commentEditable;
        static final long serialVersionUID = -463968846283787181L;

        public StringPair() {
            this(null, "", false);
        }

        public StringPair(String string) {
            this(null, string, true);
        }

        public StringPair(String string, String string2) {
            this(string, string2, false);
        }

        public StringPair(String string, String string2, boolean bl) {
            this.comment = string;
            this.value = string2;
            this.keyType = bl;
            this.commentEditable = true;
        }

        public String getComment() {
            return this.comment;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof StringPair)) {
                return false;
            }
            StringPair stringPair = (StringPair)object;
            if (this.comment == null && stringPair.getComment() != null) {
                return false;
            }
            String string = this.comment;
            String string2 = stringPair.getComment();
            if (!string.equals(string2)) {
                return false;
            }
            if (this.value == null && stringPair.getValue() != null) {
                return false;
            }
            string = this.value;
            string2 = stringPair.getValue();
            return string.equals(string2);
        }

        public String toString() {
            return this.value;
        }

        public boolean isKeyType() {
            return this.keyType;
        }

        public boolean isCommentEditable() {
            return this.commentEditable;
        }

        public void setCommentEditable(boolean bl) {
            this.commentEditable = bl;
        }
    }

    private class TablePropertyBundleListener
    implements PropertyBundleListener {
        private TablePropertyBundleListener() {
        }

        public void bundleChanged(final PropertyBundleEvent propertyBundleEvent) {
            if (EventQueue.isDispatchThread()) {
                this.doBundleChanged(propertyBundleEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TablePropertyBundleListener.this.doBundleChanged(propertyBundleEvent);
                    }
                });
            }
        }

        private void doBundleChanged(PropertyBundleEvent propertyBundleEvent) {
            int n = propertyBundleEvent.getChangeType();
            if (n == 1) {
                Object[] objectArray = PropertiesTableModel.this.listenerList.getListenerList();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof JTable)) continue;
                    ((JTable)objectArray[i]).setModel(new PropertiesTableModel(PropertiesTableModel.this.structure));
                }
            } else if (n == 2) {
                PropertiesTableModel.this.cancelEditingInTables(PropertiesTableModel.this.getDefaultCancelSelector());
                Object[] objectArray = PropertiesTableModel.this.listenerList.getListenerList();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof JTable)) continue;
                    JTable jTable = (JTable)objectArray[i];
                    for (int j = 0; j < jTable.getColumnModel().getColumnCount(); ++j) {
                        TableColumn tableColumn = jTable.getColumnModel().getColumn(j);
                        tableColumn.setHeaderValue(jTable.getModel().getColumnName(tableColumn.getModelIndex()));
                    }
                }
                PropertiesTableModel.this.fireTableDataChanged();
            } else if (n == 3) {
                final int n2 = PropertiesTableModel.this.structure.getEntryIndexByFileName(propertyBundleEvent.getEntryName());
                if (n2 == -1) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        new Exception("Changed file not found").printStackTrace();
                    }
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(){

                    public boolean doCancelEditing(int n, int n22) {
                        if (n < 0 || n >= PropertiesTableModel.this.getRowCount() || n22 < 0 || n22 >= PropertiesTableModel.this.getColumnCount()) {
                            return false;
                        }
                        return n22 == n2 + 1;
                    }
                });
                PropertiesTableModel.this.fireTableColumnChanged(n2 + 1);
            } else if (n == 4) {
                final int n3 = PropertiesTableModel.this.structure.getEntryIndexByFileName(propertyBundleEvent.getEntryName());
                final int n4 = PropertiesTableModel.this.structure.getKeyIndexByName(propertyBundleEvent.getItemName());
                if (n3 == -1 || n4 == -1) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        new Exception("Changed file not found").printStackTrace();
                    }
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(){

                    public boolean doCancelEditing(int n, int n2) {
                        if (n < 0 || n >= PropertiesTableModel.this.getRowCount() || n2 < 0 || n2 >= PropertiesTableModel.this.getColumnCount()) {
                            return false;
                        }
                        return n2 == n3 + 1 && n == n4;
                    }
                });
                PropertiesTableModel.this.fireTableCellUpdated(n4, n3 + 1);
            }
        }
    }
}

