/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.netbeans.Util;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClassLoader
extends ClassLoader
implements Util.PackageAccessibleClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private final Map<String, ClassLoader> domainsByPackage = new HashMap<String, ClassLoader>();
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private ClassLoader[] parents;
    private boolean dead = false;
    private final boolean transitive;

    public ProxyClassLoader(ClassLoader[] classLoaderArray) {
        this(classLoaderArray, true);
    }

    public ProxyClassLoader(ClassLoader[] classLoaderArray, boolean bl) {
        if (classLoaderArray.length == 0) {
            throw new IllegalArgumentException("ProxyClassLoader must have a parent");
        }
        this.transitive = bl;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(Arrays.asList(classLoaderArray));
        if (hashSet.size() < classLoaderArray.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (hashSet.contains(null)) {
            throw new IllegalArgumentException("null parent in " + hashSet);
        }
        this.parents = this.coalesceParents(classLoaderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (int i = 0; i < classLoaderArray.length; ++i) {
            if (classLoaderArray[i] != null) continue;
            throw new IllegalArgumentException("null parent");
        }
        ClassLoader[] classLoaderArray2 = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        classLoaderArray2 = moduleFactory != null && moduleFactory.removeBaseClassLoader() ? this.coalesceAppend(new ClassLoader[0], classLoaderArray) : this.coalesceAppend(this.parents, classLoaderArray);
        ProxyClassLoader proxyClassLoader = this;
        synchronized (proxyClassLoader) {
            this.parents = classLoaderArray2;
        }
    }

    public void destroy() {
        this.dead = true;
    }

    private void zombieCheck(String string) {
        if (this.dead) {
            this.dead = false;
        }
    }

    @Override
    protected final synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.zombieCheck(string);
        String string2 = string.replace('.', '/').concat(".class");
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + string + ")");
        }
        String string3 = string2.substring(0, n + 1);
        Class clazz = this.smartLoadClass(string, string2, string3);
        if (clazz == null) {
            throw new ClassNotFoundException(string + " from " + this);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class simpleFindClass(String string, String string2, String string3) {
        return null;
    }

    private String stripInitialSlash(String string) {
        if (string.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", string);
            return string.substring(1);
        }
        return string;
    }

    @Override
    public final URL getResource(String string) {
        String string2;
        this.zombieCheck(string);
        string = this.stripInitialSlash(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            ProxyClassLoader.printDefaultPackageWarning(string);
        }
        if (this.isSpecialResource(string2 = string.substring(0, n + 1))) {
            for (int i = 0; i < this.parents.length; ++i) {
                URL uRL;
                if (!this.shouldDelegateResource(string2, this.parents[i]) || (uRL = this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).findResource(string) : this.parents[i].getResource(string)) == null) continue;
                return uRL;
            }
            return this.findResource(string);
        }
        ClassLoader classLoader = this.domainsByPackage.get(string2);
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).findResource(string);
            }
            return classLoader.getResource(string);
        }
        URL uRL = null;
        for (int i = 0; i < this.parents.length; ++i) {
            classLoader = this.parents[i];
            if (!this.shouldDelegateResource(string2, classLoader) || (uRL = classLoader instanceof ProxyClassLoader ? ((ProxyClassLoader)classLoader).findResource(string) : classLoader.getResource(string)) == null) continue;
            String string3 = new String(string2).intern();
            this.domainsByPackage.put(string3, classLoader);
            if (classLoader instanceof ProxyClassLoader) {
                ((ProxyClassLoader)classLoader).domainsByPackage.put(string3, classLoader);
            }
            return uRL;
        }
        uRL = this.findResource(string);
        if (uRL != null) {
            this.domainsByPackage.put(new String(string2).intern(), this);
        }
        return uRL;
    }

    @Override
    protected URL findResource(String string) {
        return null;
    }

    @Override
    protected final synchronized Enumeration<URL> findResources(String string) throws IOException {
        this.zombieCheck(string);
        string = this.stripInitialSlash(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            ProxyClassLoader.printDefaultPackageWarning(string);
        }
        String string2 = string.substring(0, n + 1);
        ArrayList<Enumeration<URL>> arrayList = new ArrayList<Enumeration<URL>>(this.parents.length + 1);
        for (ClassLoader classLoader : this.parents) {
            if (!this.shouldDelegateResource(string2, classLoader)) continue;
            if (classLoader instanceof ProxyClassLoader) {
                arrayList.add(((ProxyClassLoader)classLoader).simpleFindResources(string));
                continue;
            }
            arrayList.add(classLoader.getResources(string));
        }
        arrayList.add(this.simpleFindResources(string));
        return Enumerations.concat(Collections.enumeration(arrayList));
    }

    protected Enumeration<URL> simpleFindResources(String string) throws IOException {
        return super.findResources(string);
    }

    @Override
    protected Package getPackage(String string) {
        this.zombieCheck(string);
        return this.getPackageFast(string, string.replace('.', '/') + '/', true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String string, String string2, boolean bl) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            ClassLoader classLoader;
            Package package_ = this.packages.get(string);
            if (package_ != null) {
                return package_;
            }
            if (!bl) {
                return null;
            }
            for (int i = 0; !(i >= this.parents.length || (classLoader = this.parents[i]) instanceof ProxyClassLoader && this.shouldDelegateResource(string2, classLoader) && (package_ = ((ProxyClassLoader)classLoader).getPackageFast(string, string2, false)) != null); ++i) {
            }
            if (package_ == null && this.shouldDelegateResource(string2, this.getParent())) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Package[] getPackages(Set<ClassLoader> set) {
        this.zombieCheck(null);
        HashMap<String, Package> hashMap = new HashMap<String, Package>();
        this.addPackages(hashMap, super.getPackages());
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader classLoader = this.parents[i];
            if (!(classLoader instanceof ProxyClassLoader) || !set.add(classLoader)) continue;
            this.addPackages(hashMap, ((ProxyClassLoader)classLoader).getPackages(set));
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            hashMap.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(hashMap);
        }
        return this.packages.values().toArray(new Package[this.packages.size()]);
    }

    @Override
    public Package getPackageAccessibly(String string) {
        return this.getPackage(string);
    }

    @Override
    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private static void printDefaultPackageWarning(String string) {
        if (!"commons-logging.properties".equals(string) && !"jndi.properties".equals(string)) {
            LOGGER.log(Level.INFO, null, new IllegalStateException("You are trying to access file: " + string + " from the default package. Please see http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#default_package"));
        }
    }

    private ClassLoader[] coalesceParents(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        int n = classLoaderArray.length * 5 + 10;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(n);
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        for (int i = 0; i < classLoaderArray.length; ++i) {
            this.addRec(hashSet, arrayList, classLoaderArray[i]);
        }
        ClassLoader[] classLoaderArray2 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray2;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] classLoaderArray, ClassLoader[] classLoaderArray2) throws IllegalArgumentException {
        int n = classLoaderArray.length + 3;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(n);
        List<ClassLoader> list = Arrays.asList(classLoaderArray);
        hashSet.addAll(list);
        if (hashSet.containsAll(Arrays.asList(classLoaderArray2))) {
            return classLoaderArray;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        arrayList.addAll(list);
        for (int i = 0; i < classLoaderArray2.length; ++i) {
            this.addRec(hashSet, arrayList, classLoaderArray2[i]);
        }
        ClassLoader[] classLoaderArray3 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray3;
    }

    private void addRec(Set<ClassLoader> set, List<ClassLoader> list, ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader).transitive) {
            ClassLoader[] classLoaderArray = ((ProxyClassLoader)classLoader).parents;
            for (int i = 0; i < classLoaderArray.length; ++i) {
                this.addRec(set, list, classLoaderArray[i]);
            }
        }
        set.add(classLoader);
        list.add(classLoader);
    }

    private final Class smartLoadClass(String string, String string2, String string3) throws ClassNotFoundException {
        ClassLoader classLoader;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = classLoader = this.isSpecialResource(string3) ? null : this.domainsByPackage.get(string3);
        if (classLoader == this) {
            return this.simpleFindClass(string, string2, string3);
        }
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).fullFindClass(string, string2, string3);
            }
            return classLoader.loadClass(string);
        }
        clazz = this.loadInOrder(string, string2, string3);
        if (clazz != null) {
            ClassLoader classLoader3 = ProxyClassLoader.getClassClassLoader(clazz);
            this.domainsByPackage.put(new String(string3).intern(), classLoader3);
        }
        return clazz;
    }

    private static ClassLoader getClassClassLoader(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    private final Class loadInOrder(String string, String string2, String string3) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader classLoader = this.parents[i];
            if (!this.shouldDelegateResource(string3, classLoader)) continue;
            if (classLoader instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader).shouldBeCheckedAsParentProxyClassLoader()) {
                ProxyClassLoader proxyClassLoader = (ProxyClassLoader)classLoader;
                Class clazz = proxyClassLoader.fullFindClass(string, string2, string3);
                if (clazz == null || !proxyClassLoader.transitive && ProxyClassLoader.getClassClassLoader(clazz) != proxyClassLoader) continue;
                return clazz;
            }
            boolean bl = false;
            if (this.optimizeNBLoading() && (string.startsWith("org.netbeans.") || string.startsWith("org.openide.") || string.endsWith(".Bundle") || string.endsWith("BeanInfo") || string.endsWith("Editor")) && classLoader.getResource(string2) == null) {
                bl = true;
            }
            if (bl) continue;
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        Class clazz = this.simpleFindClass(string, string2, string3);
        if (clazz != null) {
            return clazz;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        return null;
    }

    private synchronized Class fullFindClass(String string, String string2, String string3) {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null && (clazz = this.simpleFindClass(string, string2, string3)) != null) {
            this.domainsByPackage.put(new String(string3).intern(), this);
        }
        return clazz;
    }

    private void addPackages(Map<String, Package> map, Package[] packageArray) {
        for (int i = 0; i < packageArray.length; ++i) {
            map.put(packageArray[i].getName(), packageArray[i]);
        }
    }

    protected boolean shouldBeCheckedAsParentProxyClassLoader() {
        return true;
    }

    protected boolean optimizeNBLoading() {
        return true;
    }

    protected boolean isSpecialResource(String string) {
        if (string.startsWith("META-INF/")) {
            return true;
        }
        return string.length() == 0;
    }

    protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
        return true;
    }
}

