/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.DateComparator;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.ModifiedRequest;
import org.netbeans.lib.cvsclient.request.QuestionableRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public abstract class BasicCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected File[] files;

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setFiles(File[] fileArray) {
        if (fileArray == null) {
            this.files = fileArray;
            return;
        }
        this.files = new File[fileArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = fileArray.length;
        for (int i = 0; i < n3; ++i) {
            File file = fileArray[i];
            if (file.isDirectory()) {
                this.files[n3 - (1 + n2)] = file;
                ++n2;
                continue;
            }
            this.files[n] = file;
            ++n;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getXthFile(int n) {
        if (n < 0 || n >= this.files.length) {
            return null;
        }
        File file = this.files[n];
        if (!file.isFile()) {
            return null;
        }
        return file;
    }

    public File getFileEndingWith(String string) {
        String string2 = string.replace('\\', '/');
        String string3 = this.getLocalDirectory().replace('\\', '/');
        int n = 0;
        for (n = 0; n < this.files.length; ++n) {
            String string4 = this.files[n].getAbsolutePath();
            String string5 = this.files[n].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((!(string4 = string4.replace('\\', '/')).endsWith(string2) || string2.indexOf(47) < 0) && (!this.files[n].getName().equals(string2) || !string5.equals(string3))) continue;
            return this.files[n];
        }
        return null;
    }

    private void addRequests(File file) throws FileNotFoundException, IOException, CommandAbortedException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot add requests for a null path.");
        }
        if (!file.exists() || file.isFile()) {
            this.addRequestsForFile(file);
        } else {
            this.addRequestsForDirectory(file);
        }
    }

    protected boolean doesCheckFileTime() {
        return true;
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (entry == null) {
            return;
        }
        if (file != null && !file.exists() && entry.isNewUserFile()) {
            return;
        }
        Date date = entry.getLastModified();
        boolean bl = entry.hadConflicts();
        if (!bl) {
            entry.setConflict(null);
        } else if (this.fileRequiresConflictResolution(file, entry)) {
            Entry entry2 = new Entry(entry.toString());
            entry2.setConflict("+=");
            entry = entry2;
        }
        this.addRequest(new EntryRequest(entry));
        if (file == null || !file.exists() || entry.isUserFileToBeRemoved()) {
            return;
        }
        if (this.doesCheckFileTime() && !bl && date != null && DateComparator.getInstance().equals(file.lastModified(), date.getTime())) {
            this.addRequest(new UnchangedRequest(file.getName()));
            return;
        }
        this.addRequest(new ModifiedRequest(file, entry.isBinary()));
    }

    private final boolean fileRequiresConflictResolution(File file, Entry entry) {
        if (file == null) {
            return false;
        }
        boolean bl = false;
        if (entry.hadConflicts()) {
            long l = entry.getLastModified().getTime() / 1000L;
            long l2 = file.lastModified() / 1000L;
            bl = l2 <= l;
        }
        return bl;
    }

    protected void addRequestsForDirectory(File file) throws IOException, CommandAbortedException {
        File file2;
        ArrayList<Object> arrayList;
        if (!this.clientServices.exists(file)) {
            return;
        }
        if (this.clientServices.isAborted()) {
            throw new CommandAbortedException("Command aborted during request generation", "Command aborted during request generation");
        }
        this.addDirectoryRequest(file);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            arrayList = new ArrayList(0);
        } else {
            arrayList = new ArrayList<File>(Arrays.asList(fileArray));
            arrayList.remove(new File(file, "CVS"));
        }
        LinkedList<Object> linkedList = null;
        if (this.isRecursive()) {
            linkedList = new LinkedList<Object>();
        }
        Object object = this.clientServices.getEntries(file);
        while (object.hasNext()) {
            Entry entry = (Entry)object.next();
            file2 = new File(file, entry.getName());
            if (entry.isDirectory()) {
                if (this.isRecursive()) {
                    linkedList.add(new File(file, entry.getName()));
                }
            } else {
                this.addRequestForFile(file2, entry);
            }
            arrayList.remove(file2);
        }
        if (this.isRecursive() && !new File(file, "CVS").exists() && (object = file.listFiles()) != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!((File)object[i]).isDirectory() || !new File((File)object[i], "CVS").exists()) continue;
                linkedList.add(object[i]);
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            String string = ((File)object.next()).getName();
            if (this.clientServices.shouldBeIgnored(file, string)) continue;
            this.addRequest(new QuestionableRequest(string));
        }
        if (this.isRecursive()) {
            object = linkedList.iterator();
            while (object.hasNext()) {
                File file3 = (File)object.next();
                file2 = new File(file3, "CVS");
                if (!this.clientServices.exists(file2)) continue;
                this.addRequestsForDirectory(file3);
            }
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        this.sendEntryAndModifiedRequests(entry, file);
    }

    protected void addRequestsForFile(File file) throws IOException {
        this.addDirectoryRequest(file.getParentFile());
        try {
            Entry entry = this.clientServices.getEntry(file);
            if (entry != null) {
                this.addRequestForFile(file, entry);
            } else if (file.exists()) {
                boolean bl = false;
                this.addRequest(new ModifiedRequest(file, bl));
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred getting the Entry for file " + file + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected final void addDirectoryRequest(File file) {
        String string = this.getRelativeToLocalPathInUnixStyle(file);
        try {
            String string2 = this.clientServices.getRepositoryForDirectory(file.getAbsolutePath());
            this.addRequest(new DirectoryRequest(string, string2));
            String string3 = this.clientServices.getStickyTagForDirectory(file);
            if (string3 != null) {
                this.addRequest(new StickyRequest(string3));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("An error occurred reading the respository for the directory " + string + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    protected void addArgumentRequests() {
        if (this.files == null) {
            return;
        }
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            String string = this.getRelativeToLocalPathInUnixStyle(file);
            this.addRequest(new ArgumentRequest(string));
        }
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        this.requests.clear();
        this.clientServices = clientServices;
        super.execute(clientServices, eventManager);
        if (clientServices.isFirstCommand()) {
            this.addRequest(new RootRequest(clientServices.getRepository()));
        }
        this.addFileRequests();
    }

    private void addFileRequests() throws CommandException {
        try {
            if (this.files != null && this.files.length > 0) {
                for (int i = 0; i < this.files.length; ++i) {
                    this.addRequests(this.files[i]);
                }
            } else if (this.assumeLocalPathWhenUnspecified()) {
                this.addRequests(new File(this.getLocalDirectory()));
            }
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return true;
    }

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean bl, String string) {
        if (!bl) {
            return;
        }
        this.addRequest(new ArgumentRequest(string));
    }

    protected final void appendFileArguments(StringBuffer stringBuffer) {
        File[] fileArray = this.getFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(fileArray[i].getName());
        }
    }
}

