/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.export;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.RepositoryCommand;
import org.netbeans.lib.cvsclient.command.export.ExportBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;

public class ExportCommand
extends RepositoryCommand {
    private final Set emptyDirectories = new HashSet();
    private boolean pruneDirectories;
    private KeywordSubstitutionOptions keywordSubstitutionOptions;
    private String exportByDate;
    private String exportByRevision;
    private String exportDirectory;
    private boolean useHeadIfNotFound;
    private boolean notShortenPaths;
    private boolean notRunModuleProgram;

    public ExportCommand() {
        this.resetCVSCommand();
    }

    public KeywordSubstitutionOptions getKeywordSubstitutionOptions() {
        return this.keywordSubstitutionOptions;
    }

    public void setKeywordSubstitutionOptions(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubstitutionOptions = keywordSubstitutionOptions;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    protected void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.exportDirectory != null && !this.exportDirectory.equals("")) {
            this.requests.add(0, new ArgumentRequest("-d"));
            this.requests.add(1, new ArgumentRequest(this.getExportDirectory()));
        }
        if (this.exportByDate != null && this.exportByDate.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getExportByDate()));
        }
        if (this.exportByRevision != null && this.exportByRevision.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getExportByRevision()));
        }
        if (this.notShortenPaths) {
            this.requests.add(0, new ArgumentRequest("-N"));
        }
        if (this.notRunModuleProgram) {
            this.requests.add(0, new ArgumentRequest("-n"));
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubstitutionOptions()));
        }
        this.addArgumentRequests();
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(CommandRequest.EXPORT);
        try {
            clientServices.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.removeAllCVSAdminFiles();
        }
    }

    private void removeAllCVSAdminFiles() {
        File file = null;
        if (this.getExportDirectory() != null) {
            file = new File(this.getLocalDirectory(), this.getExportDirectory());
            this.deleteCVSSubDirs(file);
        } else {
            file = new File(this.getLocalDirectory());
            Iterator iterator = this.expandedModules.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                File file2 = new File(file.getAbsolutePath(), string);
                this.deleteCVSSubDirs(file2);
            }
        }
    }

    private void deleteCVSSubDirs(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                if (fileArray[i].getName().equalsIgnoreCase("CVS")) {
                    File[] fileArray2 = fileArray[i].listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        fileArray2[j].delete();
                    }
                    fileArray[i].delete();
                    continue;
                }
                this.deleteCVSSubDirs(fileArray[i]);
            }
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("export ");
        stringBuffer.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        } else {
            String string = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getExportByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getExportByDate());
            stringBuffer.append(" ");
        }
        if (this.getExportByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getExportByRevision());
            stringBuffer.append(" ");
        }
        if (this.isPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.isNotShortenPaths()) {
            stringBuffer.append("-N ");
        }
        if (this.isNotRunModuleProgram()) {
            stringBuffer.append("-n ");
        }
        if (this.getExportDirectory() != null) {
            stringBuffer.append("-d ");
            stringBuffer.append(this.getExportDirectory());
            stringBuffer.append(" ");
        }
        if (this.getKeywordSubstitutionOptions() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubstitutionOptions().toString());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'k') {
            this.setKeywordSubstitutionOptions(KeywordSubstitutionOptions.findKeywordSubstOption(string));
        } else if (c == 'r') {
            this.setExportByRevision(string);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'D') {
            this.setExportByDate(string);
        } else if (c == 'd') {
            this.setExportDirectory(string);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'N') {
            this.setNotShortenPaths(true);
        } else if (c == 'n') {
            this.setNotRunModuleProgram(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setModules(null);
        this.setKeywordSubstitutionOptions(null);
        this.setPruneDirectories(false);
        this.setRecursive(true);
        this.setExportByDate(null);
        this.setExportByRevision(null);
        this.setExportDirectory(null);
        this.setUseHeadIfNotFound(false);
        this.setNotShortenPaths(false);
        this.setNotRunModuleProgram(false);
    }

    public String getOptString() {
        return "k:r:D:NPlRnd:f";
    }

    public Builder createBuilder(EventManager eventManager) {
        return new ExportBuilder(eventManager, this);
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (this.pruneDirectories && messageEvent.getMessage().indexOf(": Exporting ") > 0) {
            File file = new File(this.getLocalDirectory(), messageEvent.getMessage().substring(21));
            this.emptyDirectories.add(file);
        }
    }

    private boolean pruneEmptyDirectory(File file) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isFile()) {
                    bl = false;
                } else if (!fileArray[i].getName().equals("CVS")) {
                    bl = this.pruneEmptyDirectory(fileArray[i]);
                }
                if (!bl) break;
            }
            if (bl && (file2 = new File(file, "CVS/Entries")).exists()) {
                File file3 = new File(file, "CVS");
                File[] fileArray2 = file3.listFiles();
                for (int i = 0; i < fileArray2.length; ++i) {
                    fileArray2[i].delete();
                }
                file3.delete();
                file.delete();
            }
        }
        return bl;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file);
        }
        this.emptyDirectories.clear();
    }

    public String getExportByDate() {
        return this.exportByDate;
    }

    public void setExportByDate(String string) {
        this.exportByDate = string;
    }

    public String getExportByRevision() {
        return this.exportByRevision;
    }

    public void setExportByRevision(String string) {
        this.exportByRevision = string;
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(String string) {
        this.exportDirectory = string;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public boolean isNotShortenPaths() {
        return this.notShortenPaths;
    }

    public void setNotShortenPaths(boolean bl) {
        this.notShortenPaths = bl;
    }

    public boolean isNotRunModuleProgram() {
        return this.notRunModuleProgram;
    }

    public void setNotRunModuleProgram(boolean bl) {
        this.notRunModuleProgram = bl;
    }
}

