/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.util.BugLog;

public class LogBuilder
implements Builder {
    private static final String LOGGING_DIR = ": Logging ";
    private static final String RCS_FILE = "RCS file: ";
    private static final String WORK_FILE = "Working file: ";
    private static final String REV_HEAD = "head: ";
    private static final String BRANCH = "branch: ";
    private static final String LOCKS = "locks: ";
    private static final String ACCESS_LIST = "access list: ";
    private static final String SYM_NAME = "symbolic names:";
    private static final String KEYWORD_SUBST = "keyword substitution: ";
    private static final String TOTAL_REV = "total revisions: ";
    private static final String SEL_REV = ";\tselected revisions: ";
    private static final String DESCRIPTION = "description:";
    private static final String REVISION = "revision ";
    private static final String DATE = "date: ";
    private static final String BRANCHES = "branches: ";
    private static final String AUTHOR = "author: ";
    private static final String STATE = "state: ";
    private static final String LINES = "lines: ";
    private static final String COMMITID = "commitid: ";
    private static final String SPLITTER = "----------------------------";
    private static final String FINAL_SPLIT = "=============================================================================";
    private static final String ERROR = ": nothing known about ";
    private static final String NO_FILE = "no file";
    protected EventManager eventManager;
    protected BasicCommand logCommand;
    protected LogInformation logInfo;
    protected LogInformation.Revision revision;
    protected String fileDirectory;
    private boolean addingSymNames;
    private boolean addingDescription;
    private boolean addingLogMessage;
    private StringBuffer tempBuffer = null;
    private List messageList;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public LogBuilder(EventManager eventManager, BasicCommand basicCommand) {
        this.logCommand = basicCommand;
        this.eventManager = eventManager;
        this.addingSymNames = false;
        this.addingDescription = false;
        this.addingLogMessage = false;
        this.logInfo = null;
        this.revision = null;
        this.messageList = new ArrayList(500);
    }

    public void outputDone() {
        if (this.logInfo != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
            this.logInfo = null;
            this.messageList = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.equals(FINAL_SPLIT)) {
            if (this.addingDescription) {
                this.addingDescription = false;
                this.logInfo.setDescription(this.tempBuffer.toString());
            }
            if (this.addingLogMessage) {
                this.addingLogMessage = false;
                this.revision.setMessage(CommandUtils.findUniqueString(this.tempBuffer.toString(), this.messageList));
            }
            if (this.revision != null) {
                this.logInfo.addRevision(this.revision);
                this.revision = null;
            }
            if (this.logInfo != null) {
                this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.logInfo));
                this.logInfo = null;
                this.tempBuffer = null;
            }
            return;
        }
        if (this.addingLogMessage) {
            if (string.startsWith(BRANCHES)) {
                this.processBranches(string.substring(BRANCHES.length()));
            } else {
                this.processLogMessage(string);
                return;
            }
        }
        if (this.addingSymNames) {
            this.processSymbolicNames(string);
        }
        if (this.addingDescription) {
            this.processDescription(string);
        }
        if (string.startsWith(REVISION)) {
            this.processRevisionStart(string);
        }
        if (string.startsWith(DATE)) {
            this.processRevisionDate(string);
        }
        if (string.startsWith(KEYWORD_SUBST)) {
            this.logInfo.setKeywordSubstitution(string.substring(KEYWORD_SUBST.length()).trim().intern());
            this.addingSymNames = false;
            return;
        }
        if (string.startsWith(DESCRIPTION)) {
            this.tempBuffer = new StringBuffer(string.substring(DESCRIPTION.length()));
            this.addingDescription = true;
        }
        if (string.indexOf(LOGGING_DIR) >= 0) {
            this.fileDirectory = string.substring(string.indexOf(LOGGING_DIR) + LOGGING_DIR.length()).trim();
            return;
        }
        if (string.startsWith(RCS_FILE)) {
            this.processRcsFile(string.substring(RCS_FILE.length()));
            return;
        }
        if (string.startsWith(WORK_FILE)) {
            this.processWorkingFile(string.substring(WORK_FILE.length()));
            return;
        }
        if (string.startsWith(REV_HEAD)) {
            this.logInfo.setHeadRevision(string.substring(REV_HEAD.length()).trim().intern());
            return;
        }
        if (string.startsWith(BRANCH)) {
            this.logInfo.setBranch(string.substring(BRANCH.length()).trim().intern());
        }
        if (string.startsWith(LOCKS)) {
            this.logInfo.setLocks(string.substring(LOCKS.length()).trim().intern());
        }
        if (string.startsWith(ACCESS_LIST)) {
            this.logInfo.setAccessList(string.substring(ACCESS_LIST.length()).trim().intern());
        }
        if (string.startsWith(SYM_NAME)) {
            this.addingSymNames = true;
        }
        if (string.startsWith(TOTAL_REV)) {
            int n = string.indexOf(59);
            if (n < 0) {
                this.logInfo.setTotalRevisions(string.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions("0");
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n, string.length());
                this.logInfo.setTotalRevisions(string2.substring(TOTAL_REV.length()).trim().intern());
                this.logInfo.setSelectedRevisions(string3.substring(SEL_REV.length()).trim().intern());
            }
        }
    }

    private String findUniqueString(String string, List list) {
        if (string == null) {
            return null;
        }
        int n = list.indexOf(string);
        if (n >= 0) {
            return (String)list.get(n);
        }
        String string2 = string;
        list.add(string2);
        return string2;
    }

    private void processRcsFile(String string) {
        if (this.logInfo != null) {
            // empty if block
        }
        this.logInfo = new LogInformation();
        this.logInfo.setRepositoryFilename(string.trim());
    }

    private void processWorkingFile(String string) {
        String string2 = string.trim();
        if (string2.startsWith(NO_FILE)) {
            string2 = string2.substring(8);
        }
        this.logInfo.setFile(this.createFile(string));
    }

    private void processBranches(String string) {
        int n = string.lastIndexOf(59);
        if (n > 0) {
            string = string.substring(0, n);
        }
        this.revision.setBranches(string.trim());
    }

    private void processLogMessage(String string) {
        if (string.startsWith(SPLITTER)) {
            this.addingLogMessage = false;
            this.revision.setMessage(this.findUniqueString(this.tempBuffer.toString(), this.messageList));
            return;
        }
        this.tempBuffer.append(string + "\n");
    }

    private void processSymbolicNames(String string) {
        int n;
        if (!string.startsWith(KEYWORD_SUBST) && (n = (string = string.trim()).indexOf(58)) > 0) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1, string.length()).trim();
            this.logInfo.addSymbolicName(string2.intern(), string3.intern());
        }
    }

    private void processDescription(String string) {
        if (string.startsWith(SPLITTER)) {
            this.addingDescription = false;
            this.logInfo.setDescription(this.tempBuffer.toString());
            return;
        }
        this.tempBuffer.append(string);
    }

    private void processRevisionStart(String string) {
        if (this.revision != null) {
            this.logInfo.addRevision(this.revision);
        }
        this.revision = this.logInfo.createNewRevision(string.substring(REVISION.length()).intern());
    }

    private void processRevisionDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith(DATE)) {
                String string3 = string2.substring(DATE.length());
                Date date = null;
                try {
                    string3 = string3.replace('/', '-') + " +0000";
                    date = this.dateFormat.parse(string3);
                }
                catch (ParseException parseException) {
                    BugLog.getInstance().bug("Couldn't parse date " + string3);
                }
                this.revision.setDate(date, string3);
                continue;
            }
            if (string2.startsWith(AUTHOR)) {
                this.revision.setAuthor(string2.substring(AUTHOR.length()));
                continue;
            }
            if (string2.startsWith(STATE)) {
                this.revision.setState(string2.substring(STATE.length()));
                continue;
            }
            if (string2.startsWith(LINES)) {
                this.revision.setLines(string2.substring(LINES.length()));
                continue;
            }
            if (!string2.startsWith(COMMITID)) continue;
            this.revision.setCommitID(string2.substring(COMMITID.length()));
        }
        this.addingLogMessage = true;
        this.tempBuffer = new StringBuffer();
    }

    protected File createFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.logCommand.getLocalDirectory());
        stringBuffer.append(File.separator);
        stringBuffer.append(string.replace('/', File.separatorChar));
        return new File(stringBuffer.toString());
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

