/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyVerifier {
    private ConsistencyVerifier() {
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set) throws IllegalArgumentException {
        ModuleManager moduleManager = new ModuleManager(new DummyInstaller(), new DummyEvents());
        moduleManager.mutexPrivileged().enterWriteAccess();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("OpenIDE-Module", "__dummy__");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Provides", "org.openide.modules.ModuleFormat1, org.openide.modules.os.Unix, org.openide.modules.os.PlainUnix, org.openide.modules.os.Windows, org.openide.modules.os.MacOSX, org.openide.modules.os.OS2");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
        try {
            moduleManager.createFixed(manifest, null, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        for (Manifest object : set) {
            try {
                object.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
                hashSet.add(moduleManager.createFixed(object, null, ClassLoader.getSystemClassLoader()));
            }
            catch (Exception module) {
                throw new IllegalArgumentException(module);
            }
        }
        TreeMap treeMap = new TreeMap();
        for (Module module : hashSet) {
            Set<Object> set2 = module.getProblems();
            if (set2.isEmpty()) continue;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Object object : set2) {
                treeSet.add(object.toString());
            }
            treeMap.put(module.getCodeNameBase(), treeSet);
        }
        return treeMap;
    }

    private static final class DummyEvents
    extends Events {
        private DummyEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyInstaller
    extends ModuleInstaller {
        private DummyInstaller() {
        }

        @Override
        public void prepare(Module module) throws InvalidException {
            throw new AssertionError();
        }

        @Override
        public void dispose(Module module) {
            throw new AssertionError();
        }

        @Override
        public void load(List<Module> list) {
            throw new AssertionError();
        }

        @Override
        public void unload(List<Module> list) {
            throw new AssertionError();
        }

        @Override
        public boolean closing(List<Module> list) {
            throw new AssertionError();
        }

        @Override
        public void close(List<Module> list) {
            throw new AssertionError();
        }
    }
}

