/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.PatchByteCode;
import org.netbeans.ProxyClassLoader;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassLoader
extends ProxyClassLoader {
    private static final Logger LOGGER = Logger.getLogger(JarClassLoader.class.getName());
    private Source[] sources;
    private Set<JarFile> deadJars = null;

    public JarClassLoader(List<Union2<File, JarFile>> list, ClassLoader[] classLoaderArray) {
        this(list, classLoaderArray, true);
    }

    public JarClassLoader(List<Union2<File, JarFile>> list, ClassLoader[] classLoaderArray, boolean bl) {
        super(classLoaderArray, bl);
        this.sources = new Source[list.size()];
        try {
            int n = 0;
            for (Union2<File, JarFile> union2 : list) {
                if (union2.hasFirst()) {
                    this.sources[n++] = new DirSource((File)union2.first(), this);
                    continue;
                }
                this.sources[n++] = new JarSource((JarFile)union2.second(), this);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    final void addSources(List<Union2<File, JarFile>> list) {
        ArrayList<Source> arrayList = new ArrayList<Source>(this.sources.length + list.size());
        arrayList.addAll(Arrays.asList(this.sources));
        try {
            for (Union2<File, JarFile> union2 : list) {
                if (union2.hasFirst()) {
                    arrayList.add(new DirSource((File)union2.first(), this));
                    continue;
                }
                arrayList.add(new JarSource((JarFile)union2.second(), this));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
        this.sources = arrayList.toArray(this.sources);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return Policy.getPolicy().getPermissions(codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        if (manifest == null) {
            return this.definePackage(string, null, null, null, null, null, null, null);
        }
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_TITLE);
        String string4 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_TITLE);
        String string5 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VERSION);
        String string6 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VERSION);
        String string7 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VENDOR);
        String string8 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VENDOR);
        String string9 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SEALED);
        URL uRL2 = "true".equalsIgnoreCase(string9) ? uRL : null;
        return this.definePackage(string, string3, string5, string7, string4, string6, string8, uRL2);
    }

    private static String getAttr(Attributes attributes, Attributes attributes2, Attributes.Name name) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null && attributes2 != null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    @Override
    protected Class simpleFindClass(String string, String string2, String string3) {
        for (int i = 0; i < this.sources.length; ++i) {
            Source source = this.sources[i];
            byte[] byArray = source.getClassData(string, string2);
            if (byArray == null) continue;
            byte[] byArray2 = PatchByteCode.patch(byArray, string);
            byArray = byArray2;
            int n = string.lastIndexOf(46);
            String string4 = string.substring(0, n);
            Package package_ = this.getPackageFast(string4, string3, this.isSpecialResource(string3));
            if (package_ != null) {
                if (package_.isSealed() && !package_.isSealed(source.getURL())) {
                    throw new SecurityException("sealing violation");
                }
            } else {
                Manifest manifest = source.getManifest();
                this.definePackage(string4, manifest, source.getURL());
            }
            return this.defineClass(string, byArray, 0, byArray.length, source.getProtectionDomain());
        }
        return null;
    }

    @Override
    protected URL findResource(String string) {
        for (int i = 0; i < this.sources.length; ++i) {
            URL uRL = this.sources[i].getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> simpleFindResources(String string) {
        Vector<URL> vector = new Vector<URL>(3);
        for (int i = 0; i < this.sources.length; ++i) {
            URL uRL = this.sources[i].getResource(string);
            if (uRL == null) continue;
            vector.add(uRL);
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        assert (this.deadJars == null) : "Already had dead JARs: " + this.deadJars;
        this.deadJars = new HashSet<JarFile>();
        try {
            for (int i = 0; i < this.sources.length; ++i) {
                Closeable closeable;
                String string;
                String string2;
                JarFile jarFile;
                File file;
                if (!(this.sources[i] instanceof JarSource) || !(file = new File((jarFile = ((JarSource)this.sources[i]).getJarFile()).getName())).isFile()) continue;
                String string3 = file.getName();
                int n = string3.lastIndexOf(46);
                if (n == -1) {
                    string2 = string3;
                    string = null;
                } else {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n);
                }
                while (string2.length() < 3) {
                    string2 = string2 + "x";
                }
                File file2 = File.createTempFile(string2, string);
                file2.deleteOnExit();
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    closeable = new FileOutputStream(file2);
                    try {
                        int n2;
                        byte[] byArray = new byte[4096];
                        while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                            ((OutputStream)closeable).write(byArray, 0, n2);
                        }
                    }
                    finally {
                        ((OutputStream)closeable).close();
                    }
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                closeable = new JarFile(file2);
                jarFile.close();
                this.deadJars.add((JarFile)closeable);
                this.sources[i] = new JarSource((JarFile)closeable, this);
                LOGGER.log(Level.FINE, "#21114: replacing {0} with {1}", new Object[]{file, file2});
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.sources.length; ++i) {
            if (!(this.sources[i] instanceof JarSource)) continue;
            JarFile jarFile = ((JarSource)this.sources[i]).getJarFile();
            File file = new File(jarFile.getName());
            jarFile.close();
            if (this.deadJars == null || !this.deadJars.contains(jarFile)) continue;
            LOGGER.log(Level.FINE, "#21114: closing and deleting temporary JAR {0}", file);
            if (!file.isFile() || file.delete()) continue;
            LOGGER.log(Level.FINE, "(but failed to delete {0})", file);
        }
    }

    static class DirSource
    extends Source {
        File dir;

        public DirSource(File file, JarClassLoader jarClassLoader) throws MalformedURLException {
            super(file.toURI().toURL(), jarClassLoader);
            this.dir = file;
        }

        protected URL doGetResource(String string) throws MalformedURLException {
            File file = new File(this.dir, string);
            return file.exists() ? file.toURI().toURL() : null;
        }

        protected byte[] readClass(String string, String string2) throws IOException {
            File file = new File(this.dir, string2.replace('/', File.separatorChar));
            if (!file.exists()) {
                return null;
            }
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            for (int i = 0; i < n; i += ((InputStream)fileInputStream).read(byArray, i, n - i)) {
            }
            return byArray;
        }
    }

    static class JarSource
    extends Source {
        JarFile src;
        private String resPrefix;

        public JarSource(JarFile jarFile, JarClassLoader jarClassLoader) throws MalformedURLException {
            super(new File(jarFile.getName()).toURI().toURL(), jarClassLoader);
            this.src = jarFile;
            this.resPrefix = "jar:" + new File(this.src.getName()).toURI() + "!/";
        }

        public Manifest getManifest() {
            try {
                return this.src.getManifest();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        JarFile getJarFile() {
            return this.src;
        }

        protected URL doGetResource(String string) throws MalformedURLException {
            ZipEntry zipEntry;
            try {
                zipEntry = this.src.getEntry(string);
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
            if (zipEntry == null) {
                return null;
            }
            LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{string, this.src.getName()});
            return new URL(this.resPrefix + zipEntry.getName());
        }

        protected byte[] readClass(String string, String string2) throws IOException {
            ZipEntry zipEntry;
            try {
                zipEntry = this.src.getEntry(string2);
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
            if (zipEntry == null) {
                return null;
            }
            LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{string2, this.src.getName()});
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            InputStream inputStream = this.src.getInputStream(zipEntry);
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
            return byArray;
        }
    }

    static abstract class Source {
        private URL url;
        private ProtectionDomain pd;
        protected JarClassLoader jcl;

        public Source(URL uRL, JarClassLoader jarClassLoader) {
            this.url = uRL;
            this.jcl = jarClassLoader;
        }

        public final URL getURL() {
            return this.url;
        }

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource codeSource = new CodeSource(this.url, new Certificate[0]);
                this.pd = new ProtectionDomain(codeSource, this.jcl.getPermissions(codeSource));
            }
            return this.pd;
        }

        public final URL getResource(String string) {
            try {
                return this.doGetResource(string);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws MalformedURLException;

        public final byte[] getClassData(String string, String string2) {
            try {
                return this.readClass(string, string2);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
                return null;
            }
        }

        protected abstract byte[] readClass(String var1, String var2) throws IOException;

        public Manifest getManifest() {
            return null;
        }
    }
}

