/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.search.SearchPerformer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public final class ProjectsSearchAction
extends CallableSystemAction
implements PropertyChangeListener {
    static final long serialVersionUID = 4554342565076372610L;
    private static final String VAR_FIRST_ISENABLED = "first call of isEnabled()";
    private static final String VAR_TOOLBAR_COMP_REF = "toolbar presenter ref";
    private static final String VAR_LISTENING = "listening";

    protected void initialize() {
        super.initialize();
        this.putProperty(VAR_FIRST_ISENABLED, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getToolbarPresenter() {
        Object object = this.getLock();
        synchronized (object) {
            Component component = this.getStoredToolbarPresenter();
            if (this.putProperty(VAR_LISTENING, Boolean.TRUE) == null) {
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                this.putProperty(VAR_FIRST_ISENABLED, null);
                this.updateState();
            }
            return component;
        }
    }

    private Component getStoredToolbarPresenter() {
        Object object;
        Object t;
        Object object2 = this.getProperty(VAR_TOOLBAR_COMP_REF);
        if (object2 != null && (t = ((Reference)(object = (Reference)object2)).get()) != null) {
            return (Component)t;
        }
        object = super.getToolbarPresenter();
        this.putProperty(VAR_TOOLBAR_COMP_REF, new WeakReference<Object>(object));
        return object;
    }

    private boolean checkToolbarPresenterExists() {
        Object object = this.getProperty(VAR_TOOLBAR_COMP_REF);
        if (object == null) {
            return false;
        }
        return ((Reference)object).get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty(VAR_LISTENING) == null) {
                return;
            }
            if (this.checkToolbarPresenterExists()) {
                this.updateState();
            } else {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                this.putProperty(VAR_LISTENING, null);
                this.putProperty(VAR_TOOLBAR_COMP_REF, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty(VAR_LISTENING) != null) {
                return super.isEnabled();
            }
            if (this.getProperty(VAR_FIRST_ISENABLED) == null) {
                return OpenProjects.getDefault().getOpenProjects().length != 0;
            }
            this.putProperty(VAR_FIRST_ISENABLED, null);
            return false;
        }
    }

    private synchronized void updateState() {
        final boolean bl = OpenProjects.getDefault().getOpenProjects().length != 0;
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                ProjectsSearchAction.this.setEnabled(bl);
            }
        });
    }

    protected String iconResource() {
        return "org/openide/resources/actions/find.gif";
    }

    public String getName() {
        return NbBundle.getMessage(ProjectsSearchAction.class, (String)"LBL_SearchProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectsSearchAction.class);
    }

    Node[] getNodesToSearch() {
        Object object;
        Node[] nodeArray;
        int n;
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        if (projectArray.length == 0) {
            return new Node[0];
        }
        ArrayList<Node[]> arrayList = new ArrayList<Node[]>();
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        for (n = 0; n < projectArray.length; ++n) {
            nodeArray = (Node[])projectArray[n].getLookup().lookup(SearchInfo.class);
            if (nodeArray != null) {
                arrayList.add(nodeArray);
                continue;
            }
            Sources sources = ProjectUtils.getSources((Project)projectArray[n]);
            object = sources.getSourceGroups("generic");
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList2.add(object[i].getRootFolder());
            }
        }
        n = 0;
        if (!arrayList.isEmpty()) {
            n += arrayList.size();
        }
        if (!arrayList2.isEmpty()) {
            ++n;
        }
        if (n == 0) {
            return new Node[0];
        }
        nodeArray = new Node[n];
        int n2 = 0;
        if (!arrayList.isEmpty()) {
            for (SearchInfo searchInfo : arrayList) {
                nodeArray[n2++] = new AbstractNode(Children.LEAF, Lookups.singleton((Object)searchInfo));
            }
        }
        if (!arrayList2.isEmpty()) {
            object = SearchInfoFactory.createSearchInfo((FileObject[])arrayList2.toArray(new FileObject[arrayList2.size()]), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER});
            nodeArray[n2++] = new AbstractNode(Children.LEAF, Lookups.singleton((Object)object));
        }
        nodeArray[0].setValue("Find Files dialog title", (Object)NbBundle.getMessage(ProjectsSearchAction.class, (String)"LBL_Title_SearchProjects"));
        return nodeArray;
    }

    public void performAction() {
        SearchPerformer searchPerformer = (SearchPerformer)SharedClassObject.findObject(SearchPerformer.class, (boolean)true);
        searchPerformer.performAction(this.getNodesToSearch());
    }

    protected boolean asynchronous() {
        return false;
    }
}

