/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.modules.timers.TimesCollectorPeer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class TimeComponentPanel
extends JPanel
implements PropertyChangeListener {
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable times;
    private Map<String, Integer> key2RowNumber;

    public TimeComponentPanel() {
        this.initComponents();
        this.times.addMouseListener((MouseListener)((Object)new PopupAdapter()));
        this.jList1.addMouseListener((MouseListener)((Object)new ListPopupAdapter()));
        this.key2RowNumber = new HashMap<String, Integer>();
        TimesCollectorPeer.getDefault().addPropertyChangeListener(this);
        this.fillIn();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.times = new JTable();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(8);
        this.jSplitPane1.setOrientation(0);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new FileObjectListRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TimeComponentPanel.this.jList1ValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.times.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Time"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Long.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jScrollPane2.setViewportView(this.times);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jList1ValueChanged(ListSelectionEvent listSelectionEvent) {
        this.fillTimeTable();
    }

    private void fillTimeTable() {
        Collection<String> collection;
        FileObject fileObject = (FileObject)this.jList1.getSelectedValue();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.times.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        this.key2RowNumber.clear();
        if (fileObject != null) {
            collection = TimesCollectorPeer.getDefault().getKeysForFile(fileObject);
            for (String string : collection) {
                this.changeRow(fileObject, string);
            }
        }
        collection = TimesCollectorPeer.getDefault().getKeysForFile(fileObject);
        for (String string : collection) {
            this.changeRow(fileObject, string);
        }
    }

    private TimesCollectorPeer.Description getDescForRow(FileObject fileObject, int n) {
        Collection<String> collection = TimesCollectorPeer.getDefault().getKeysForFile(fileObject);
        Iterator<String> iterator = collection.iterator();
        String string = null;
        for (int i = 0; i <= n; ++i) {
            assert (iterator.hasNext());
            string = iterator.next();
        }
        return TimesCollectorPeer.getDefault().getDescription(fileObject, string);
    }

    private void changeRow(FileObject fileObject, String string) {
        TimesCollectorPeer.Description description;
        Integer n = this.key2RowNumber.get(string);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.times.getModel();
        if (n != null) {
            defaultTableModel.removeRow(n);
        }
        if ((description = TimesCollectorPeer.getDefault().getDescription(fileObject, string)) == null) {
            return;
        }
        if (n == null) {
            n = defaultTableModel.getRowCount();
            this.key2RowNumber.put(string, n);
        }
        defaultTableModel.insertRow((int)n, new Object[]{description.getMessage(), description.getTime()});
    }

    private void fillIn() {
        DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
        defaultListModel.removeAllElements();
        for (FileObject fileObject : TimesCollectorPeer.getDefault().getFiles()) {
            defaultListModel.addElement(fileObject);
        }
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultListModel defaultListModel;
                if ("fos".equals(propertyChangeEvent.getPropertyName())) {
                    defaultListModel = (DefaultListModel)TimeComponentPanel.this.jList1.getModel();
                    if (propertyChangeEvent.getNewValue() != null) {
                        defaultListModel.addElement(propertyChangeEvent.getNewValue());
                    } else {
                        TimeComponentPanel.this.fillIn();
                    }
                }
                if ("PROP".equals(propertyChangeEvent.getPropertyName())) {
                    defaultListModel = (FileObject)propertyChangeEvent.getOldValue();
                    String string = (String)propertyChangeEvent.getNewValue();
                    if (defaultListModel == TimeComponentPanel.this.jList1.getSelectedValue() || defaultListModel == null) {
                        TimeComponentPanel.this.changeRow((FileObject)defaultListModel, string);
                    }
                }
                if ("selected".equals(propertyChangeEvent.getPropertyName())) {
                    defaultListModel = (FileObject)propertyChangeEvent.getNewValue();
                    TimeComponentPanel.this.jList1.setSelectedValue(defaultListModel, true);
                }
            }
        });
    }

    private static void dumpRoots(Collection collection) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JProgressBar jProgressBar = new JProgressBar();
        jPanel.add((Component)new JLabel("Computing object reachability"), "Center");
        jPanel.add((Component)jProgressBar, "South");
        Dialog dialog = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)jPanel, "Please wait"));
        dialog.pack();
        dialog.setModal(false);
        dialog.setVisible(true);
        String string = TimeComponentPanel.getRoots(collection, jProgressBar, jPanel);
        jPanel.removeAll();
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setColumns(80);
        jTextArea.setEditable(false);
        jScrollPane.setViewportView(jTextArea);
        jPanel.add((Component)jScrollPane, "Center");
        dialog.setSize(Math.min(600, jTextArea.getPreferredSize().width + 30), Math.min(400, jTextArea.getPreferredSize().height + 70));
        dialog.invalidate();
        dialog.validate();
        dialog.repaint();
    }

    private static String getRoots(Collection collection, JProgressBar jProgressBar, final JPanel jPanel) {
        jProgressBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jPanel.paintImmediately(jPanel.getBounds());
            }
        });
        Map map = LiveReferences.fromRoots(collection, null, jProgressBar.getModel());
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            stringBuffer.append(k);
            stringBuffer.append(":\n");
            stringBuffer.append(map.get(k));
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    private static class FileObjectListRenderer
    extends DefaultListCellRenderer {
        private NodeRenderer r = new NodeRenderer();

        private FileObjectListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof FileObject) {
                try {
                    FileObject fileObject = (FileObject)object;
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    Node node = dataObject.getNodeDelegate();
                    return this.r.getListCellRendererComponent(jList, (Object)node, n, bl, bl2);
                }
                catch (IOException iOException) {
                    object = "<error>";
                }
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    class ListPopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        ListPopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TimeComponentPanel.this.jList1.locationToIndex(mouseEvent.getPoint());
            if (!TimeComponentPanel.this.jList1.isSelectedIndex(n)) {
                TimeComponentPanel.this.jList1.getSelectionModel().setSelectionInterval(n, n);
            }
            if (n != -1) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), TimeComponentPanel.this);
                this.createPopup((int)point.getX(), (int)point.getY(), n);
            }
        }

        void createPopup(int n, int n2, int n3) {
            final FileObject[] fileObjectArray = new FileObject[]{(FileObject)TimeComponentPanel.this.jList1.getSelectedValue()};
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new AbstractAction("Find refs"){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FileObject fileObject = fileObjectArray[0];
                        fileObjectArray[0] = null;
                        TimeComponentPanel.dumpRoots(Collections.singleton(DataObject.find((FileObject)fileObject)));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Logger.getLogger("global").log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
                    }
                }
            });
            jPopupMenu.show(TimeComponentPanel.this, n, n2);
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TimeComponentPanel.this.times.rowAtPoint(mouseEvent.getPoint());
            if (!TimeComponentPanel.this.times.isRowSelected(n)) {
                TimeComponentPanel.this.times.getSelectionModel().setSelectionInterval(n, n);
            }
            if (n != -1) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), TimeComponentPanel.this);
                this.createPopup((int)point.getX(), (int)point.getY(), n);
            }
        }

        void createPopup(int n, int n2, int n3) {
            TimesCollectorPeer.Description description = TimeComponentPanel.this.getDescForRow((FileObject)TimeComponentPanel.this.jList1.getSelectedValue(), n3);
            if (!(description instanceof TimesCollectorPeer.ObjectCountDescripton)) {
                return;
            }
            final TimesCollectorPeer.ObjectCountDescripton objectCountDescripton = (TimesCollectorPeer.ObjectCountDescripton)description;
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new AbstractAction("Find refs"){

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeComponentPanel.dumpRoots(objectCountDescripton.getInstances());
                }
            });
            jPopupMenu.show(TimeComponentPanel.this, n, n2);
        }
    }
}

