/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.modules.diff.builtin.visualizer.editable.HotSpot;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class DiffSplitPaneDivider
extends BasicSplitPaneDivider
implements MouseMotionListener,
MouseListener {
    private final Image insertAllImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/move_all.png");
    private final Image insertAllActiveImage = Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/move_all_active.png");
    private final int actionIconsHeight;
    private final int actionIconsWidth;
    private final Point POINT_ZERO;
    private final EditableDiffView master;
    private Point lastMousePosition = this.POINT_ZERO = new Point(0, 0);
    private HotSpot lastHotSpot = null;
    private List<HotSpot> hotspots = new ArrayList<HotSpot>(0);
    private DiffSplitDivider mydivider;

    DiffSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI, EditableDiffView editableDiffView) {
        super(basicSplitPaneUI);
        this.master = editableDiffView;
        this.actionIconsHeight = this.insertAllImage.getHeight(this);
        this.actionIconsWidth = this.insertAllImage.getWidth(this);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.mydivider = new DiffSplitDivider();
        this.add(this.mydivider);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        editableDiffView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DiffSplitPaneDivider.this.repaint();
            }
        });
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        HotSpot hotSpot;
        if (!mouseEvent.isPopupTrigger() && (hotSpot = this.getHotspotAt(mouseEvent.getPoint())) != null) {
            this.performAction();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.lastMousePosition = this.POINT_ZERO;
        if (this.lastHotSpot != null) {
            this.mydivider.repaint(this.lastHotSpot.getRect());
        }
        this.lastHotSpot = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point;
        this.lastMousePosition = point = mouseEvent.getPoint();
        HotSpot hotSpot = this.getHotspotAt(point);
        if (this.lastHotSpot != hotSpot) {
            this.mydivider.repaint(this.lastHotSpot == null ? hotSpot.getRect() : this.lastHotSpot.getRect());
        }
        this.lastHotSpot = hotSpot;
        this.setCursor(hotSpot != null ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(11));
    }

    private void performAction() {
        this.master.rollback(null);
    }

    public void setBorder(Border border) {
        super.setBorder(BorderFactory.createEmptyBorder());
    }

    DiffSplitDivider getDivider() {
        return this.mydivider;
    }

    private HotSpot getHotspotAt(Point point) {
        for (HotSpot hotSpot : this.hotspots) {
            if (!hotSpot.getRect().contains(point)) continue;
            return hotSpot;
        }
        return null;
    }

    private class DiffSplitDivider
    extends JComponent {
        private Map renderingHints;

        public DiffSplitDivider() {
            this.setBackground(UIManager.getColor("SplitPane.background"));
            this.setOpaque(true);
            this.renderingHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            HotSpot hotSpot = DiffSplitPaneDivider.this.getHotspotAt(point);
            if (hotSpot == null) {
                return null;
            }
            return NbBundle.getMessage(DiffSplitDivider.class, (String)"TT_DiffPanel_MoveAll");
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle = graphics2D.getClipBounds();
            Stroke stroke = graphics2D.getStroke();
            Rectangle rectangle2 = DiffSplitPaneDivider.this.master.getEditorPane2().getScrollPane().getViewport().getViewRect();
            Rectangle rectangle3 = DiffSplitPaneDivider.this.master.getEditorPane1().getScrollPane().getViewport().getViewRect();
            int n = ((DiffSplitPaneDivider)DiffSplitPaneDivider.this).master.getEditorPane2().getLocation().y + ((DiffSplitPaneDivider)DiffSplitPaneDivider.this).master.getEditorPane2().getInsets().top;
            int n2 = -rectangle2.y + n;
            int n3 = -rectangle3.y + n;
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.renderingHints != null) {
                graphics2D.addRenderingHints(this.renderingHints);
            }
            String string = DiffSplitPaneDivider.this.master.getCurrentDifference() + 1 + "/" + DiffSplitPaneDivider.this.master.getDifferenceCount();
            int n4 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, (this.getWidth() - n4) / 2, graphics2D.getFontMetrics().getHeight());
            if (rectangle.y < n) {
                graphics2D.setClip(rectangle.x, n, rectangle.width, rectangle.height);
            }
            int n5 = this.getWidth() - 1;
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.drawLine(0, rectangle.y, 0, rectangle.height);
            graphics2D.drawLine(n5, rectangle.y, n5, rectangle.height);
            int n6 = DiffSplitPaneDivider.this.master.getCurrentDifference();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            DiffViewManager.DecoratedDifference[] decoratedDifferenceArray = DiffSplitPaneDivider.this.master.getManager().getDecorations();
            int n7 = 0;
            for (DiffViewManager.DecoratedDifference decoratedDifference : decoratedDifferenceArray) {
                graphics2D.setColor(DiffSplitPaneDivider.this.master.getColor(decoratedDifference.getDiff()));
                graphics2D.setStroke(n6 == n7++ ? DiffSplitPaneDivider.this.master.getBoldStroke() : stroke);
                if (decoratedDifference.getBottomLeft() == -1) {
                    this.paintMatcher(graphics2D, DiffSplitPaneDivider.this.master.getColor(decoratedDifference.getDiff()), 0, n5, decoratedDifference.getTopLeft() + n3, decoratedDifference.getTopRight() + n2, decoratedDifference.getBottomRight() + n2, decoratedDifference.getTopLeft() + n3);
                    continue;
                }
                if (decoratedDifference.getBottomRight() == -1) {
                    this.paintMatcher(graphics2D, DiffSplitPaneDivider.this.master.getColor(decoratedDifference.getDiff()), 0, n5, decoratedDifference.getTopLeft() + n3, decoratedDifference.getTopRight() + n2, decoratedDifference.getTopRight() + n2, decoratedDifference.getBottomLeft() + n3);
                    continue;
                }
                this.paintMatcher(graphics2D, DiffSplitPaneDivider.this.master.getColor(decoratedDifference.getDiff()), 0, n5, decoratedDifference.getTopLeft() + n3, decoratedDifference.getTopRight() + n2, decoratedDifference.getBottomRight() + n2, decoratedDifference.getBottomLeft() + n3);
            }
            if (DiffSplitPaneDivider.this.master.isActionsEnabled()) {
                ArrayList arrayList = new ArrayList();
                Rectangle rectangle4 = new Rectangle((this.getWidth() - DiffSplitPaneDivider.this.actionIconsWidth) / 2, n, DiffSplitPaneDivider.this.actionIconsWidth, DiffSplitPaneDivider.this.actionIconsHeight);
                if (rectangle4.contains(DiffSplitPaneDivider.this.lastMousePosition)) {
                    graphics2D.drawImage(DiffSplitPaneDivider.this.insertAllActiveImage, rectangle4.x, rectangle4.y, this);
                } else {
                    graphics2D.drawImage(DiffSplitPaneDivider.this.insertAllImage, rectangle4.x, rectangle4.y, this);
                }
                arrayList.add(new HotSpot(rectangle4, null));
                DiffSplitPaneDivider.this.hotspots = arrayList;
            }
            graphics2D.dispose();
        }

        private void paintMatcher(Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4, int n5, int n6) {
            CubicCurve2D.Float float_ = new CubicCurve2D.Float(n, n3, (float)(n2 - n) * 0.3f, n3, (float)(n2 - n) * 0.7f, n4, n2, n4);
            CubicCurve2D.Float float_2 = new CubicCurve2D.Float(n2, n5, (float)(n2 - n) * 0.7f, n5, (float)(n2 - n) * 0.3f, n6, n, n6);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(float_, false);
            generalPath.append(float_2, true);
            generalPath.closePath();
            graphics2D.setColor(color);
            graphics2D.fill(generalPath);
            graphics2D.setColor(DiffSplitPaneDivider.this.master.getColorLines());
            graphics2D.draw(float_);
            graphics2D.draw(float_2);
        }
    }
}

