/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.diff.NestableDiffView;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.netbeans.modules.diff.builtin.visualizer.GraphicalDiffVisualizer;
import org.netbeans.modules.diff.builtin.visualizer.SourceTranslatorAction;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffMark;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffSplitPaneDivider;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditableDiffView
implements DiffView,
NestableDiffView,
DocumentListener,
AncestorListener,
PropertyChangeListener {
    private Stroke boldStroke = new BasicStroke(3.0f);
    private Color colorMissing = new Color(255, 160, 180);
    private Color colorAdded = new Color(180, 255, 180);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorLines = Color.DARK_GRAY;
    private Color COLOR_READONLY_BG = new Color(240, 240, 240);
    private final Difference[] NO_DIFFERENCES = new Difference[0];
    private DiffContentPanel jEditorPane1;
    private DiffContentPanel jEditorPane2;
    private boolean secondSourceAvailable;
    private boolean firstSourceAvailable;
    private JViewport jViewport2;
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final JSplitPane jSplitPane1 = new JSplitPane();
    private int diffSerial;
    private Difference[] diffs = this.NO_DIFFERENCES;
    private int currentDiffIndex = -1;
    private boolean isSetCurrentDifferenceContext = false;
    private int totalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private RequestProcessor.Task refreshDiffTask;
    private DiffViewManager manager;
    private boolean actionsEnabled;
    private DiffSplitPaneUI spui;
    private EditorCookie.Observable editableCookie;
    private Document editableDocument;
    private UndoRedo.Manager editorUndoRedo;
    private EditableDiffMarkProvider diffMarkprovider;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public EditableDiffView() {
    }

    public EditableDiffView(final StreamSource streamSource, final StreamSource streamSource2) throws IOException {
        String string;
        this.refreshDiffTask = RequestProcessor.getDefault().create((Runnable)new RefreshDiffTask());
        this.initColors();
        String string2 = streamSource.getTitle();
        if (string2 == null) {
            string2 = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        if ((string = streamSource2.getTitle()) == null) {
            string = NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoTitle");
        }
        String string3 = streamSource.getMIMEType();
        String string4 = streamSource2.getMIMEType();
        if (string3 == null) {
            string3 = string4;
        }
        if (string4 == null) {
            string4 = string3;
        }
        this.actionsEnabled = streamSource2.isEditable();
        this.diffMarkprovider = new EditableDiffMarkProvider();
        this.jEditorPane1 = new DiffContentPanel(this, true);
        this.jEditorPane2 = new DiffContentPanel(this, false);
        this.jEditorPane2.getEditorPane().putClientProperty("org.netbeans.modules.diff.builtin.visualizer.editable.MarkProvider", (Object)this.diffMarkprovider);
        this.initComponents();
        this.jSplitPane1.setName(NbBundle.getMessage(EditableDiffView.class, (String)"DiffComponent.title"));
        this.spui = new DiffSplitPaneUI(this.jSplitPane1);
        this.jSplitPane1.setUI(this.spui);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setDividerSize(32);
        this.jSplitPane1.putClientProperty("PersistenceType", "Never");
        this.jSplitPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yName"));
        this.jSplitPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_DiffPanelA11yDesc"));
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditableDiffView.class, (String)"ACS_EditorPane2A11yDescr"));
        this.jSplitPane1.addAncestorListener(this);
        this.setSourceTitle(this.fileLabel1, string2);
        this.setSourceTitle(this.fileLabel2, string);
        Dimension dimension = this.fileLabel1.getPreferredSize();
        Dimension dimension2 = this.fileLabel2.getPreferredSize();
        if (dimension.width > dimension2.width) {
            this.fileLabel2.setPreferredSize(new Dimension(dimension.width, dimension2.height));
        } else {
            this.fileLabel1.setPreferredSize(new Dimension(dimension2.width, dimension.height));
        }
        final String string5 = string3;
        final String string6 = string4;
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    Color color;
                    EditableDiffView.this.jEditorPane1.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)string5));
                    EditableDiffView.this.jEditorPane2.getEditorPane().setEditorKit(CloneableEditorSupport.getEditorKit((String)string6));
                    try {
                        EditableDiffView.this.setSource1(streamSource);
                        EditableDiffView.this.setSource2(streamSource2);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    if (!EditableDiffView.this.secondSourceAvailable) {
                        EditableDiffView.this.jEditorPane2.getEditorPane().setText(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                    }
                    if (!EditableDiffView.this.firstSourceAvailable) {
                        EditableDiffView.this.jEditorPane1.getEditorPane().setText(NbBundle.getMessage(EditableDiffView.class, (String)"CTL_DiffPanel_NoContent"));
                    }
                    int n = EditableDiffView.this.jEditorPane2.getEditorPane().getBackground().getRGB() & 0xFFFFFF;
                    if (EditableDiffView.this.jEditorPane2.getEditorPane().isEditable() && n == 0xFFFFFF) {
                        EditableDiffView.this.jEditorPane1.getEditorPane().setBackground(EditableDiffView.this.COLOR_READONLY_BG);
                    }
                    if (n == 0) {
                        EditableDiffView.this.colorLines = Color.WHITE;
                    }
                    if ((color = UIManager.getColor("scrollpane_border")) == null) {
                        color = UIManager.getColor("controlShadow");
                    }
                    EditableDiffView.this.jEditorPane1.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane2.getScrollPane().setBorder(null);
                    EditableDiffView.this.jEditorPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    EditableDiffView.this.jEditorPane2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                    EditableDiffView.this.jSplitPane1.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)invocationTargetException);
        }
        this.refreshDiffTask.run();
        this.manager = new DiffViewManager(this);
        this.manager.init();
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    private void initColors() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DiffVisualizer.class));
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof GraphicalDiffVisualizer)) continue;
            GraphicalDiffVisualizer graphicalDiffVisualizer = (GraphicalDiffVisualizer)e;
            this.colorAdded = graphicalDiffVisualizer.getColorAdded();
            this.colorChanged = graphicalDiffVisualizer.getColorChanged();
            this.colorMissing = graphicalDiffVisualizer.getColorMissing();
        }
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.expandFolds();
        this.initGlobalSizes();
        this.addChangeListeners();
        this.refreshDiff(50);
        if (this.editableCookie == null) {
            return;
        }
        this.refreshEditableDocument();
        this.editableCookie.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void refreshEditableDocument() {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.editableCookie.openDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Getting new Document from EditorCookie", iOException);
            return;
        }
        this.editableDocument.removeDocumentListener(this);
        if (styledDocument != this.editableDocument) {
            this.editableDocument = styledDocument;
            this.jEditorPane2.getEditorPane().setDocument(this.editableDocument);
            this.refreshDiff(20);
        }
        this.editableDocument.addDocumentListener(this);
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (this.editableCookie != null) {
            this.editableDocument.removeDocumentListener(this);
            this.saveModifiedDocument();
            this.editableCookie.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.editableCookie.getOpenedPanes() == null) {
                this.editableCookie.close();
            }
        }
    }

    private void saveModifiedDocument() {
        SaveCookie saveCookie;
        DataObject dataObject = (DataObject)this.editableDocument.getProperty("stream");
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(EditableDiffView.class.getName()).log(Level.INFO, "Error saving Diff document", iOException);
            }
        }
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshDiff(50);
    }

    Color getColor(Difference difference) {
        if (difference.getType() == 1) {
            return this.colorAdded;
        }
        if (difference.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorMissing;
    }

    JComponent getMyDivider() {
        return this.spui.divider.getDivider();
    }

    DiffContentPanel getEditorPane1() {
        return this.jEditorPane1;
    }

    DiffContentPanel getEditorPane2() {
        return this.jEditorPane2;
    }

    public DiffViewManager getManager() {
        return this.manager;
    }

    Difference[] getDifferences() {
        return this.diffs;
    }

    void rollback(Difference difference) {
        if (difference == null) {
            try {
                Document document = this.getEditorPane2().getEditorPane().getDocument();
                Document document2 = this.getEditorPane1().getEditorPane().getDocument();
                document.remove(0, document.getLength());
                document.insertString(0, document2.getText(0, document2.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            return;
        }
        try {
            Document document = this.getEditorPane2().getEditorPane().getDocument();
            if (difference.getType() == 1) {
                int n = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondStart() - 1);
                int n2 = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondEnd());
                document.remove(n, n2 - n);
            } else if (difference.getType() == 0) {
                int n = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondStart());
                document.insertString(n, difference.getFirstText(), null);
            } else {
                int n = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondStart() - 1);
                int n3 = DiffViewManager.getRowStartFromLineOffset(document, difference.getSecondEnd());
                document.remove(n, n3 - n);
                document.insertString(n, difference.getFirstText(), null);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    Stroke getBoldStroke() {
        return this.boldStroke;
    }

    public boolean requestFocusInWindow() {
        return this.jEditorPane1.requestFocusInWindow();
    }

    public JComponent getComponent() {
        return this.jSplitPane1;
    }

    public int getDifferenceCount() {
        return this.diffs.length;
    }

    public boolean canSetCurrentDifference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentDifference(int n) throws UnsupportedOperationException {
        if (n < -1 || n >= this.diffs.length) {
            throw new IllegalArgumentException("Illegal difference number: " + n);
        }
        if (n != -1) {
            if (this.currentDiffIndex == n) {
                return;
            }
            try {
                this.isSetCurrentDifferenceContext = true;
                int n2 = this.currentDiffIndex;
                this.currentDiffIndex = n;
                this.showCurrentDifference();
                this.support.firePropertyChange("diffCount", n2, this.currentDiffIndex);
            }
            finally {
                this.isSetCurrentDifferenceContext = false;
            }
        }
    }

    public int getCurrentDifference() {
        return this.currentDiffIndex;
    }

    private int computeCurrentDifference() {
        if (this.manager == null) {
            return 0;
        }
        Rectangle rectangle = this.jViewport2.getViewRect();
        int n = rectangle.y + rectangle.height * 4 / 5;
        DiffViewManager.DecoratedDifference[] decoratedDifferenceArray = this.manager.getDecorations();
        for (int i = 0; i < decoratedDifferenceArray.length; ++i) {
            int n2 = decoratedDifferenceArray[i].getTopRight();
            int n3 = decoratedDifferenceArray[i].getBottomRight();
            if (n3 <= n && (n3 != -1 || n2 <= n)) continue;
            return Math.max(0, i - 1);
        }
        return decoratedDifferenceArray.length - 1;
    }

    void updateCurrentDifference() {
        if (this.isSetCurrentDifferenceContext) {
            return;
        }
        int n = this.computeCurrentDifference();
        if (n != this.currentDiffIndex) {
            int n2 = this.currentDiffIndex;
            this.currentDiffIndex = n;
            this.support.firePropertyChange("diffCount", n2, this.currentDiffIndex);
        }
    }

    public JToolBar getToolBar() {
        return null;
    }

    private void showCurrentDifference() {
        Difference difference = this.diffs[this.currentDiffIndex];
        this.initGlobalSizes();
        try {
            int n = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getEditorPane().getDocument()), (int)(difference.getFirstStart() > 0 ? difference.getFirstStart() - 1 : 0));
            int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getEditorPane().getDocument()), (int)(difference.getSecondStart() > 0 ? difference.getSecondStart() - 1 : 0));
            this.jEditorPane1.getEditorPane().setCaretPosition(n);
            this.jEditorPane2.getEditorPane().setCaretPosition(n2);
            DiffViewManager.DecoratedDifference decoratedDifference = this.manager.getDecorations()[this.currentDiffIndex];
            int n3 = decoratedDifference.getDiff().getType() == 0 ? this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 2 + 1 : this.jEditorPane2.getScrollPane().getViewport().getViewRect().height / 5;
            this.jEditorPane2.getScrollPane().getVerticalScrollBar().setValue(decoratedDifference.getTopRight() - n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
        }
        this.manager.scroll();
    }

    private void initComponents() {
        this.fileLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel1.setHorizontalAlignment(0);
        this.fileLabel1.setLabelFor(this.jEditorPane1);
        this.filePanel1.setLayout(new BorderLayout());
        this.filePanel1.add((Component)this.fileLabel1, "First");
        this.filePanel1.add(this.jEditorPane1);
        this.fileLabel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileLabel2.setHorizontalAlignment(0);
        this.fileLabel2.setLabelFor(this.jEditorPane2);
        this.filePanel2.setLayout(new BorderLayout());
        this.filePanel2.add((Component)this.fileLabel2, "First");
        this.filePanel2.add(this.jEditorPane2);
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.jSplitPane1.setRightComponent(this.filePanel2);
    }

    private void expandFolds(JEditorPane jEditorPane) {
        final FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jEditorPane);
        FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        foldHierarchy.addFoldHierarchyListener(new FoldHierarchyListener(){

            public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
                FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
            }
        });
    }

    private void expandFolds() {
        this.expandFolds(this.jEditorPane1.getEditorPane());
        this.expandFolds(this.jEditorPane2.getEditorPane());
    }

    private void initGlobalSizes() {
        int n;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getEditorPane().getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getEditorPane().getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n3 = Math.max(n2, n = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n3 < 1) {
            n3 = 1;
        }
        this.totalLines = n3;
        int n4 = this.jEditorPane2.getSize().height;
        int n5 = this.jEditorPane1.getSize().height;
        if (n4 > n5) {
            n5 = n4;
        }
        this.totalHeight = n5;
    }

    public void joinScrollPane(final JScrollPane jScrollPane) {
        this.jEditorPane1.getScrollPane().setVerticalScrollBarPolicy(21);
        this.jEditorPane1.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.jEditorPane2.getScrollPane().setVerticalScrollBarPolicy(21);
        this.jEditorPane2.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.jEditorPane1.getScrollPane().setWheelScrollingEnabled(false);
        this.jEditorPane2.getScrollPane().setWheelScrollingEnabled(false);
        this.jEditorPane1.getScrollPane().addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                jScrollPane.dispatchEvent(mouseWheelEvent);
            }
        });
        this.jEditorPane2.getScrollPane().addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                jScrollPane.dispatchEvent(mouseWheelEvent);
            }
        });
        this.jEditorPane1.getEditorPane().getCaret().setVisible(false);
        this.jEditorPane2.getEditorPane().getCaret().setVisible(false);
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(36, 0), KeyStroke.getKeyStroke(36, 2), KeyStroke.getKeyStroke(36, 2), KeyStroke.getKeyStroke(36, 2), KeyStroke.getKeyStroke(35, 0), KeyStroke.getKeyStroke(35, 2), KeyStroke.getKeyStroke(35, 2), KeyStroke.getKeyStroke(35, 2), KeyStroke.getKeyStroke(35, 0), KeyStroke.getKeyStroke(35, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(39, 0)};
        for (int i = 0; i < keyStrokeArray.length; i += 2) {
            KeyStroke keyStroke = keyStrokeArray[i];
            KeyStroke keyStroke2 = keyStrokeArray[i + 1];
            Object object = this.jEditorPane1.getInputMap().get(keyStroke);
            Object object2 = this.jEditorPane2.getInputMap().get(keyStroke);
            Object object3 = jScrollPane.getInputMap(1).get(keyStroke2);
            if (object3 == null) continue;
            Action action = jScrollPane.getActionMap().get(object3);
            this.jEditorPane1.getActionMap().put(object, new SourceTranslatorAction(action, jScrollPane));
            this.jEditorPane2.getActionMap().put(object2, new SourceTranslatorAction(action, jScrollPane));
        }
    }

    public int getInnerScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.jEditorPane1.getEditorPane().getScrollableUnitIncrement(rectangle, n, n2);
    }

    public int getInnerScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.jEditorPane1.getEditorPane().getScrollableBlockIncrement(rectangle, n, n2);
    }

    public int getInnerWidth() {
        Dimension dimension = this.jEditorPane1.getScrollPane().getViewport().getView().getPreferredSize();
        Dimension dimension2 = this.jEditorPane2.getScrollPane().getViewport().getView().getPreferredSize();
        return Math.max(dimension.width, dimension2.width) * 2;
    }

    public void setInnerWidth(int n) {
        Dimension dimension = this.jEditorPane1.getScrollPane().getViewport().getViewSize();
        dimension.width = n / 2;
        this.jEditorPane1.getScrollPane().getViewport().setViewSize(dimension);
        dimension = this.jEditorPane2.getScrollPane().getViewport().getViewSize();
        dimension.width = n / 2;
        this.jEditorPane2.getScrollPane().getViewport().setViewSize(dimension);
        this.jSplitPane1.setDividerLocation(0.5);
    }

    public void setHorizontalPosition(int n) {
        Point point = this.jEditorPane1.getScrollPane().getViewport().getViewPosition();
        point.x = n /= 2;
        this.jEditorPane1.getScrollPane().getViewport().setViewPosition(point);
        point = this.jEditorPane2.getScrollPane().getViewport().getViewPosition();
        point.x = n;
        this.jEditorPane2.getScrollPane().getViewport().setViewPosition(point);
    }

    public int getChangeY(int n) {
        Difference difference = this.diffs[n];
        int n2 = difference.getFirstStart();
        int n3 = 5;
        if (n2 <= 5) {
            n3 = n2 / 2;
        }
        this.initGlobalSizes();
        int n4 = this.totalHeight * (n2 - n3 - 1) / (this.totalLines + 1);
        return n4 += this.fileLabel1.getHeight();
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jEditorPane1.getScrollPane().getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jEditorPane2.getScrollPane().getHorizontalScrollBar();
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == EditableDiffView.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar2.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar2.getModel().getExtent();
                if (n2 == n4) {
                    EditableDiffView.this.horizontalScroll2ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                EditableDiffView.this.horizontalScroll1ChangedValue = -1;
                jScrollBar2.setValue(EditableDiffView.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                if (n == EditableDiffView.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar2.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar2.getModel().getExtent();
                if (n3 == n5) {
                    EditableDiffView.this.horizontalScroll1ChangedValue = 0;
                } else {
                    EditableDiffView.this.horizontalScroll1ChangedValue = n * (n2 - n4) / (n3 - n5);
                }
                EditableDiffView.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(EditableDiffView.this.horizontalScroll1ChangedValue);
            }
        });
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        try {
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
            try {
                defaultStyledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(defaultStyledDocument);
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane1.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
        this.jEditorPane2.getEditorPane().addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.diffChanged();
                        EditableDiffView.this.initGlobalSizes();
                        EditableDiffView.this.jEditorPane2.onUISettingsChanged();
                        EditableDiffView.this.getComponent().revalidate();
                        EditableDiffView.this.getComponent().repaint();
                    }
                });
            }
        });
    }

    private synchronized void diffChanged() {
        ++this.diffSerial;
    }

    private void setSource1(StreamSource streamSource) throws IOException {
        Document document;
        this.firstSourceAvailable = false;
        EditorKit editorKit = this.jEditorPane1.getEditorPane().getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document2 = this.getSourceDocument(streamSource);
        Document document3 = document = document2 != null ? document2 : editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.getEditorPane().setEditorKit(editorKit);
        }
        if (document2 == null) {
            Reader reader = streamSource.createReader();
            if (reader != null) {
                this.firstSourceAvailable = true;
                try {
                    editorKit.read(reader, document, 0);
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    reader.close();
                }
            }
        } else {
            this.firstSourceAvailable = true;
        }
        this.jEditorPane1.initActions();
        this.jEditorPane1.getEditorPane().setDocument(document);
        this.customizeEditor(this.jEditorPane1.getEditorPane());
    }

    private Document getSourceDocument(StreamSource streamSource) {
        Document document = null;
        FileObject fileObject = (FileObject)streamSource.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    document = editorCookie.openDocument();
                }
            }
            catch (Exception exception) {}
        } else {
            document = (Document)streamSource.getLookup().lookup(Document.class);
        }
        return document;
    }

    private void setSource2(StreamSource streamSource) throws IOException {
        Object object;
        Document document;
        this.secondSourceAvailable = false;
        EditorKit editorKit = this.jEditorPane2.getEditorPane().getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document2 = this.getSourceDocument(streamSource);
        if (document2 != null && streamSource.isEditable() && (document = (DataObject)document2.getProperty("stream")) != null && (object = (EditorCookie)document.getCookie(EditorCookie.class)) instanceof EditorCookie.Observable) {
            this.editableCookie = (EditorCookie.Observable)object;
            this.editableDocument = document2;
            this.editorUndoRedo = this.getUndoRedo((EditorCookie)object);
        }
        Document document3 = document = document2 != null ? document2 : editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.getEditorPane().setEditorKit(editorKit);
        }
        if (document2 == null) {
            object = streamSource.createReader();
            if (object != null) {
                this.secondSourceAvailable = true;
                try {
                    editorKit.read((Reader)object, document, 0);
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException("Can not locate the beginning of the document.");
                }
                finally {
                    ((Reader)object).close();
                }
            }
        } else {
            this.secondSourceAvailable = true;
        }
        this.jEditorPane2.initActions();
        this.jSplitPane1.putClientProperty(UndoRedo.class, this.editorUndoRedo);
        this.jEditorPane2.getEditorPane().setDocument(document);
        this.jEditorPane2.getEditorPane().setEditable(this.editableCookie != null);
        if (document instanceof NbDocument.CustomEditor && (object = ((NbDocument.CustomEditor)document).createEditor((JEditorPane)this.jEditorPane2.getEditorPane())) instanceof JComponent) {
            this.jEditorPane2.setCustomEditor((JComponent)object);
        }
        this.customizeEditor(this.jEditorPane2.getEditorPane());
        this.jViewport2 = this.jEditorPane2.getScrollPane().getViewport();
        this.joinScrollBars();
    }

    private UndoRedo.Manager getUndoRedo(EditorCookie editorCookie) {
        try {
            Method method = CloneableEditorSupport.class.getDeclaredMethod("getUndoRedo", new Class[0]);
            method.setAccessible(true);
            return (UndoRedo.Manager)method.invoke((Object)editorCookie, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditableDiffView.this.refreshEditableDocument();
                }
            });
        }
    }

    public void setSourceTitle(JLabel jLabel, String string) {
        jLabel.setText(string);
        jLabel.setMinimumSize(new Dimension(3, jLabel.getMinimumSize().height));
    }

    public void setDocument1(Document document) {
        if (document != null) {
            this.jEditorPane1.getEditorPane().setDocument(document);
        }
    }

    public void setDocument2(Document document) {
        if (document != null) {
            this.jEditorPane2.getEditorPane().setDocument(document);
        }
    }

    private void refreshDiff(int n) {
        this.refreshDiffTask.schedule(n);
    }

    synchronized int getDiffSerial() {
        return this.diffSerial;
    }

    static Difference getFirstDifference(Difference[] differenceArray, int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            if (n < difference.getFirstStart()) {
                return null;
            }
            if (difference.getType() == 1 && n == difference.getFirstStart()) {
                return difference;
            }
            if (n > difference.getFirstEnd()) continue;
            return difference;
        }
        return null;
    }

    static Difference getSecondDifference(Difference[] differenceArray, int n) {
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            if (n < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && n == difference.getSecondStart()) {
                return difference;
            }
            if (n > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    Color getColorLines() {
        return this.colorLines;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    static /* synthetic */ Difference[] access$1402(EditableDiffView editableDiffView, Difference[] differenceArray) {
        editableDiffView.diffs = differenceArray;
        return differenceArray;
    }

    class DiffSplitPaneUI
    extends BasicSplitPaneUI {
        final DiffSplitPaneDivider divider;

        public DiffSplitPaneUI(JSplitPane jSplitPane) {
            this.splitPane = jSplitPane;
            this.divider = new DiffSplitPaneDivider(this, EditableDiffView.this);
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return this.divider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EditableDiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> list = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", list, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            if (EditableDiffView.this.diffs == null) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> arrayList = new ArrayList<DiffMark>(EditableDiffView.this.diffs.length);
            for (int i = 0; i < EditableDiffView.this.diffs.length; ++i) {
                Difference difference = EditableDiffView.this.diffs[i];
                arrayList.add(new DiffMark(difference, EditableDiffView.this.getColor(difference)));
            }
            return arrayList;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EditableDiffView editableDiffView = EditableDiffView.this;
            synchronized (editableDiffView) {
                this.computeDiff();
                if (EditableDiffView.this.currentDiffIndex >= EditableDiffView.this.diffs.length) {
                    EditableDiffView.this.updateCurrentDifference();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditableDiffView.this.jEditorPane1.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.jEditorPane2.setCurrentDiff(EditableDiffView.this.diffs);
                        EditableDiffView.this.jSplitPane1.repaint();
                        EditableDiffView.this.diffMarkprovider.refresh();
                    }
                });
            }
        }

        private void computeDiff() {
            if (!EditableDiffView.this.secondSourceAvailable || !EditableDiffView.this.firstSourceAvailable) {
                EditableDiffView.access$1402(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
                return;
            }
            StringReader stringReader = null;
            StringReader stringReader2 = null;
            try {
                stringReader = new StringReader(EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane1.getEditorPane().getDocument().getLength()));
                stringReader2 = new StringReader(EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getText(0, EditableDiffView.this.jEditorPane2.getEditorPane().getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diffProvider == null) {
                EditableDiffView.access$1402(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
                return;
            }
            boolean bl = false;
            if (diffProvider instanceof BuiltInDiffProvider) {
                bl = ((BuiltInDiffProvider)diffProvider).isTrimLines();
                ((BuiltInDiffProvider)diffProvider).setTrimLines(false);
            }
            try {
                EditableDiffView.access$1402(EditableDiffView.this, diffProvider.computeDiff(stringReader, stringReader2));
                EditableDiffView.this.diffChanged();
            }
            catch (IOException iOException) {
                EditableDiffView.access$1402(EditableDiffView.this, EditableDiffView.this.NO_DIFFERENCES);
            }
            if (diffProvider instanceof BuiltInDiffProvider) {
                ((BuiltInDiffProvider)diffProvider).setTrimLines(bl);
            }
        }
    }
}

