/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class Abbrev
implements SettingsChangeListener,
PropertyChangeListener {
    private StringBuffer abbrevSB = new StringBuffer();
    private boolean checkDocText;
    private boolean checkTextDelimiter;
    protected EditorUI editorUI;
    private Acceptor doExpandAcceptor;
    private Acceptor addTypedAcceptor;
    private Acceptor resetAcceptor;
    private HashMap abbrevMap;

    public static boolean isAbbrevDisabled(JTextComponent jTextComponent) {
        BaseDocument baseDocument;
        SyntaxSupport syntaxSupport;
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument && (syntaxSupport = (baseDocument = (BaseDocument)document).getSyntaxSupport()) != null) {
            return syntaxSupport.isAbbrevDisabled(jTextComponent.getCaretPosition());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abbrev(EditorUI editorUI, boolean bl, boolean bl2) {
        this.editorUI = editorUI;
        this.checkDocText = bl;
        this.checkTextDelimiter = bl2;
        Settings.addSettingsChangeListener(this);
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, jTextComponent));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.editorUI.getComponent());
        if (clazz != null) {
            String string;
            String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
            if (string == null || "abbrev-action-map".equals(string) || "abbrev-map".equals(string)) {
                this.abbrevMap = new HashMap();
                Map map = (Map)Settings.getValue(clazz, "abbrev-action-map");
                if (map != null) {
                    BaseKit baseKit = Utilities.getKit(this.editorUI.getComponent());
                    for (Map.Entry entry2 : map.entrySet()) {
                        Object v = entry2.getValue();
                        Action action = null;
                        if (v instanceof String) {
                            action = baseKit.getActionByName((String)v);
                        } else if (v instanceof Action) {
                            action = (Action)v;
                        }
                        if (action == null) continue;
                        this.abbrevMap.put(entry2.getKey(), action);
                    }
                }
                if ((map = (Map)Settings.getValue(clazz, "abbrev-map")) != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        Map.Entry entry2;
                        entry2 = entry.getValue();
                        if (entry2 == null) continue;
                        this.abbrevMap.put(entry.getKey(), entry2);
                    }
                }
            }
            if (string == null || "abbrev-expand-acceptor".equals(string)) {
                this.doExpandAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-expand-acceptor", AcceptorFactory.FALSE);
            }
            if (string == null || "abbrev-add-typed-char-acceptor".equals(string)) {
                this.addTypedAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-add-typed-char-acceptor", AcceptorFactory.FALSE);
            }
            if (string == null || "abbrev-reset-acceptor".equals(string)) {
                this.resetAcceptor = SettingsUtil.getAcceptor(clazz, "abbrev-reset-acceptor", AcceptorFactory.TRUE);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && (jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue()) != null) {
            this.settingsChange(null);
        }
    }

    public void reset() {
        this.abbrevSB.setLength(0);
    }

    public void addChar(char c) {
        this.abbrevSB.append(c);
    }

    public String getAbbrevString() {
        return this.abbrevSB.toString();
    }

    public Map getAbbrevMap() {
        return this.abbrevMap;
    }

    public Object translateAbbrev(String string) {
        String string2 = string != null ? string : this.abbrevSB.toString();
        return this.getAbbrevMap().get(string2);
    }

    public String getExpandString(char c) {
        return this.doExpandAcceptor.accept(c) ? this.getExpandString() : null;
    }

    public String getExpandString() {
        BaseDocument baseDocument = this.editorUI.getDocument();
        String string = this.getAbbrevString();
        int n = string.length();
        Object object = this.translateAbbrev(string);
        Caret caret = this.editorUI.getComponent().getCaret();
        int n2 = caret.getDot();
        if (string != null && object != null && n2 >= n && this.checkDocText) {
            try {
                CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)(n2 - n), (int)n);
                if (CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)string) && (!this.checkTextDelimiter || n2 == n || this.resetAcceptor.accept(baseDocument.getChars(n2 - n - 1, 1)[0]))) {
                    return string;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean doExpansion(int n, String string, ActionEvent actionEvent) throws BadLocationException {
        Object object = this.translateAbbrev(string);
        boolean bl = false;
        if (object instanceof String) {
            Object object2;
            BaseDocument baseDocument = this.editorUI.getDocument();
            String string2 = (String)object;
            int n2 = string2.indexOf(124);
            if (n2 >= 0) {
                if (n2 > 0) {
                    baseDocument.insertString(n, string2.substring(0, n2), null);
                }
                if (n2 + 1 < string2.length()) {
                    baseDocument.insertString(n + n2, string2.substring(n2 + 1), null);
                }
                object2 = this.editorUI.getComponent().getCaret();
                object2.setDot(n + n2);
            } else {
                baseDocument.insertString(n, string2, null);
            }
            if (string2.indexOf("\n") != -1) {
                object2 = baseDocument.getFormatter();
                ((Formatter)object2).reformat(baseDocument, n, n + string2.length());
            }
            bl = true;
        } else if (object instanceof Action) {
            ((Action)object).actionPerformed(actionEvent);
            bl = true;
        }
        return bl;
    }

    public boolean expandString(char c, String string, ActionEvent actionEvent) throws BadLocationException {
        if (this.expandString(string, actionEvent)) {
            if (this.addTypedAcceptor.accept(c)) {
                int n = this.editorUI.getComponent().getCaret().getDot();
                this.editorUI.getDocument().insertString(n, String.valueOf(c), null);
            }
            return true;
        }
        return false;
    }

    public boolean expandString(String string, ActionEvent actionEvent) throws BadLocationException {
        this.reset();
        return true;
    }

    public boolean checkReset(char c) {
        if (this.resetAcceptor.accept(c)) {
            this.reset();
            return true;
        }
        return false;
    }

    public boolean checkAndExpand(char c, ActionEvent actionEvent) throws BadLocationException {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        JTextComponent jTextComponent = this.editorUI.getComponent();
        Document document = jTextComponent.getDocument();
        if (document instanceof BaseDocument) {
            object = (BaseDocument)document;
            SyntaxSupport syntaxSupport = ((BaseDocument)object).getSyntaxSupport();
            bl2 = syntaxSupport.isAbbrevDisabled(jTextComponent.getCaretPosition());
        }
        if (bl2) {
            this.reset();
        } else {
            object = this.getExpandString(c);
            if (object != null) {
                bl = false;
                this.expandString(c, (String)object, actionEvent);
            } else {
                this.addChar(c);
            }
            this.checkReset(c);
        }
        return bl;
    }

    public void checkAndExpand(ActionEvent actionEvent) throws BadLocationException {
        String string = this.getExpandString();
        if (string != null) {
            this.expandString(string, actionEvent);
        }
    }
}

