/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LineSeparatorConversion;

public class Analyzer {
    private static Object platformLS;
    public static final char[] EMPTY_CHAR_ARRAY;
    private static char[] spacesBuffer;
    private static char[] tabsBuffer;
    private static final int MAX_CACHED_SPACES_STRING_LENGTH = 50;
    private static final String[] spacesStrings;

    private Analyzer() {
    }

    public static Object getPlatformLS() {
        if (platformLS == null) {
            platformLS = System.getProperty("line.separator");
        }
        return platformLS;
    }

    public static String testLS(char[] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\r': {
                    if (i + 1 < n && cArray[i + 1] == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                case '\n': {
                    return "\n";
                }
            }
        }
        return null;
    }

    public static int convertLSToLF(char[] cArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '\r') {
                n4 = i + 1 < n && cArray[i + 1] == '\n' ? 2 : 1;
            }
            if (n4 <= 0) continue;
            n2 = i - n5;
            if (n2 > 0) {
                if (n3 != n5) {
                    System.arraycopy(cArray, n5, cArray, n3, n2);
                }
                n3 += n2;
            }
            cArray[n3++] = 10;
            n5 += n2 + n4;
            i += n4 - 1;
            n4 = 0;
        }
        n2 = n - n5;
        if (n2 > 0) {
            if (n3 != n5) {
                System.arraycopy(cArray, n5, cArray, n3, n2);
            }
            n3 += n2;
        }
        return n3;
    }

    public static String convertLSToLF(String string) {
        int n;
        char[] cArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            if (string.charAt(i) == '\r') {
                n3 = i + 1 < n5 && string.charAt(i + 1) == '\n' ? 2 : 1;
            }
            if (n3 <= 0) continue;
            if (cArray == null) {
                cArray = new char[n5];
                string.getChars(0, n5, cArray, 0);
            }
            if ((n = i - n4) > 0) {
                if (n2 != n4) {
                    string.getChars(n4, n4 + n, cArray, n2);
                }
                n2 += n;
            }
            cArray[n2++] = 10;
            n4 += n + n3;
            i += n3 - 1;
            n3 = 0;
        }
        n = n5 - n4;
        if (n > 0) {
            if (n2 != n4) {
                string.getChars(n4, n4 + n, cArray, n2);
            }
            n2 += n;
        }
        return cArray == null ? string : new String(cArray, 0, n2);
    }

    public static boolean isSpace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] != ' ') {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean isWhitespace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (!Character.isWhitespace(cArray[n])) {
                return false;
            }
            ++n;
            --n2;
        }
        return true;
    }

    public static int findFirstNonTab(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n] != '\t') {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findFirstNonSpace(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n] != ' ') {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findFirstNonWhite(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (!Character.isWhitespace(cArray[n])) {
                return n;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int findLastNonWhite(char[] cArray, int n, int n2) {
        for (int i = n + n2 - 1; i >= n; --i) {
            if (Character.isWhitespace(cArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getLFCount(char[] cArray) {
        return Analyzer.getLFCount(cArray, 0, cArray.length);
    }

    public static int getLFCount(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            if (cArray[n++] == '\n') {
                ++n3;
            }
            --n2;
        }
        return n3;
    }

    public static int getLFCount(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public static int findFirstLFOffset(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] == '\n') {
                return n - 1;
            }
            --n2;
        }
        return -1;
    }

    public static int findFirstLFOffset(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            return i;
        }
        return -1;
    }

    public static int findFirstTab(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            if (cArray[n++] == '\t') {
                return n - 1;
            }
            --n2;
        }
        return -1;
    }

    public static int findFirstTabOrLF(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            switch (cArray[n++]) {
                case '\t': 
                case '\n': {
                    return n - 1;
                }
            }
            --n2;
        }
        return -1;
    }

    public static void reverse(char[] cArray, int n) {
        for (int i = --n - 1 >> 1; i >= 0; --i) {
            char c = cArray[i];
            cArray[i] = cArray[n - i];
            cArray[n - i] = c;
        }
    }

    public static boolean equals(String string, char[] cArray) {
        return Analyzer.equals(string, cArray, 0, cArray.length);
    }

    public static boolean equals(String string, char[] cArray, int n, int n2) {
        if (string.length() != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == cArray[n + i]) continue;
            return false;
        }
        return true;
    }

    public static void initialRead(BaseDocument baseDocument, Reader reader, boolean bl) throws IOException {
        if (baseDocument.getLength() > 0) {
            return;
        }
        if (reader != null) {
            int n = (Integer)baseDocument.getProperty("read-buffer-size");
            if (bl) {
                reader = new LineSeparatorConversion.InitialSeparatorReader(reader);
            }
            LineSeparatorConversion.ToLineFeed toLineFeed = new LineSeparatorConversion.ToLineFeed(reader, n);
            boolean bl2 = true;
            int n2 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            Segment segment = toLineFeed.nextConverted();
            while (segment != null) {
                try {
                    baseDocument.insertString(n2, new String(segment.array, segment.offset, segment.count), null);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalStateException(badLocationException.toString());
                }
                n2 += segment.count;
                segment = toLineFeed.nextConverted();
            }
            if (bl) {
                baseDocument.putProperty("__EndOfLine__", ((LineSeparatorConversion.InitialSeparatorReader)reader).getInitialSeparator());
            }
        }
    }

    static void read(BaseDocument baseDocument, Reader reader, int n) throws BadLocationException, IOException {
        int n2 = (Integer)baseDocument.getProperty("read-buffer-size");
        LineSeparatorConversion.ToLineFeed toLineFeed = new LineSeparatorConversion.ToLineFeed(reader, n2);
        Segment segment = toLineFeed.nextConverted();
        while (segment != null) {
            baseDocument.insertString(n, new String(segment.array, segment.offset, segment.count), null);
            n += segment.count;
            segment = toLineFeed.nextConverted();
        }
    }

    static void write(BaseDocument baseDocument, Writer writer, int n, int n2) throws BadLocationException, IOException {
        String string = (String)baseDocument.getProperty("write-line-separator");
        if (string == null && (string = (String)baseDocument.getProperty("__EndOfLine__")) == null) {
            string = "\n";
        }
        int n3 = (Integer)baseDocument.getProperty("write-buffer-size");
        char[] cArray = new char[n3];
        char[] cArray2 = new char[2 * n3];
        int n4 = 0;
        while (n2 > 0) {
            n4 = Math.min(n2, n3);
            baseDocument.getChars(n, cArray, 0, n4);
            int n5 = Analyzer.convertLFToLS(cArray, n4, cArray2, string);
            writer.write(cArray2, 0, n5);
            n += n4;
            n2 -= n4;
        }
    }

    public static int getColumn(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = n + n2;
        if (n3 <= 0) {
            new Exception("Wrong tab size=" + n3).printStackTrace();
            n3 = 8;
        }
        block3: while (n < n6) {
            switch (cArray[n++]) {
                case '\t': {
                    n5 = (n5 + n3) / n3 * n3;
                    continue block3;
                }
            }
            ++n5;
        }
        return n5;
    }

    public static synchronized char[] getSpacesBuffer(int n) {
        while (n > spacesBuffer.length) {
            char[] cArray = new char[spacesBuffer.length * 2];
            System.arraycopy(spacesBuffer, 0, cArray, 0, spacesBuffer.length);
            System.arraycopy(spacesBuffer, 0, cArray, spacesBuffer.length, spacesBuffer.length);
            spacesBuffer = cArray;
        }
        return spacesBuffer;
    }

    public static synchronized String getSpacesString(int n) {
        if (n <= 50) {
            String string = spacesStrings[n];
            if (string == null) {
                Analyzer.spacesStrings[n] = string = spacesStrings[50].substring(0, n);
            }
            return string;
        }
        return new String(Analyzer.getSpacesBuffer(n), 0, n);
    }

    public static char[] createSpacesBuffer(int n) {
        char[] cArray = new char[n];
        System.arraycopy(Analyzer.getSpacesBuffer(n), 0, cArray, 0, n);
        return cArray;
    }

    public static char[] getTabsBuffer(int n) {
        if (n > tabsBuffer.length) {
            char[] cArray = new char[n * 2];
            for (int i = 0; i < cArray.length; i += tabsBuffer.length) {
                System.arraycopy(tabsBuffer, 0, cArray, i, Math.min(tabsBuffer.length, cArray.length - i));
            }
            tabsBuffer = cArray;
        }
        return tabsBuffer;
    }

    public static String getIndentString(int n, boolean bl, int n2) {
        return Analyzer.getWhitespaceString(0, n, bl, n2);
    }

    public static String getWhitespaceString(int n, int n2, boolean bl, int n3) {
        return bl || n3 <= 0 ? Analyzer.getSpacesString(n2 - n) : new String(Analyzer.createWhiteSpaceFillBuffer(n, n2, n3));
    }

    public static char[] createWhiteSpaceFillBuffer(int n, int n2, int n3) {
        return Analyzer.createWhitespaceFillBuffer(n, n2, n3);
    }

    public static char[] createWhitespaceFillBuffer(int n, int n2, int n3) {
        if (n >= n2) {
            return EMPTY_CHAR_ARRAY;
        }
        if (n3 <= 0) {
            new Exception("Wrong tab size=" + n3).printStackTrace();
            n3 = 8;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = (n + n3) / n3 * n3;
        if (n6 > n2) {
            n5 += n2 - n;
        } else {
            ++n4;
            int n7 = n2 - n2 / n3 * n3;
            n4 += (n2 - n7 - n6) / n3;
            n5 += n7;
        }
        char[] cArray = new char[n4 + n5];
        if (n4 > 0) {
            System.arraycopy(Analyzer.getTabsBuffer(n4), 0, cArray, 0, n4);
        }
        if (n5 > 0) {
            System.arraycopy(Analyzer.getSpacesBuffer(n5), 0, cArray, n4, n5);
        }
        return cArray;
    }

    public static char[] loadFile(String string) throws IOException {
        File file = new File(string);
        char[] cArray = new char[(int)file.length()];
        FileReader fileReader = new FileReader(file);
        fileReader.read(cArray);
        fileReader.close();
        int n = Analyzer.convertLSToLF(cArray, cArray.length);
        if (n != cArray.length) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            cArray = cArray2;
        }
        return cArray;
    }

    public static int convertLFToLS(char[] cArray, int n, char[] cArray2, String string) {
        if (string.equals("\r")) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
            if (string == "\r") {
                char[] cArray3 = cArray2;
                for (int i = 0; i < n; ++i) {
                    if (cArray3[i] != '\n') continue;
                    cArray3[i] = 13;
                }
            }
            return n;
        }
        if (string.equals("\r\n")) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (cArray[i] != '\n') continue;
                n2 = i - n4;
                if (n2 > 0) {
                    System.arraycopy(cArray, n4, cArray2, n3, n2);
                    n3 += n2;
                }
                cArray2[n3++] = 13;
                cArray2[n3++] = 10;
                n4 = i + 1;
            }
            n2 = n - n4;
            if (n2 > 0) {
                System.arraycopy(cArray, n4, cArray2, n3, n2);
                n3 += n2;
            }
            return n3;
        }
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return n;
    }

    public static boolean startsWith(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length < cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length < cArray2.length) {
            return false;
        }
        for (int i = cArray.length - cArray2.length; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static char[] concat(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return cArray2;
        }
        if (cArray2 == null || cArray2.length == 0) {
            return cArray;
        }
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static char[] extract(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static boolean blocksHit(int[] nArray, int n, int n2) {
        return Analyzer.blocksIndex(nArray, n, n2) >= 0;
    }

    public static int blocksIndex(int[] nArray, int n, int n2) {
        if (nArray.length > 0) {
            int n3 = -2;
            int n4 = 0;
            int n5 = nArray.length - 2;
            while (n4 <= n5) {
                int n6 = (n4 + n5) / 2 & n3;
                if (nArray[n6 + 1] <= n) {
                    n4 = n6 + 2;
                    continue;
                }
                if (nArray[n6] >= n2) {
                    n5 = n6 - 2;
                    continue;
                }
                return n4;
            }
        }
        return -1;
    }

    public static String removeSpaces(String string) {
        int n = string.indexOf(32);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            int n2 = string.length();
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (c == ' ') continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    static {
        EMPTY_CHAR_ARRAY = new char[0];
        spacesBuffer = new char[]{' '};
        tabsBuffer = new char[]{'\t'};
        spacesStrings = new String[51];
        Analyzer.spacesStrings[0] = "";
        Analyzer.spacesStrings[50] = new String(Analyzer.getSpacesBuffer(50), 0, 50);
    }
}

