/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocumentContent;
import org.netbeans.editor.FixLineSyntaxState;

public class BaseDocumentEvent
extends AbstractDocument.DefaultDocumentEvent {
    private static final boolean debugUndo = Boolean.getBoolean("netbeans.debug.editor.document.undo");
    private DocumentContent.Edit modifyUndoEdit;
    private FixLineSyntaxState fixLineSyntaxState;
    private UndoableEdit previous;
    private boolean inUndo;
    private boolean inRedo;
    private boolean hasBeenDone2;
    private boolean alive2;
    private boolean inProgress2;
    private Hashtable changeLookup2;
    private int lfCount;
    static final long serialVersionUID = -7624299835780414963L;

    public BaseDocumentEvent(BaseDocument baseDocument, int n, int n2, DocumentEvent.EventType eventType) {
        BaseDocument baseDocument2 = baseDocument;
        baseDocument2.getClass();
        super(baseDocument2, n, n2, eventType);
        this.lfCount = -1;
        this.hasBeenDone2 = true;
        this.alive2 = true;
        this.inProgress2 = true;
    }

    protected UndoableEdit findEdit(Class clazz) {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            Object e = this.edits.get(i);
            if (!clazz.isInstance(e)) continue;
            return (UndoableEdit)e;
        }
        return null;
    }

    private DocumentContent.Edit getModifyUndoEdit() {
        if (this.getType() == DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Cannot be called for CHANGE events.");
        }
        if (this.modifyUndoEdit == null) {
            this.modifyUndoEdit = (DocumentContent.Edit)this.findEdit(DocumentContent.Edit.class);
        }
        return this.modifyUndoEdit;
    }

    private FixLineSyntaxState getFixLineSyntaxState() {
        if (this.getType() == DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Cannot be called for CHANGE events.");
        }
        if (this.fixLineSyntaxState == null) {
            this.fixLineSyntaxState = ((FixLineSyntaxState.BeforeLineUndo)this.findEdit(FixLineSyntaxState.BeforeLineUndo.class)).getMaster();
        }
        return this.fixLineSyntaxState;
    }

    public char[] getChars() {
        String string = this.getText();
        return string != null ? string.toCharArray() : null;
    }

    public String getText() {
        return this.getModifyUndoEdit() != null ? this.getModifyUndoEdit().getUndoRedoText() : null;
    }

    public int getLine() {
        Element element = ((BaseDocument)this.getDocument()).getParagraphElement(0).getParentElement();
        int n = element.getElementIndex(this.getOffset());
        return n;
    }

    public int getLFCount() {
        if (this.getType() == DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Not available for CHANGE events");
        }
        if (this.lfCount == -1) {
            String string = this.getText();
            int n = 0;
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) != '\n') continue;
                ++n;
            }
            this.lfCount = n;
        }
        return this.lfCount;
    }

    public int getSyntaxUpdateOffset() {
        if (this.getType() == DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Not available for CHANGE events");
        }
        return this.getFixLineSyntaxState().getSyntaxUpdateOffset();
    }

    List getSyntaxUpdateTokenList() {
        return this.getFixLineSyntaxState().getSyntaxUpdateTokenList();
    }

    public String getDrawLayerName() {
        if (this.getType() != DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Can be called for CHANGE events only.");
        }
        DrawLayerChange drawLayerChange = (DrawLayerChange)this.findEdit(DrawLayerChange.class);
        return drawLayerChange != null ? drawLayerChange.getDrawLayerName() : null;
    }

    public int getDrawLayerVisibility() {
        if (this.getType() != DocumentEvent.EventType.CHANGE) {
            throw new IllegalStateException("Can be called for CHANGE events only.");
        }
        DrawLayerChange drawLayerChange = (DrawLayerChange)this.findEdit(DrawLayerChange.class);
        return drawLayerChange != null ? drawLayerChange.getDrawLayerVisibility() : -1;
    }

    public boolean isInUndo() {
        return this.inUndo;
    }

    public boolean isInRedo() {
        return this.inRedo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() throws CannotUndoException {
        boolean bl;
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        this.inUndo = true;
        try {
            bl = baseDocument.notifyModifyCheckStart(0, "undo() vetoed");
        }
        catch (BadLocationException badLocationException) {
            throw new CannotUndoException();
        }
        boolean bl2 = false;
        baseDocument.extWriteLock();
        try {
            int n;
            if (!this.canUndo()) {
                throw new CannotUndoException();
            }
            this.hasBeenDone2 = false;
            baseDocument.lastModifyUndoEdit = null;
            if (debugUndo) {
                System.err.println("UNDO in doc=" + baseDocument);
            }
            if ((n = this.edits.size()) > 0) {
                baseDocument.markModsUndoneOrRedone();
            }
            while (n-- > 0) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n);
                undoableEdit.undo();
            }
            if (this.getType() == DocumentEvent.EventType.REMOVE) {
                baseDocument.fireInsertUpdate(this);
            } else if (this.getType() == DocumentEvent.EventType.INSERT) {
                baseDocument.fireRemoveUpdate(this);
            } else {
                baseDocument.fireChangedUpdate(this);
            }
        }
        finally {
            baseDocument.extWriteUnlock();
            if (bl) {
                baseDocument.notifyModifyCheckEnd(bl2);
            }
        }
        if (this.previous != null) {
            this.previous.undo();
        }
        this.inUndo = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws CannotRedoException {
        boolean bl;
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        try {
            bl = baseDocument.notifyModifyCheckStart(0, "redo() vetoed");
        }
        catch (BadLocationException badLocationException) {
            throw new CannotRedoException();
        }
        this.inRedo = true;
        if (this.previous != null) {
            this.previous.redo();
        }
        boolean bl2 = false;
        baseDocument.extWriteLock();
        try {
            Enumeration enumeration;
            if (!this.canRedo()) {
                throw new CannotRedoException();
            }
            this.hasBeenDone2 = true;
            if (debugUndo) {
                System.err.println("REDO in doc=" + baseDocument);
            }
            if ((enumeration = this.edits.elements()).hasMoreElements()) {
                baseDocument.markModsUndoneOrRedone();
            }
            while (enumeration.hasMoreElements()) {
                ((UndoableEdit)enumeration.nextElement()).redo();
            }
            if (this.getType() == DocumentEvent.EventType.INSERT) {
                baseDocument.fireInsertUpdate(this);
            } else if (this.getType() == DocumentEvent.EventType.REMOVE) {
                baseDocument.fireRemoveUpdate(this);
            } else {
                baseDocument.fireChangedUpdate(this);
            }
        }
        finally {
            baseDocument.extWriteUnlock();
            if (bl) {
                baseDocument.notifyModifyCheckEnd(bl2);
            }
        }
        this.inRedo = false;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.changeLookup2 == null && this.edits.size() > 10) {
            this.changeLookup2 = new Hashtable();
            int n = this.edits.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.edits.elementAt(i);
                if (!(e instanceof DocumentEvent.ElementChange)) continue;
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)e;
                this.changeLookup2.put(elementChange.getElement(), elementChange);
            }
        }
        if (this.changeLookup2 != null && undoableEdit instanceof DocumentEvent.ElementChange) {
            DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
            this.changeLookup2.put(elementChange.getElement(), elementChange);
        }
        if (!this.inProgress2) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }

    private boolean isLastModifyUndoEdit() {
        return true;
    }

    public boolean canUndo() {
        return !this.inProgress2 && this.alive2 && this.hasBeenDone2 && this.isLastModifyUndoEdit();
    }

    public boolean canRedo() {
        return !this.inProgress2 && this.alive2 && !this.hasBeenDone2;
    }

    public boolean isInProgress() {
        return this.inProgress2;
    }

    public String getUndoPresentationName() {
        return "";
    }

    public String getRedoPresentationName() {
        return "";
    }

    public boolean canMerge(BaseDocumentEvent baseDocumentEvent) {
        if (this.getType() == DocumentEvent.EventType.INSERT) {
            if (baseDocumentEvent.getType() == DocumentEvent.EventType.INSERT) {
                String string = this.getText();
                String string2 = baseDocumentEvent.getText();
                if ((this.getLength() == 1 || this.getLength() > 1 && Analyzer.isSpace(string)) && (baseDocumentEvent.getLength() == 1 || baseDocumentEvent.getLength() > 1 && Analyzer.isSpace(string2)) && baseDocumentEvent.getOffset() + baseDocumentEvent.getLength() == this.getOffset()) {
                    BaseDocument baseDocument = (BaseDocument)this.getDocument();
                    boolean bl = baseDocument.isIdentifierPart(string.charAt(0));
                    boolean bl2 = baseDocument.isIdentifierPart(string2.charAt(0));
                    if (bl && bl2) {
                        return true;
                    }
                    boolean bl3 = baseDocument.isWhitespace(string.charAt(0));
                    boolean bl4 = baseDocument.isWhitespace(string2.charAt(0));
                    if (bl4 && bl3 || !bl4 && !bl2 && !bl3 && !bl) {
                        return true;
                    }
                }
            }
        } else if (baseDocumentEvent.getType() == DocumentEvent.EventType.INSERT) {
            // empty if block
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        if (undoableEdit instanceof BaseDocument.AtomicCompoundEdit) {
            UndoableEdit undoableEdit2;
            BaseDocument.AtomicCompoundEdit atomicCompoundEdit = (BaseDocument.AtomicCompoundEdit)undoableEdit;
            if (!baseDocument.undoMergeReset && atomicCompoundEdit.getEdits().size() == 1 && (undoableEdit2 = (UndoableEdit)atomicCompoundEdit.getEdits().get(0)) instanceof BaseDocumentEvent && this.canMerge((BaseDocumentEvent)undoableEdit2)) {
                this.previous = undoableEdit;
                return true;
            }
        } else if (undoableEdit instanceof BaseDocumentEvent) {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)undoableEdit;
            if (!baseDocument.undoMergeReset && this.canMerge(baseDocumentEvent)) {
                this.previous = undoableEdit;
                return true;
            }
        }
        baseDocument.undoMergeReset = false;
        return false;
    }

    public void die() {
        int n = this.edits.size();
        for (int i = n - 1; i >= 0; --i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
            undoableEdit.die();
        }
        this.alive2 = false;
        if (this.previous != null) {
            this.previous.die();
            this.previous = null;
        }
    }

    public void end() {
        this.inProgress2 = false;
    }

    public DocumentEvent.ElementChange getChange(Element element) {
        if (this.changeLookup2 != null) {
            return (DocumentEvent.ElementChange)this.changeLookup2.get(element);
        }
        int n = this.edits.size();
        for (int i = 0; i < n; ++i) {
            DocumentEvent.ElementChange elementChange;
            Object e = this.edits.elementAt(i);
            if (!(e instanceof DocumentEvent.ElementChange) || (elementChange = (DocumentEvent.ElementChange)e).getElement() != element) continue;
            return elementChange;
        }
        return null;
    }

    public String toString() {
        return System.identityHashCode(this) + " " + super.toString() + ", type=" + this.getType() + (this.getType() != DocumentEvent.EventType.CHANGE ? "text='" + this.getText() + "'" : "");
    }

    static class DrawLayerChange
    extends AbstractUndoableEdit {
        String drawLayerName;
        int drawLayerVisibility;

        DrawLayerChange(String string, int n) {
            this.drawLayerName = string;
            this.drawLayerVisibility = n;
        }

        public String getDrawLayerName() {
            return this.drawLayerName;
        }

        public int getDrawLayerVisibility() {
            return this.drawLayerVisibility;
        }
    }
}

