/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineFakeDocView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldingToolTip;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.editor.view.spi.LockView;

class CollapsedView
extends View
implements SettingsChangeListener {
    private Position startPos;
    private Position endPos;
    private String foldDescription;
    private Font font;
    private Color foreColor;
    private Color backColor;

    public CollapsedView(Element element, Position position, Position position2, String string) {
        super(element);
        this.startPos = position;
        this.endPos = position2;
        this.foldDescription = string;
        Settings.addSettingsChangeListener(this);
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.getContainer();
    }

    private BaseTextUI getBaseTextUI() {
        JTextComponent jTextComponent = this.getComponent();
        return jTextComponent != null ? (BaseTextUI)jTextComponent.getUI() : null;
    }

    private EditorUI getEditorUI() {
        BaseTextUI baseTextUI = this.getBaseTextUI();
        return baseTextUI != null ? baseTextUI.getEditorUI() : null;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public Document getDocument() {
        View view = this.getParent();
        return view == null ? null : view.getDocument();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 1: {
                return this.getEditorUI().getLineHeight();
            }
            case 0: {
                return this.getCollapsedFoldStringWidth();
            }
        }
        return 1.0f;
    }

    private int getCollapsedFoldStringWidth() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return 0;
        }
        FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(this.getColoringFont(), jTextComponent);
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.stringWidth(this.foldDescription);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return new Rectangle(shape.getBounds().x, shape.getBounds().y, this.getCollapsedFoldStringWidth(), this.getEditorUI().getLineHeight());
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return this.getStartOffset();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        graphics.setColor(this.getBackColor());
        int n = rectangle.x + 2;
        int n2 = rectangle.y;
        int n3 = rectangle.width - 1;
        int n4 = rectangle.height - 1;
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getForeColor());
        graphics.setFont(this.getColoringFont());
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawString(this.foldDescription, n, n2 + this.getEditorUI().getLineAscent() - 1);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        biasArray[0] = Position.Bias.Forward;
        switch (n2) {
            case 1: 
            case 5: {
                Rectangle rectangle;
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Caret caret = jTextComponent != null ? jTextComponent.getCaret() : null;
                Point point = caret != null ? caret.getMagicCaretPosition() : null;
                int n3 = point == null ? ((rectangle = jTextComponent.modelToView(n)) == null ? 0 : rectangle.x) : point.x;
                if (n2 == 1) {
                    n = Utilities.getPositionAbove(jTextComponent, n, n3);
                    break;
                }
                n = Utilities.getPositionBelow(jTextComponent, n, n3);
                break;
            }
            case 7: {
                if (n == -1) {
                    n = Math.max(0, this.getStartOffset());
                    break;
                }
                if (bias == Position.Bias.Backward) {
                    n = Math.max(0, this.getStartOffset());
                    break;
                }
                n = Math.max(0, this.getStartOffset() - 1);
                break;
            }
            case 3: {
                if (n == -1) {
                    n = this.getStartOffset();
                    break;
                }
                n = Math.min(this.getEndOffset(), this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }

    private View getExpandedView() {
        Element element = this.getElement().getParentElement();
        int n = element.getElementIndex(this.getStartOffset());
        int n2 = element.getElement(n).getStartOffset();
        int n3 = element.getElementIndex(this.getEndOffset());
        int n4 = element.getElement(n3).getEndOffset();
        LockView lockView = new LockView(new DrawEngineFakeDocView(element, n2, n4, false));
        RootView rootView = new RootView();
        rootView.setView(lockView);
        return lockView;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        ToolTipSupport toolTipSupport = ((ExtEditorUI)this.getEditorUI()).getToolTipSupport();
        FoldingToolTip foldingToolTip = new FoldingToolTip(this.getExpandedView(), this.getEditorUI());
        toolTipSupport.setToolTip(foldingToolTip, PopupManager.ScrollBarBounds, PopupManager.Largest, -2, 0);
        return "";
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent == null || Utilities.getKitClass(this.getComponent()) != settingsChangeEvent.getKitClass()) {
            return;
        }
        String string = "default-coloring";
        String string2 = "code-folding-coloring";
        EditorUI editorUI = this.getEditorUI();
        if (editorUI == null) {
            return;
        }
        Coloring coloring = editorUI.getColoring("code-folding");
        Coloring coloring2 = editorUI.getDefaultColoring();
        Font font = null;
        Color color = null;
        Color color2 = null;
        if (coloring != null) {
            font = coloring.getFont();
            color = coloring.getForeColor();
            color2 = coloring.getBackColor();
        }
        if (string.equals(settingsChangeEvent.getSettingName())) {
            Serializable serializable;
            if (color == null && !((Color)(serializable = this.getDefaultForeColor())).equals(this.foreColor)) {
                this.foreColor = serializable;
            }
            if (color2 == null && !((Color)(serializable = this.getDefaultBackColor())).equals(this.backColor)) {
                this.backColor = serializable;
            }
            if (!((Font)(serializable = this.getDefaultColoringFont())).equals(this.font) && font == null) {
                this.font = serializable;
            }
        } else if (string2.equals(settingsChangeEvent.getSettingName())) {
            if (coloring == null) {
                return;
            }
            Color color3 = coloring.getForeColor();
            this.foreColor = color3 != null ? color3 : this.getDefaultForeColor();
            color3 = coloring.getBackColor();
            Color color4 = this.backColor = color3 != null ? color3 : this.getDefaultBackColor();
            if (font == null) {
                Font font2 = this.getDefaultColoringFont();
                if (!font2.equals(this.font)) {
                    this.font = font2;
                }
            } else if (!font.equals(this.font)) {
                this.font = font;
            }
        }
    }

    private Font getDefaultColoringFont() {
        Coloring coloring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getDefaultColoring()) != null && coloring.getFont() != null) {
            return coloring.getFont();
        }
        return SettingsDefaults.defaultFont;
    }

    protected Font getColoringFont() {
        Coloring coloring;
        if (this.font != null) {
            return this.font;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getColoring("code-folding")) != null && coloring.getFont() != null) {
            this.font = coloring.getFont();
            return this.font;
        }
        this.font = this.getDefaultColoringFont();
        return this.font;
    }

    protected Color getForeColor() {
        Coloring coloring;
        if (this.foreColor != null) {
            return this.foreColor;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getColoring("code-folding")) != null && coloring.getForeColor() != null) {
            this.foreColor = coloring.getForeColor();
            return this.foreColor;
        }
        this.foreColor = this.getDefaultForeColor();
        return this.foreColor;
    }

    private Color getDefaultForeColor() {
        Coloring coloring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getDefaultColoring()) != null && coloring.getForeColor() != null) {
            return coloring.getForeColor();
        }
        return SettingsDefaults.defaultForeColor;
    }

    private Color getDefaultBackColor() {
        Coloring coloring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getDefaultColoring()) != null) {
            return coloring.getBackColor();
        }
        return SettingsDefaults.defaultBackColor;
    }

    protected Color getBackColor() {
        Coloring coloring;
        if (this.backColor != null) {
            return this.backColor;
        }
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getColoring("code-folding")) != null && coloring.getBackColor() != null) {
            this.backColor = coloring.getBackColor();
            return this.backColor;
        }
        this.backColor = this.getDefaultBackColor();
        return this.backColor;
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewIndex(int n, Position.Bias bias) {
            return 0;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            return editorUI == null ? null : editorUI.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return this.view.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public Container getContainer() {
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            return editorUI == null ? null : editorUI.getComponent();
        }

        public ViewFactory getViewFactory() {
            BaseKit baseKit;
            ViewFactory viewFactory;
            EditorUI editorUI = CollapsedView.this.getEditorUI();
            if (editorUI != null && (viewFactory = (baseKit = Utilities.getKit(editorUI.getComponent())).getViewFactory()) != null) {
                return viewFactory;
            }
            return CollapsedView.this.getBaseTextUI();
        }
    }
}

