/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class Formatter
implements SettingsChangeListener {
    private static Map kitClass2Formatter = new HashMap();
    private static final int ISC_MAX_TAB_SIZE = 16;
    private static final int ISC_MAX_INDENT_SIZE = 32;
    private static final String[][] indentStringCache = new String[16][];
    private final Class kitClass;
    private boolean inited;
    private int tabSize;
    private boolean customTabSize;
    private Integer shiftWidth;
    private boolean customShiftWidth;
    private boolean expandTabs;
    private boolean customExpandTabs;
    private int spacesPerTab;
    private boolean customSpacesPerTab;

    public static synchronized Formatter getFormatter(Class clazz) {
        Formatter formatter = (Formatter)kitClass2Formatter.get(clazz);
        if (formatter == null) {
            formatter = BaseKit.getKit(clazz).createFormatter();
            kitClass2Formatter.put(clazz, formatter);
        }
        return formatter;
    }

    public static synchronized void setFormatter(Class clazz, Formatter formatter) {
        kitClass2Formatter.put(clazz, formatter);
    }

    public Formatter(Class clazz) {
        this.kitClass = clazz;
        Settings.addSettingsChangeListener(this);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Object object;
        String string;
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (!(this.inited && string != null && !"tab-size".equals(string) || this.customTabSize)) {
            this.tabSize = SettingsUtil.getInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if (!this.customShiftWidth && (object = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)object;
        }
        if (!(this.inited && string != null && !"expand-tabs".equals(string) || this.customExpandTabs)) {
            this.expandTabs = SettingsUtil.getBoolean(this.kitClass, "expand-tabs", SettingsDefaults.defaultExpandTabs);
        }
        if (!(this.inited && string != null && !"spaces-per-tab".equals(string) || this.customSpacesPerTab)) {
            this.spacesPerTab = SettingsUtil.getInteger(this.kitClass, "spaces-per-tab", SettingsDefaults.defaultSpacesPerTab);
        }
        this.inited = true;
    }

    public int getTabSize() {
        if (!this.customTabSize && !this.inited) {
            this.settingsChange(null);
        }
        return this.tabSize;
    }

    public void setTabSize(int n) {
        this.customTabSize = true;
        this.tabSize = n;
    }

    public int getShiftWidth() {
        if (!this.customShiftWidth && !this.inited) {
            this.settingsChange(null);
        }
        return this.shiftWidth != null ? this.shiftWidth.intValue() : this.getSpacesPerTab();
    }

    public void setShiftWidth(int n) {
        this.customShiftWidth = true;
        if (this.shiftWidth == null || this.shiftWidth != n) {
            this.shiftWidth = new Integer(n);
        }
    }

    public boolean expandTabs() {
        if (!this.customExpandTabs && !this.inited) {
            this.settingsChange(null);
        }
        return this.expandTabs;
    }

    public void setExpandTabs(boolean bl) {
        this.customExpandTabs = true;
        this.expandTabs = bl;
    }

    public int getSpacesPerTab() {
        if (!this.customSpacesPerTab && !this.inited) {
            this.settingsChange(null);
        }
        return this.spacesPerTab;
    }

    public void setSpacesPerTab(int n) {
        this.customSpacesPerTab = true;
        this.spacesPerTab = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getIndentString(int n, boolean bl, int n2) {
        if (n <= 0) {
            return "";
        }
        if (bl) {
            n2 = 0;
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean bl2 = n2 >= indentStringCache.length || n > 32;
            String string = null;
            String[] stringArray = null;
            if (!bl2) {
                stringArray = indentStringCache[n2];
                if (stringArray == null) {
                    stringArray = new String[32];
                    Formatter.indentStringCache[n2] = stringArray;
                }
                string = stringArray[n - 1];
            }
            if (string == null) {
                string = Analyzer.getIndentString(n, bl, n2);
                if (!bl2) {
                    stringArray[n - 1] = string;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return string;
        }
    }

    public String getIndentString(BaseDocument baseDocument, int n) {
        return Formatter.getIndentString(n, this.expandTabs(), baseDocument.getTabSize());
    }

    public String getIndentString(int n) {
        return Formatter.getIndentString(n, this.expandTabs(), this.getTabSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTabString(BaseDocument baseDocument, int n) throws BadLocationException {
        baseDocument.atomicLock();
        try {
            int n2;
            int n3 = Utilities.getRowStart(baseDocument, n);
            int n4 = Utilities.getFirstNonWhiteBwd(baseDocument, n, n3);
            n4 = n4 >= 0 ? n4 + 1 : n3;
            int n5 = Utilities.getVisualColumn(baseDocument, n4);
            int n6 = Utilities.getNextTabColumn(baseDocument, n);
            String string = Analyzer.getWhitespaceString(n5, n6, this.expandTabs(), baseDocument.getTabSize());
            char[] cArray = baseDocument.getChars(n4, n - n4);
            for (n2 = 0; n2 < cArray.length && cArray[n2] == string.charAt(n2); ++n2) {
            }
            baseDocument.remove(n4 += n2, n - n4);
            baseDocument.insertString(n4, string.substring(n2), null);
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRowIndent(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        baseDocument.atomicLock();
        try {
            int n3;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n3 = Utilities.getRowFirstNonWhite(baseDocument, n)) == -1) {
                n3 = Utilities.getRowEnd(baseDocument, n);
            }
            int n4 = Utilities.getRowStart(baseDocument, n);
            int n5 = n3 - n4;
            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n4, (int)n5);
            String string = this.getIndentString(baseDocument, n2);
            if (CharSequenceUtilities.startsWith((CharSequence)string, (CharSequence)charSequence)) {
                string = string.substring(n5);
                n4 += n5;
                n5 = 0;
            } else if (CharSequenceUtilities.endsWith((CharSequence)string, (CharSequence)charSequence)) {
                string = string.substring(0, string.length() - n5);
                n5 = 0;
            }
            if (n5 != 0) {
                baseDocument.remove(n4, n5);
            }
            baseDocument.insertString(n4, string, null);
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeBlockIndent(BaseDocument baseDocument, int n, int n2, int n3) throws BadLocationException {
        int n4;
        GuardedDocument guardedDocument;
        GuardedDocument guardedDocument2 = guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
        if (guardedDocument != null) {
            for (n4 = n; n4 < n2; ++n4) {
                if (!guardedDocument.isPosGuarded(n4)) continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        baseDocument.atomicLock();
        try {
            n4 = n3 * baseDocument.getShiftWidth();
            if (n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2) {
                --n2;
            }
            int n5 = Utilities.getRowStart(baseDocument, n);
            for (int i = Utilities.getRowCount(baseDocument, n, n2); i > 0; --i) {
                int n6 = Utilities.getRowIndent(baseDocument, n5);
                if (Utilities.isRowWhite(baseDocument, n5)) {
                    n6 = -n4;
                }
                this.changeRowIndent(baseDocument, n5, Math.max(n6 + n4, 0));
                n5 = Utilities.getRowStart(baseDocument, n5, 1);
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    public void shiftLine(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        int n2 = baseDocument.getShiftWidth();
        if (!bl) {
            n2 = -n2;
        }
        n2 = Utilities.isRowWhite(baseDocument, n) ? (n2 += Utilities.getVisualColumn(baseDocument, n)) : (n2 += Utilities.getRowIndent(baseDocument, n));
        n2 = Math.max(n2, 0);
        this.changeRowIndent(baseDocument, n, n2);
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            Writer writer = this.createWriter(baseDocument, n, charArrayWriter);
            writer.write(baseDocument.getChars(n, n2 - n));
            writer.close();
            String string = new String(charArrayWriter.toCharArray());
            baseDocument.remove(n, n2 - n);
            baseDocument.insertString(n, string, null);
            return string.length();
        }
        catch (IOException iOException) {
            Utilities.annotateLoggable(iOException);
            return 0;
        }
    }

    public int indentLine(Document document, int n) {
        return n;
    }

    public int indentNewLine(Document document, int n) {
        try {
            document.insertString(n, "\n", null);
            ++n;
        }
        catch (GuardedException guardedException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
        return n;
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return writer;
    }
}

