/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Comparator;
import org.netbeans.editor.ObjectArray;

public class ObjectArrayUtilities {
    private ObjectArrayUtilities() {
    }

    public static int binarySearch(ObjectArray objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.getItemCount() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray.getItem(n3);
            int n4 = ((Comparable)object2).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(ObjectArray objectArray, Object object, Comparator comparator) {
        int n = 0;
        int n2 = objectArray.getItemCount() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray.getItem(n3);
            int n4 = comparator.compare(object2, object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int findIndex(ObjectArray objectArray, Object object) {
        int n = ObjectArrayUtilities.binarySearch(objectArray, object);
        if (n < 0) {
            return -1;
        }
        if (objectArray.getItem(n) == object) {
            return n;
        }
        int n2 = objectArray.getItemCount();
        for (int i = n + 1; i < n2; ++i) {
            Object object2 = objectArray.getItem(i);
            if (object2 == object) {
                return i;
            }
            if (((Comparable)object).compareTo(object2) != 0) break;
        }
        while (--n >= 0) {
            Object object3 = objectArray.getItem(n);
            if (object3 == object) {
                return n;
            }
            if (((Comparable)object).compareTo(object3) == 0) continue;
            break;
        }
        return -1;
    }

    public static int findIndex(ObjectArray objectArray, Object object, Comparator comparator) {
        int n = ObjectArrayUtilities.binarySearch(objectArray, object, comparator);
        if (n < 0) {
            return -1;
        }
        if (objectArray.getItem(n) == object) {
            return n;
        }
        int n2 = objectArray.getItemCount();
        for (int i = n + 1; i < n2; ++i) {
            Object object2 = objectArray.getItem(i);
            if (object2 == object) {
                return i;
            }
            if (comparator.compare(object, object2) != 0) break;
        }
        while (--n >= 0) {
            Object object3 = objectArray.getItem(n);
            if (object3 == object) {
                return n;
            }
            if (comparator.compare(object, object3) == 0) continue;
            break;
        }
        return -1;
    }

    public static Object[] toArray(ObjectArray objectArray) {
        return ObjectArrayUtilities.toArray(objectArray, 0, objectArray.getItemCount());
    }

    public static Object[] toArray(ObjectArray objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2 - n];
        ObjectArrayUtilities.copyItems(objectArray, n, n2, objectArray2, 0);
        return objectArray2;
    }

    public static void copyItems(ObjectArray objectArray, Object[] objectArray2) {
        ObjectArrayUtilities.copyItems(objectArray, 0, objectArray.getItemCount(), objectArray2, 0);
    }

    public static void copyItems(ObjectArray objectArray, int n, int n2, Object[] objectArray2, int n3) {
        if (objectArray instanceof ObjectArray.CopyItems) {
            ((ObjectArray.CopyItems)((Object)objectArray)).copyItems(n, n2, objectArray2, n3);
        } else {
            while (n < n2) {
                objectArray2[n3++] = objectArray.getItem(n++);
            }
        }
    }

    public static void reverse(Object[] objectArray) {
        int n = 0;
        for (int i = objectArray.length - 1; n < i; ++n, --i) {
            Object object = objectArray[n];
            objectArray[n] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public static ObjectArray.Modification mergeModifications(final ObjectArray.Modification modification, ObjectArray.Modification modification2) {
        int n;
        Object[] objectArray;
        int n2;
        if (modification.getArray() != modification2.getArray()) {
            throw new IllegalArgumentException("Cannot merge modifications to different object arrays.");
        }
        if (modification.getIndex() <= modification2.getIndex()) {
            n2 = modification.getIndex();
            int n3 = Math.min(modification.getIndex() + modification.getAddedItems().length - modification2.getIndex(), modification2.getRemovedItemsCount());
            objectArray = new Object[modification.getAddedItems().length + modification2.getAddedItems().length - n3];
            if (n3 < 0) {
                System.arraycopy(modification.getAddedItems(), 0, objectArray, 0, modification.getAddedItems().length);
                ObjectArrayUtilities.copyItems(modification.getArray(), modification.getIndex() + modification.getRemovedItemsCount(), modification.getIndex() + modification.getRemovedItemsCount() - n3, objectArray, modification.getAddedItems().length);
                System.arraycopy(modification2.getAddedItems(), 0, objectArray, modification2.getIndex() - modification.getIndex(), modification2.getAddedItems().length);
            } else {
                System.arraycopy(modification.getAddedItems(), 0, objectArray, 0, modification2.getIndex() - modification.getIndex());
                System.arraycopy(modification2.getAddedItems(), 0, objectArray, modification2.getIndex() - modification.getIndex(), modification2.getAddedItems().length);
                System.arraycopy(modification.getAddedItems(), modification2.getIndex() - modification.getIndex() + n3, objectArray, modification2.getIndex() - modification.getIndex() + modification2.getAddedItems().length, modification.getAddedItems().length - modification2.getIndex() + modification.getIndex() - n3);
            }
            n = modification.getRemovedItemsCount() + modification2.getRemovedItemsCount() - n3;
        } else {
            n2 = modification2.getIndex();
            int n4 = Math.min(modification2.getIndex() + modification2.getRemovedItemsCount() - modification.getIndex(), modification.getAddedItems().length);
            objectArray = new Object[modification.getAddedItems().length + modification2.getAddedItems().length - n4];
            System.arraycopy(modification2.getAddedItems(), 0, objectArray, 0, modification2.getAddedItems().length);
            if (n4 < 0) {
                ObjectArrayUtilities.copyItems(modification.getArray(), modification2.getIndex() + modification2.getRemovedItemsCount(), modification.getIndex(), objectArray, modification2.getAddedItems().length);
                System.arraycopy(modification.getAddedItems(), 0, objectArray, modification2.getAddedItems().length - n4, modification.getAddedItems().length);
            } else {
                System.arraycopy(modification.getAddedItems(), n4, objectArray, modification2.getAddedItems().length, modification.getAddedItems().length - n4);
            }
            n = modification.getRemovedItemsCount() + modification2.getRemovedItemsCount() - n4;
        }
        return new ObjectArray.Modification(){

            public ObjectArray getArray() {
                return modification.getArray();
            }

            public int getIndex() {
                return n2;
            }

            public Object[] getAddedItems() {
                return objectArray;
            }

            public int getRemovedItemsCount() {
                return n;
            }
        };
    }

    public static ObjectArray.Modification mergeModifications(ObjectArray.Modification[] modificationArray) {
        ObjectArray.Modification modification = modificationArray.length > 0 ? modificationArray[0] : null;
        for (int i = 1; i < modificationArray.length; ++i) {
            modification = ObjectArrayUtilities.mergeModifications(modification, modificationArray[i]);
        }
        return modification;
    }
}

