/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.hyperlink;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.HyperlinkProviderManager;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.openide.ErrorManager;

public class HyperlinkOperation
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
KeyListener {
    private static Cursor HAND_CURSOR = null;
    private JTextComponent component;
    private Document currentDocument;
    private HyperlinkLayer layer;
    private String mimeType;
    private Cursor oldComponentsMouseCursor;
    private boolean hyperlinkUp;
    private boolean listenersSetUp;
    private boolean hyperlinkEnabled;
    private int actionKeyMask;

    public static HyperlinkOperation create(JTextComponent jTextComponent, String string) {
        return new HyperlinkOperation(jTextComponent, string);
    }

    private static synchronized Cursor getHandCursor() {
        if (HAND_CURSOR == null) {
            HAND_CURSOR = Cursor.getPredefinedCursor(12);
        }
        return HAND_CURSOR;
    }

    private HyperlinkOperation(JTextComponent jTextComponent, String string) {
        this.component = jTextComponent;
        this.mimeType = string;
        this.oldComponentsMouseCursor = null;
        this.hyperlinkUp = false;
        this.listenersSetUp = false;
        this.readSettings();
        if (this.hyperlinkEnabled) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            this.layer = new HyperlinkLayer();
            if (editorUI != null) {
                editorUI.addLayer(this.layer, 1100);
            }
            jTextComponent.addPropertyChangeListener("document", this);
        }
    }

    private void documentUpdated() {
        if (!this.hyperlinkEnabled) {
            return;
        }
        this.currentDocument = this.component.getDocument();
        if (this.currentDocument instanceof BaseDocument && !this.listenersSetUp) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
            this.component.addKeyListener(this);
            this.listenersSetUp = true;
        }
    }

    private void readSettings() {
        String string = System.getProperty("org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey");
        if (string != null) {
            if ("off".equals(string)) {
                this.hyperlinkEnabled = false;
                this.actionKeyMask = -1;
            } else {
                this.hyperlinkEnabled = true;
                this.actionKeyMask = -1;
                for (int i = 0; i < string.length(); ++i) {
                    int n = 0;
                    switch (string.charAt(i)) {
                        case 'S': {
                            n = 64;
                            break;
                        }
                        case 'C': {
                            n = 128;
                            break;
                        }
                        case 'A': {
                            n = 512;
                            break;
                        }
                        case 'M': {
                            n = 256;
                            break;
                        }
                        default: {
                            ErrorManager.getDefault().log(16, "Incorrect value of org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey property (only letters CSAM are allowed): " + string.charAt(i));
                        }
                    }
                    if (n == 0) {
                        this.actionKeyMask = -1;
                        break;
                    }
                    if (this.actionKeyMask == -1) {
                        this.actionKeyMask = n;
                        continue;
                    }
                    this.actionKeyMask |= n;
                }
                if (this.actionKeyMask == -1) {
                    ErrorManager.getDefault().log(16, "Some problem with property org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey, more information might be given above. Falling back to the default behaviour.");
                } else {
                    return;
                }
            }
        }
        this.hyperlinkEnabled = true;
        Object object = Settings.getValue(Utilities.getKitClass(this.component), "hyperlink-activation-modifiers");
        this.actionKeyMask = object != null && object instanceof Integer ? (Integer)object : 128;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isHyperlinkEvent(mouseEvent)) {
            int n = this.component.viewToModel(mouseEvent.getPoint());
            if (n < 0) {
                this.unHyperlink(true);
                return;
            }
            this.performHyperlinking(n);
        } else {
            this.unHyperlink(true);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private boolean isHyperlinkEvent(InputEvent inputEvent) {
        return ((inputEvent.getModifiers() | inputEvent.getModifiersEx()) & this.actionKeyMask) == this.actionKeyMask;
    }

    private void performHyperlinking(int n) {
        HyperlinkProvider hyperlinkProvider = this.findProvider(n);
        if (hyperlinkProvider != null) {
            int[] nArray = hyperlinkProvider.getHyperlinkSpan(this.component.getDocument(), n);
            if (nArray != null) {
                this.makeHyperlink(nArray[0], nArray[1]);
            }
        } else {
            this.unHyperlink(true);
        }
    }

    private void performAction(int n) {
        HyperlinkProvider hyperlinkProvider = this.findProvider(n);
        if (hyperlinkProvider != null) {
            this.unHyperlink(true);
            this.component.getCaret().setDot(n);
            JumpList.checkAddEntry(this.component, n);
            hyperlinkProvider.performClickAction(this.component.getDocument(), n);
        }
    }

    private HyperlinkProvider findProvider(int n) {
        Object object = this.component.getDocument().getProperty("mimeType");
        String string = object instanceof String ? (String)object : this.mimeType;
        List list = HyperlinkProviderManager.getDefault().getHyperlinkProviders(string);
        for (HyperlinkProvider hyperlinkProvider : list) {
            if (!hyperlinkProvider.isHyperlinkPoint(this.component.getDocument(), n)) continue;
            return hyperlinkProvider;
        }
        return null;
    }

    private synchronized void makeHyperlink(int n, int n2) {
        boolean bl = true;
        if (this.hyperlinkUp) {
            this.unHyperlink(false);
            bl = false;
        }
        try {
            Position position = this.layer.hyperlinkStart = this.component.getDocument().createPosition(n);
            Position position2 = this.layer.hyperlinkEnd = this.component.getDocument().createPosition(n2);
            this.hyperlinkUp = true;
            this.damageRange(position, position2);
            if (bl) {
                this.oldComponentsMouseCursor = this.component.isCursorSet() ? this.component.getCursor() : null;
                this.component.setCursor(HyperlinkOperation.getHandCursor());
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            this.unHyperlink(false);
        }
    }

    private void damageRange(final Position position, final Position position2) {
        if (position != null && position2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HyperlinkOperation.this.component.getDocument().render(new Runnable(){

                        public void run() {
                            int n = position.getOffset();
                            int n2 = position2.getOffset();
                            HyperlinkOperation.this.component.getUI().damageRange(HyperlinkOperation.this.component, n, n2);
                        }
                    });
                }
            });
        }
    }

    private synchronized void unHyperlink(boolean bl) {
        if (!this.hyperlinkUp) {
            return;
        }
        Position position = this.layer.hyperlinkStart;
        Position position2 = this.layer.hyperlinkEnd;
        this.layer.hyperlinkStart = null;
        this.layer.hyperlinkEnd = null;
        this.damageRange(position, position2);
        if (bl) {
            if (this.component.isCursorSet() && this.component.getCursor() == HyperlinkOperation.getHandCursor()) {
                this.component.setCursor(this.oldComponentsMouseCursor);
            }
            this.oldComponentsMouseCursor = null;
        }
        this.hyperlinkUp = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.currentDocument != this.component.getDocument()) {
            this.documentUpdated();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if ((keyEvent.getModifiers() & this.actionKeyMask) == 0) {
            this.unHyperlink(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isHyperlinkEvent(mouseEvent) && !mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
            int n = this.component.viewToModel(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            this.performAction(n);
        }
    }

    private static class HyperlinkLayer
    extends DrawLayer.AbstractLayer {
        private Position hyperlinkStart = null;
        private Position hyperlinkEnd = null;
        public static final String NAME = "hyperlink-layer";
        public static final int VISIBILITY = 1050;
        private boolean initialized = false;
        private static Coloring hoverColoring = new Coloring(null, 0, Color.BLUE, null, Color.BLUE, null);

        public HyperlinkLayer() {
            super(NAME);
        }

        private void checkDocument(Document document) {
        }

        public boolean extendsEOL() {
            return true;
        }

        public synchronized void init(DrawContext drawContext) {
            if (!this.initialized) {
                BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                this.initialized = true;
                this.checkDocument(baseDocument);
            }
            if (this.isActive()) {
                this.setNextActivityChangeOffset(this.hyperlinkStart.getOffset());
            }
        }

        private boolean isActive() {
            return this.hyperlinkStart != null && this.hyperlinkEnd != null;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            return this.isActive();
        }

        private boolean isIn(int n) {
            return n >= this.hyperlinkStart.getOffset() && n < this.hyperlinkEnd.getOffset();
        }

        public void updateContext(DrawContext drawContext) {
            if (!this.isActive()) {
                return;
            }
            int n = drawContext.getFragmentOffset();
            if (this.isIn(n)) {
                hoverColoring.apply(drawContext);
                if (this.isIn(n + drawContext.getFragmentLength())) {
                    this.setNextActivityChangeOffset(n + drawContext.getFragmentLength());
                }
            }
        }
    }
}

