/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingDrawLayer
extends DrawLayer.AbstractLayer
implements HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(HighlightingDrawLayer.class.getName());
    private static final String LAYER_A_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/A";
    private static final String LAYER_B_NAME = "highlight-row-layer";
    private static final String LAYER_C_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/C";
    private static final HighlightsLayerFilter FILTER_A = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            boolean bl = false;
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(highlightsLayerAccessor.getLayerTypeId())) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                arrayList.add(highlightsLayer);
            }
            return arrayList;
        }
    };
    private static final HighlightsLayerFilter FILTER_B = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (!"org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(highlightsLayerAccessor.getLayerTypeId())) continue;
                arrayList.add(highlightsLayer);
                break;
            }
            return arrayList;
        }
    };
    private static final HighlightsLayerFilter FILTER_C = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(highlightsLayerAccessor.getLayerTypeId())) break;
                arrayList.add(highlightsLayer);
            }
            return arrayList;
        }
    };
    private final HighlightsLayerFilter filter;
    private WeakReference<JTextComponent> paneRef = null;
    private HighlightsContainer highlights = null;
    private AttributeSet lastAttributeSet = null;
    private AttributeSet lastEOLAttribs = null;
    private AttributeSet lastELAttribs = null;
    private boolean theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;

    public static void hookUp(EditorUI editorUI) {
        DrawLayer drawLayer;
        DrawLayer drawLayer2;
        DrawLayer drawLayer3 = editorUI.findLayer(LAYER_A_NAME);
        if (drawLayer3 == null) {
            drawLayer3 = new HighlightingDrawLayer(LAYER_A_NAME, FILTER_A);
            editorUI.addLayer(drawLayer3, 10000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerA in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerA is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
        if ((drawLayer2 = editorUI.findLayer(LAYER_B_NAME)) == null) {
            drawLayer2 = new HighlightingDrawLayer(LAYER_B_NAME, FILTER_B);
            editorUI.addLayer(drawLayer2, 2050);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerB in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerB is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
        if ((drawLayer = editorUI.findLayer(LAYER_C_NAME)) == null) {
            drawLayer = new HighlightingDrawLayer(LAYER_C_NAME, FILTER_C);
            editorUI.addLayer(drawLayer, 1000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerC in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerC is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
    }

    private HighlightingDrawLayer(String string, HighlightsLayerFilter highlightsLayerFilter) {
        super(string);
        this.filter = highlightsLayerFilter;
    }

    @Override
    public void init(DrawContext drawContext) {
        super.init(drawContext);
        if (this.highlights == null) {
            BaseDocument baseDocument;
            JTextComponent jTextComponent = drawContext.getEditorUI().getComponent();
            if (jTextComponent == null) {
                baseDocument = drawContext.getEditorUI().getDocument();
                String string = (String)baseDocument.getProperty("mimeType");
                assert (string != null) : "Document's mime type can't be null: " + baseDocument;
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setDocument(baseDocument);
                jEditorPane.putClientProperty("HighlightsLayerIncludes", new String[]{"^.*NonLexerSyntaxHighlighting$", "^.*SyntaxHighlighting$"});
                jTextComponent = jEditorPane;
            }
            this.paneRef = new WeakReference<JTextComponent>(jTextComponent);
            baseDocument = HighlightingManager.getInstance();
            this.highlights = baseDocument.getHighlights(jTextComponent, this.filter);
            this.highlights.addHighlightsChangeListener((HighlightsChangeListener)this);
        }
        this.lastAttributeSet = null;
        this.lastEOLAttribs = null;
        this.lastELAttribs = null;
        this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
    }

    @Override
    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        if (this.highlights != null) {
            return this.processOffset(drawContext, false);
        }
        return false;
    }

    @Override
    public void updateContext(DrawContext drawContext) {
        if (this.highlights != null) {
            if (drawContext.isEOL() && drawContext.isBOL()) {
                if (this.extendsEmptyLine() && !this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn) {
                    this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = true;
                    Coloring coloring = Coloring.fromAttributeSet(this.lastELAttribs);
                    coloring.apply(drawContext);
                } else if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(drawContext);
                }
            } else if (drawContext.isEOL()) {
                if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(drawContext);
                }
            } else {
                this.processOffset(drawContext, true);
            }
        }
    }

    @Override
    public boolean extendsEOL() {
        if (this.lastEOLAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> list = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] attributeSetArray = this.filter(list != null ? list : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = attributeSetArray[0];
            this.lastELAttribs = attributeSetArray[1];
        }
        return this.lastEOLAttribs != null && this.lastEOLAttribs != SimpleAttributeSet.EMPTY;
    }

    @Override
    public boolean extendsEmptyLine() {
        if (this.lastELAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> list = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] attributeSetArray = this.filter(list != null ? list : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = attributeSetArray[0];
            this.lastELAttribs = attributeSetArray[1];
        }
        return this.lastELAttribs != null && this.lastELAttribs != SimpleAttributeSet.EMPTY;
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BRIDGE-LAYER: changed area [" + highlightsChangeEvent.getStartOffset() + ", " + highlightsChangeEvent.getEndOffset() + "]");
        }
        this.setNextActivityChangeOffset(0);
        JTextComponent jTextComponent = (JTextComponent)this.paneRef.get();
        if (jTextComponent != null) {
            int n;
            int n2 = Math.min(highlightsChangeEvent.getEndOffset(), jTextComponent.getDocument().getLength());
            int n3 = n = highlightsChangeEvent.getStartOffset() >= n2 ? 0 : highlightsChangeEvent.getStartOffset();
            if (n < n2) {
                try {
                    jTextComponent.getUI().damageRange(jTextComponent, n, n2);
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "Can't update view: range = [" + n + ", " + n2 + "]", exception);
                }
            }
        }
    }

    private boolean processOffset(DrawContext drawContext, boolean bl) {
        HighlightsSequence highlightsSequence;
        boolean bl2;
        int n;
        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
        int n2 = baseDocument.getParagraphElement(n = drawContext.getFragmentOffset()).getEndOffset();
        if (n2 >= baseDocument.getLength()) {
            n2 = Integer.MAX_VALUE;
        }
        if (bl2 = (highlightsSequence = this.highlights.getHighlights(n, n2)).moveNext()) {
            if (highlightsSequence.getStartOffset() <= n) {
                if (bl) {
                    Coloring coloring = Coloring.fromAttributeSet(highlightsSequence.getAttributes());
                    coloring.apply(drawContext);
                }
                this.lastAttributeSet = highlightsSequence.getAttributes();
                this.setNextActivityChangeOffset(highlightsSequence.getEndOffset());
            } else {
                this.setNextActivityChangeOffset(highlightsSequence.getStartOffset());
            }
            return true;
        }
        return false;
    }

    private AttributeSet[] filter(List<AttributeSet> list) {
        AttributeSet attributeSet2;
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        ArrayList<AttributeSet> arrayList2 = new ArrayList<AttributeSet>();
        for (AttributeSet attributeSet2 : list) {
            Object object = attributeSet2.getAttribute(HighlightsContainer.ATTR_EXTENDS_EOL);
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                arrayList.add(attributeSet2);
            }
            if (!((object = attributeSet2.getAttribute(HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            arrayList2.add(attributeSet2);
        }
        AttributeSet attributeSet3 = arrayList.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])arrayList.toArray(new AttributeSet[arrayList.size()])) : (arrayList.size() == 1 ? (AttributeSet)arrayList.get(0) : SimpleAttributeSet.EMPTY);
        attributeSet2 = arrayList2.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])arrayList2.toArray(new AttributeSet[arrayList2.size()])) : (arrayList2.size() == 1 ? (AttributeSet)arrayList2.get(0) : SimpleAttributeSet.EMPTY);
        return new AttributeSet[]{attributeSet3, attributeSet2};
    }

    private static String simpleToString(Object object) {
        return object == null ? "null" : object.getClass() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

