/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected void add(SearchType searchType) {
        boolean bl = false;
        Class[] classArray = searchType.getSearchTypeClasses();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != (class$org$openide$filesystems$FileObject == null ? FileObjectSearchGroup.class$("org.openide.filesystems.FileObject") : class$org$openide$filesystems$FileObject)) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        FileObject[] fileObjectArray = this.getFileFolders();
        if (fileObjectArray == null) {
            return;
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (this.scanFolder(fileObjectArray[i])) continue;
            return;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodeArray = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            DataFolder dataFolder = (DataFolder)nodeArray[i].getCookie(class$org$openide$loaders$DataFolder == null ? FileObjectSearchGroup.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (dataFolder == null) continue;
            arrayList.add(dataFolder.getPrimaryFile());
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private boolean scanFolder(FileObject fileObject) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (fileObjectArray[i].isFolder()) {
                if (this.scanFolder(fileObjectArray[i])) continue;
                return false;
            }
            this.processSearchObject(fileObjectArray[i]);
        }
        return true;
    }

    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (FileObjectSearchGroup.hasParent(nodeArray[i], nodeArray)) continue;
            arrayList.add(nodeArray[i]);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodeArray) {
        for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!nodeArray[i].equals((Object)node2)) continue;
                return true;
            }
        }
        return false;
    }
}

