/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.Node;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.FileObjectSearchGroup;
import org.openidex.search.SearchType;

public abstract class SearchGroup {
    public static final String PROP_FOUND = "org.openidex.search.found";
    public static final String PROP_RESULT = "org.openidex.search.result";
    private PropertyChangeSupport propChangeSupport;
    protected SearchType[] searchTypes = new SearchType[0];
    protected final Set searchRoots = new HashSet(5);
    protected final Set resultObjects = new LinkedHashSet(50);
    protected volatile boolean stopped = false;
    private PropertyChangeListener propListener;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    protected void add(SearchType searchType) {
        for (int i = 0; i < this.searchTypes.length; ++i) {
            if (!searchType.equals(this.searchTypes[i])) continue;
            return;
        }
        SearchType[] searchTypeArray = new SearchType[this.searchTypes.length + 1];
        System.arraycopy(this.searchTypes, 0, searchTypeArray, 0, this.searchTypes.length);
        searchTypeArray[this.searchTypes.length] = searchType;
        this.searchTypes = searchTypeArray;
    }

    public SearchType[] getSearchTypes() {
        return this.searchTypes;
    }

    public void setSearchRootNodes(Node[] nodeArray) {
        for (int i = 0; i < this.searchTypes.length; ++i) {
            nodeArray = this.searchTypes[i].acceptSearchRootNodes(nodeArray);
        }
        this.searchRoots.clear();
        this.searchRoots.addAll(Arrays.asList(nodeArray));
    }

    public Node[] getSearchRoots() {
        return this.searchRoots.toArray(new Node[this.searchRoots.size()]);
    }

    public final void stopSearch() {
        this.stopped = true;
    }

    public void search() {
        this.resultObjects.clear();
        this.prepareSearch();
        this.doSearch();
    }

    protected void prepareSearch() {
    }

    protected abstract void doSearch();

    protected void processSearchObject(Object object) {
        int n;
        for (n = 0; n < this.searchTypes.length; ++n) {
            if (this.searchTypes[n].acceptSearchObject(object)) continue;
            return;
        }
        for (n = 0; n < this.searchTypes.length; ++n) {
            this.searchTypes[n].prepareSearchObject(object);
        }
        for (n = 0; n < this.searchTypes.length; ++n) {
            if (this.searchTypes[n].testObject(object)) continue;
            return;
        }
        this.resultObjects.add(object);
        this.firePropertyChange(PROP_FOUND, null, object);
    }

    public abstract Node getNodeForFoundObject(Object var1);

    public Set getResultObjects() {
        return new LinkedHashSet(this.resultObjects);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertySupport().addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertySupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertySupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertySupport() {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propChangeSupport;
    }

    public static SearchGroup[] createSearchGroups(SearchType[] searchTypeArray) {
        Object object;
        HashSet<Class> hashSet = new HashSet<Class>(searchTypeArray.length);
        for (int i = 0; i < searchTypeArray.length; ++i) {
            object = Arrays.asList(searchTypeArray[i].getSearchTypeClasses());
            if (i == 0) {
                hashSet.addAll((Collection<Class>)object);
                continue;
            }
            hashSet.retainAll((Collection<?>)object);
        }
        if (hashSet.isEmpty()) {
            return new SearchGroup[0];
        }
        HashSet<SearchGroup> hashSet2 = new HashSet<SearchGroup>(hashSet.size());
        object = hashSet.iterator();
        while (object.hasNext()) {
            SearchGroup searchGroup = Registry.createSearchGroup((Class)object.next());
            if (searchGroup == null) continue;
            for (int i = 0; i < searchTypeArray.length; ++i) {
                searchGroup.add(searchTypeArray[i]);
            }
            hashSet2.add(searchGroup);
        }
        return hashSet2.toArray(new SearchGroup[hashSet2.size()]);
    }

    public static interface Factory {
        public SearchGroup createSearchGroup();
    }

    public static final class Registry {
        private static final Map registry = new HashMap(2);

        private Registry() {
        }

        public static synchronized boolean registerSearchGroupFactory(Class clazz, Factory factory) {
            Factory factory2 = registry.put(clazz, factory);
            if (factory2 != null) {
                registry.put(clazz, factory2);
                return false;
            }
            return true;
        }

        public static SearchGroup createSearchGroup(Class clazz) {
            Factory factory = (Factory)registry.get(clazz);
            if (factory == null) {
                return null;
            }
            return factory.createSearchGroup();
        }

        public static boolean hasFactory(Class clazz) {
            return registry.containsKey(clazz);
        }

        static {
            registry.put(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SearchGroup.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new DataObjectSearchGroup();
                }
            });
            registry.put(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SearchGroup.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject, new Factory(){

                public SearchGroup createSearchGroup() {
                    return new FileObjectSearchGroup();
                }
            });
        }
    }
}

