/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.IntrospectionException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;

public class BeanChildren
extends Children.Keys {
    private static final Factory DEFAULT_FACTORY = new BeanFactory();
    private static final Map<Node, Reference[]> nodes2Beans = new WeakHashMap<Node, Reference[]>();
    private BeanContext bean;
    private Factory factory;
    private ContextL contextL;

    public BeanChildren(BeanContext beanContext) {
        this(beanContext, DEFAULT_FACTORY);
    }

    public BeanChildren(BeanContext beanContext, Factory factory) {
        this.bean = beanContext;
        this.factory = factory;
    }

    final void updateKeys() {
        this.setKeys(this.bean.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node[] createNodes(Object object) {
        try {
            Object object2;
            if (object instanceof BeanContextSupport && this.bean.contains(((BeanContextSupport)(object2 = (BeanContextSupport)object)).getBeanContextPeer()) && object2 != ((BeanContextSupport)object2).getBeanContextPeer()) {
                return new Node[0];
            }
            object2 = this.factory.createNode(object);
            Map<Node, Reference[]> map = nodes2Beans;
            synchronized (map) {
                nodes2Beans.put((Node)object2, new Reference[]{new WeakReference<BeanContext>(this.bean), new WeakReference<Object>(object)});
            }
            ((Node)object2).addNodeListener(this.contextL);
            return new Node[]{object2};
        }
        catch (IntrospectionException introspectionException) {
            Logger.getLogger(BeanChildren.class.getName()).log(Level.WARNING, null, introspectionException);
            return new Node[0];
        }
    }

    protected void addNotify() {
        this.contextL = new ContextL(this);
        this.bean.addBeanContextMembershipListener(this.contextL);
        this.updateKeys();
    }

    protected void removeNotify() {
        if (this.contextL != null) {
            this.bean.removeBeanContextMembershipListener(this.contextL);
        }
        this.contextL = null;
        this.setKeys(Collections.EMPTY_SET);
    }

    private static class BeanFactory
    implements Factory {
        BeanFactory() {
        }

        public Node createNode(Object object) throws IntrospectionException {
            return new BeanNode<Object>(object);
        }
    }

    private static final class ContextL
    extends NodeAdapter
    implements BeanContextMembershipListener {
        private WeakReference<BeanChildren> ref;

        ContextL() {
        }

        ContextL(BeanChildren beanChildren) {
            this.ref = new WeakReference<BeanChildren>(beanChildren);
        }

        public void childrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
            BeanChildren beanChildren = (BeanChildren)this.ref.get();
            if (beanChildren != null) {
                beanChildren.updateKeys();
            }
        }

        public void childrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
            BeanChildren beanChildren = (BeanChildren)this.ref.get();
            if (beanChildren != null) {
                beanChildren.updateKeys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeDestroyed(NodeEvent nodeEvent) {
            Object t;
            Reference[] referenceArray;
            Node node = nodeEvent.getNode();
            Object object = nodes2Beans;
            synchronized (object) {
                referenceArray = (Reference[])nodes2Beans.get(node);
            }
            if (referenceArray != null && (object = (BeanContext)referenceArray[0].get()) != null && (t = referenceArray[1].get()) != null) {
                try {
                    object.remove(t);
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(BeanChildren.class.getName()).log(Level.WARNING, null, runtimeException);
                }
            }
        }
    }

    public static interface Factory {
        public Node createNode(Object var1) throws IntrospectionException;
    }
}

