/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Children {
    static final Mutex.Privileged PR = new Mutex.Privileged();
    public static final Mutex MUTEX = new Mutex(PR);
    public static final Children LEAF = new Empty();
    private static final Object LOCK = new Object();
    private static final Logger LOG_GET_ARRAY = Logger.getLogger("org.openide.nodes.Children.getArray");
    private Node parent;
    private java.util.Map<Entry, Info> map;
    private Collection<? extends Entry> entries = Collections.emptyList();
    private Reference<ChildrenArray> array = new WeakReference<Object>(null);
    private Thread initThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attachTo(Node node) throws IllegalStateException {
        if (this == LEAF) {
            return;
        }
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent != null) {
                throw new IllegalStateException("An instance of Children may not be used for more than one parent node.");
            }
            this.parent = node;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                PR.enterReadAccess();
                nodeArray = this.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.assignTo((Children)this, i);
                    node2.fireParentNodeChange(null, this.parent);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detachFrom() {
        if (this == LEAF) {
            return;
        }
        Node node = null;
        Node[] nodeArray = this;
        synchronized (this) {
            if (this.parent == null) {
                throw new IllegalStateException("Trying to detach children which do not have parent");
            }
            node = this.parent;
            this.parent = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                PR.enterReadAccess();
                nodeArray = this.testNodes();
                if (nodeArray == null) {
                    return;
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = nodeArray[i];
                    node2.deassignFrom((Children)this);
                    node2.fireParentNodeChange(node, null);
                }
            }
            finally {
                PR.exitReadAccess();
            }
            return;
        }
    }

    protected final Node getNode() {
        return this.parent;
    }

    final Object cloneHierarchy() throws CloneNotSupportedException {
        return this.clone();
    }

    protected Object clone() throws CloneNotSupportedException {
        Children children = (Children)super.clone();
        children.parent = null;
        children.map = null;
        children.entries = Collections.emptyList();
        children.array = new WeakReference<Object>(null);
        return children;
    }

    public abstract boolean add(Node[] var1);

    public abstract boolean remove(Node[] var1);

    public final Enumeration<Node> nodes() {
        return Enumerations.array((Object[])this.getNodes());
    }

    public Node findChild(String string) {
        Node[] nodeArray = this.getNodes();
        if (nodeArray.length == 0) {
            return null;
        }
        if (string == null) {
            return nodeArray[0];
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!string.equals(nodeArray[i].getName())) continue;
            return nodeArray[i];
        }
        return null;
    }

    protected final boolean isInitialized() {
        ChildrenArray childrenArray = this.array.get();
        return childrenArray != null && childrenArray.isInitialized();
    }

    final Node getNodeAt(int n) {
        return this.getNodes()[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node[] getNodes() {
        Node[] nodeArray;
        boolean[] blArray = new boolean[2];
        do {
            blArray[1] = this.isInitialized();
            ChildrenArray childrenArray = this.getArray(blArray);
            try {
                PR.enterReadAccess();
                nodeArray = childrenArray.nodes();
            }
            finally {
                PR.exitReadAccess();
            }
            boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
            if (bl) {
                LOG_GET_ARRAY.fine("  length     : " + nodeArray.length);
                LOG_GET_ARRAY.fine("  entries    : " + this.entries);
                LOG_GET_ARRAY.fine("  init now   : " + this.isInitialized());
            }
            if (!blArray[1]) continue;
            return nodeArray;
        } while (!blArray[0]);
        return nodeArray == null ? new Node[]{} : nodeArray;
    }

    public Node[] getNodes(boolean bl) {
        if (bl) {
            boolean bl2 = LOG_GET_ARRAY.isLoggable(Level.FINE);
            if (bl2) {
                LOG_GET_ARRAY.fine("computing optimal result");
            }
            ChildrenArray childrenArray = this.getArray(null);
            if (bl2) {
                LOG_GET_ARRAY.fine("optimal result is here: " + childrenArray);
            }
            Node node = this.findChild(null);
            if (bl2) {
                LOG_GET_ARRAY.fine("Find child got: " + node);
            }
        }
        return this.getNodes();
    }

    public final int getNodesCount() {
        return this.getNodes().length;
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    void callAddNotify() {
        this.addNotify();
    }

    private Node[] testNodes() {
        ChildrenArray childrenArray = this.array.get();
        return childrenArray == null ? null : childrenArray.nodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChildrenArray getArray(boolean[] blArray) {
        ChildrenArray childrenArray;
        final boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
        boolean bl2 = false;
        Object object = LOCK;
        synchronized (object) {
            childrenArray = this.array.get();
            if (childrenArray == null) {
                childrenArray = new ChildrenArray();
                this.registerChildrenArray(childrenArray, true);
                bl2 = true;
                this.initThread = Thread.currentThread();
            }
        }
        if (bl2) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SetAndNotify
            implements Runnable {
                public ChildrenArray toSet;
                public Children whatSet;

                SetAndNotify() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LOCK;
                    synchronized (object) {
                        Children.this.initThread = null;
                        LOCK.notifyAll();
                    }
                    if (bl) {
                        LOG_GET_ARRAY.fine("notifyAll done");
                    }
                }
            }
            if (bl) {
                LOG_GET_ARRAY.fine("Initialize " + this + " on " + Thread.currentThread());
            }
            try {
                this.callAddNotify();
                if (bl) {
                    LOG_GET_ARRAY.fine("addNotify successfully called for " + this + " on " + Thread.currentThread());
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                boolean bl3 = MUTEX.isReadAccess();
                if (bl) {
                    LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl3);
                }
                childrenArray.children = this;
                SetAndNotify setAndNotify = new SetAndNotify();
                setAndNotify.toSet = childrenArray;
                setAndNotify.whatSet = this;
                if (bl3) {
                    MUTEX.postWriteRequest((Runnable)setAndNotify);
                    throw throwable;
                } else {
                    setAndNotify.run();
                }
                throw throwable;
            }
            boolean bl4 = MUTEX.isReadAccess();
            if (bl) {
                LOG_GET_ARRAY.fine("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl4);
            }
            childrenArray.children = this;
            SetAndNotify setAndNotify = new SetAndNotify();
            setAndNotify.toSet = childrenArray;
            setAndNotify.whatSet = this;
            if (bl4) {
                MUTEX.postWriteRequest((Runnable)setAndNotify);
                return childrenArray;
            }
            setAndNotify.run();
            return childrenArray;
        }
        if (MUTEX.isReadAccess() || MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
            if (bl) {
                LOG_GET_ARRAY.log(Level.FINE, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + MUTEX.isReadAccess() + " initThread: " + this.initThread, new Exception("StackTrace"));
            }
            if (blArray == null) return childrenArray;
            blArray[0] = true;
            return childrenArray;
        }
        object = LOCK;
        synchronized (object) {
            while (this.initThread != null) {
                if (bl) {
                    LOG_GET_ARRAY.fine("waiting for children for " + this + " on " + Thread.currentThread());
                }
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!bl) return childrenArray;
        LOG_GET_ARRAY.fine(" children are here for " + this + " on " + Thread.currentThread() + " children " + childrenArray.children);
        return childrenArray;
    }

    private void clearNodes() {
        ChildrenArray childrenArray = this.array.get();
        if (childrenArray != null) {
            childrenArray.clear();
        }
    }

    final void finalizeNodes() {
        ChildrenArray childrenArray = this.array.get();
        if (childrenArray != null) {
            childrenArray.finalizeNodes();
        }
    }

    final void registerChildrenArray(final ChildrenArray childrenArray, boolean bl) {
        boolean bl2 = LOG_GET_ARRAY.isLoggable(Level.FINE);
        if (bl2) {
            LOG_GET_ARRAY.fine("registerChildrenArray: " + childrenArray + " weak: " + bl);
        }
        this.array = bl ? new WeakReference<ChildrenArray>(childrenArray) : new WeakReference<ChildrenArray>(childrenArray){

            @Override
            public ChildrenArray get() {
                return childrenArray;
            }
        };
        childrenArray.pointedBy(this.array);
        if (bl2) {
            LOG_GET_ARRAY.fine("pointed by: " + childrenArray + " to: " + this.array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finalizedChildrenArray(Reference reference) {
        boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
        try {
            PR.enterWriteAccess();
            if (bl) {
                LOG_GET_ARRAY.fine("previous array: " + this.array + " caller: " + reference);
            }
            if (this.array == reference) {
                this.removeNotify();
            }
        }
        finally {
            PR.exitWriteAccess();
        }
    }

    /*
     * WARNING - void declaration
     */
    final Node[] justComputeNodes() {
        void var3_5;
        Object object;
        if (this.map == null) {
            this.map = Collections.synchronizedMap(new HashMap(17));
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Entry entry : this.entries) {
            object = this.findInfo(entry);
            try {
                linkedList.addAll(((Info)object).nodes());
            }
            catch (RuntimeException runtimeException) {
                NodeOp.warning(runtimeException);
            }
        }
        Node[] nodeArray = linkedList.toArray(new Node[linkedList.size()]);
        boolean i = false;
        while (var3_5 < nodeArray.length) {
            object = nodeArray[var3_5];
            ((Node)object).assignTo(this, (int)var3_5);
            ((Node)object).fireParentNodeChange(null, this.parent);
            ++var3_5;
        }
        return nodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info findInfo(Entry entry) {
        java.util.Map<Entry, Info> map = this.map;
        synchronized (map) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                this.map.put(entry, info);
            }
            return info;
        }
    }

    final List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    final void setEntries(Collection<? extends Entry> collection) {
        List<Info> list;
        boolean bl = LOG_GET_ARRAY.isLoggable(Level.FINE);
        ChildrenArray childrenArray = this.array.get();
        if (bl) {
            LOG_GET_ARRAY.fine("setEntries for " + this + " on " + Thread.currentThread());
            LOG_GET_ARRAY.fine("       values: " + collection);
            LOG_GET_ARRAY.fine("       holder: " + childrenArray);
        }
        if (childrenArray == null) {
            this.entries = collection;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet<Entry>(collection));
            }
            return;
        }
        Node[] nodeArray = childrenArray.nodes();
        if (nodeArray == null) {
            this.entries = collection;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet<Entry>(collection));
            }
            return;
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        HashSet<Entry> hashSet = new HashSet<Entry>(this.map.keySet());
        HashSet<? extends Entry> hashSet2 = new HashSet<Entry>(collection);
        hashSet.removeAll(hashSet2);
        if (!hashSet.isEmpty()) {
            this.updateRemove(nodeArray, hashSet);
            nodeArray = childrenArray.nodes();
        }
        if (!(list = this.updateOrder(nodeArray, collection)).isEmpty()) {
            this.updateAdd(list, collection);
        }
    }

    private void checkInfo(Info info, Entry entry, Collection<? extends Entry> collection, java.util.Map<Entry, Info> map) {
        if (info == null) {
            throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " from among " + collection + " in " + map + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
        }
    }

    private void updateRemove(Node[] nodeArray, Set<Entry> set) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Entry entry : set) {
            Info info = this.map.remove(entry);
            this.checkInfo(info, entry, null, this.map);
            linkedList.addAll(info.nodes());
        }
        this.entries.removeAll(set);
        this.clearNodes();
        this.notifyRemove(linkedList, nodeArray);
    }

    Node[] notifyRemove(Collection<Node> collection, Node[] nodeArray) {
        Node[] nodeArray2 = collection.toArray(new Node[collection.size()]);
        if (this.parent == null) {
            return nodeArray2;
        }
        this.parent.fireSubNodesChange(false, nodeArray2, nodeArray);
        for (Node node : collection) {
            node.deassignFrom(this);
            node.fireParentNodeChange(this.parent, null);
        }
        return nodeArray2;
    }

    /*
     * WARNING - void declaration
     */
    private List<Info> updateOrder(Node[] nodeArray, Collection<? extends Entry> collection) {
        void var7_11;
        Object object;
        LinkedList<Info> linkedList = new LinkedList<Info>();
        HashMap<Info, Integer> hashMap = new HashMap<Info, Integer>();
        int n = 0;
        for (Entry entry : this.entries) {
            object = this.map.get(entry);
            this.checkInfo((Info)object, entry, this.entries, this.map);
            hashMap.put((Info)object, n);
            n += ((Info)object).length();
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        int[] nArray = new int[nodeArray.length];
        int n2 = 0;
        boolean n3 = false;
        object = null;
        for (Entry entry : collection) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                linkedList.add(info);
            } else {
                int n4 = info.length();
                if (object == null) {
                    object = new LinkedList();
                }
                object.add(entry);
                Integer n5 = (Integer)hashMap.get(info);
                int n6 = n5;
                if (n2 != n6) {
                    for (int i = 0; i < n4; ++i) {
                        nArray[n6 + i] = 1 + n2 + i;
                    }
                    var7_11 += n4;
                }
            }
            n2 += info.length();
        }
        if (var7_11 > 0) {
            for (int node = 0; node < nArray.length; ++node) {
                if (nArray[node] == 0) {
                    nArray[node] = node;
                    continue;
                }
                int n7 = node;
                nArray[n7] = nArray[n7] - 1;
            }
            this.entries = object;
            this.clearNodes();
            Node node = this.parent;
            if (node != null) {
                node.fireReorderChange(nArray);
            }
        }
        return linkedList;
    }

    private void updateAdd(Collection<Info> collection, Collection<? extends Entry> collection2) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Info info : collection) {
            linkedList.addAll(info.nodes());
            this.map.put(info.entry, info);
        }
        this.entries = collection2;
        this.clearNodes();
        this.notifyAdd(linkedList);
    }

    private void notifyAdd(Collection<Node> collection) {
        Node node2;
        for (Node node2 : collection) {
            node2.assignTo(this, -1);
            node2.fireParentNodeChange(null, this.parent);
        }
        Node[] nodeArray = collection.toArray(new Node[collection.size()]);
        node2 = this.parent;
        if (node2 != null) {
            node2.fireSubNodesChange(true, nodeArray, null);
        }
    }

    final void refreshEntry(Entry entry) {
        Collection<Node> collection;
        ChildrenArray childrenArray = this.array.get();
        if (childrenArray == null) {
            return;
        }
        Node[] nodeArray = childrenArray.nodes();
        if (nodeArray == null) {
            return;
        }
        this.map.keySet().retainAll(new HashSet<Entry>(this.entries));
        Info info = this.map.get(entry);
        if (info == null) {
            return;
        }
        Collection<Node> collection2 = info.nodes();
        if (((Object)collection2).equals(collection = info.entry.nodes())) {
            return;
        }
        HashSet<Node> hashSet = new HashSet<Node>(collection2);
        hashSet.removeAll(collection);
        if (!hashSet.isEmpty()) {
            collection2.removeAll(hashSet);
            this.clearNodes();
            this.notifyRemove(hashSet, nodeArray);
            nodeArray = childrenArray.nodes();
        }
        List<Node> list = this.refreshOrder(entry, collection2, collection);
        info.useNodes(collection);
        if (!list.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(list);
        }
    }

    private List<Node> refreshOrder(Entry entry, Collection<Node> collection, Collection<Node> collection2) {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        int n = 0;
        Iterator<? extends Entry> iterator = this.entries.iterator();
        while (!(object3 = iterator.next()).equals(entry)) {
            object2 = this.findInfo((Entry)object3);
            n += ((Info)object2).length();
        }
        object3 = new HashSet<Node>(collection);
        object2 = new HashSet(object3);
        Node[] nodeArray = new Node[collection.size()];
        Iterator<Node> iterator2 = collection2.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (object3.remove(object)) {
                nodeArray[n2++] = object;
                continue;
            }
            if (!object2.contains(object)) {
                linkedList.add((Node)object);
                continue;
            }
            iterator2.remove();
        }
        object = NodeOp.computePermutation(collection.toArray(new Node[collection.size()]), nodeArray);
        if (object != null) {
            this.clearNodes();
            this.findInfo(entry).useNodes(Arrays.asList(nodeArray));
            Node node = this.parent;
            if (node != null) {
                node.fireReorderChange((int[])object);
            }
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array
    extends Children
    implements Cloneable {
        private Entry nodesEntry = this.createNodesEntry();
        protected Collection<Node> nodes;

        protected Array(Collection<Node> collection) {
            this();
            this.nodes = collection;
        }

        public Array() {
            this.setEntries(Collections.singleton(this.getNodesEntry()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object clone() {
            try {
                Array array = (Array)super.clone();
                try {
                    PR.enterReadAccess();
                    if (this.nodes != null) {
                        array.nodes = array.initCollection();
                        array.nodes.clear();
                        for (Node node : this.nodes) {
                            array.nodes.add(node.cloneNode());
                        }
                    }
                }
                finally {
                    PR.exitReadAccess();
                }
                return array;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        protected Collection<Node> initCollection() {
            return new ArrayList<Node>();
        }

        final void refreshImpl() {
            if (this.isInitialized()) {
                this.refreshEntry(this.getNodesEntry());
                ((Children)this).getArray(null).nodes();
            } else if (this.nodes != null) {
                for (Node node : this.nodes) {
                    node.assignTo(this, -1);
                }
            }
        }

        protected final void refresh() {
            MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    Array.this.refreshImpl();
                }
            });
        }

        final Entry getNodesEntry() {
            return this.nodesEntry;
        }

        Entry createNodesEntry() {
            return new AE();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection<Node> getCollection() {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (this.nodes == null) {
                    this.nodes = this.initCollection();
                }
            }
            return this.nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Node[] nodeArray) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().addAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Node[] nodeArray) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().removeAll(Arrays.asList(nodeArray))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class AE
        implements Entry {
            AE() {
            }

            @Override
            public Collection<Node> nodes() {
                Collection<Node> collection = Array.this.getCollection();
                if (collection.isEmpty()) {
                    return Collections.emptyList();
                }
                return new ArrayList<Node>(collection);
            }

            public String toString() {
                return "Children.Array.AE" + Array.this.getCollection();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Dupl<T>
    implements Cloneable,
    Entry {
        protected Object key;

        Dupl() {
        }

        public final void updateList(Collection<? extends T> collection, Collection<? super Dupl<T>> collection2) {
            HashMap hashMap = new HashMap(collection.size() * 2);
            for (T t : collection) {
                this.updateListAndMap(t, collection2, hashMap);
            }
        }

        public final void updateList(T[] TArray, Collection<? super Dupl<T>> collection) {
            HashMap hashMap = new HashMap(TArray.length * 2);
            for (T t : TArray) {
                this.updateListAndMap(t, collection, hashMap);
            }
        }

        public final void updateListAndMap(T t, Collection<? super Dupl<T>> collection, java.util.Map<T, Object> map) {
            Object object = map.put(t, this);
            if (object == null) {
                collection.add(this.createInstance(t, 0));
                return;
            }
            if (object == this) {
                map.put(t, 1);
                collection.add(this.createInstance(t, 1));
                return;
            }
            int n = (Integer)object + 1;
            map.put(t, n);
            collection.add(this.createInstance(t, n));
        }

        public final T getKey() {
            if (this.key instanceof Dupl) {
                return ((Dupl)this.key).getKey();
            }
            return (T)this.key;
        }

        public final int getCnt() {
            int n = 0;
            Dupl dupl = this;
            while (dupl.key instanceof Dupl) {
                dupl = (Dupl)dupl.key;
                ++n;
            }
            return n;
        }

        private final Dupl<T> createInstance(Object object, int n) {
            try {
                Dupl dupl;
                Dupl dupl2 = dupl = (Dupl)this.clone();
                while (n-- > 0) {
                    Dupl dupl3 = (Dupl)this.clone();
                    dupl.key = dupl3;
                    dupl = dupl3;
                }
                dupl.key = object;
                return dupl2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Dupl) {
                Dupl dupl = (Dupl)object;
                return this.getKey().equals(dupl.getKey()) && this.getCnt() == dupl.getCnt();
            }
            return false;
        }
    }

    private static final class Empty
    extends Children {
        Empty() {
        }

        public boolean add(Node[] nodeArray) {
            return false;
        }

        public boolean remove(Node[] nodeArray) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Entry {
        public Collection<Node> nodes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Info {
        int length;
        final Entry entry;

        public Info(Entry entry) {
            this.entry = entry;
        }

        protected void finalize() {
            Children.this.finalizeNodes();
        }

        public Collection<Node> nodes() {
            ChildrenArray childrenArray = Children.this.getArray(null);
            return childrenArray.nodesFor(this);
        }

        public void useNodes(Collection<Node> collection) {
            ChildrenArray childrenArray = Children.this.getArray(null);
            childrenArray.useNodes(this, collection);
            for (Node node : collection) {
                node.assignTo(Children.this, -1);
                node.fireParentNodeChange(null, Children.this.parent);
            }
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return "Children.Info[" + this.entry + ",length=" + this.length + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Keys<T>
    extends Array {
        private static java.util.Map<Keys<?>, Runnable> lastRuns = new HashMap(11);
        private boolean before;

        @Override
        public Object clone() {
            Keys keys = (Keys)super.clone();
            return keys;
        }

        @Override
        @Deprecated
        public boolean add(Node[] nodeArray) {
            return super.add(nodeArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean remove(Node[] nodeArray) {
            try {
                PR.enterWriteAccess();
                if (this.nodes != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (this.nodes.contains(nodeArray[i])) continue;
                        nodeArray[i] = null;
                    }
                    super.remove(nodeArray);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            return true;
        }

        protected final void refreshKey(final T t) {
            MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    Keys.this.refreshEntry(new KE(t));
                }
            });
        }

        protected final void setKeys(Collection<? extends T> collection) {
            ArrayList<Object> arrayList;
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int n = collection.size();
            if (bl && n < 10) {
                arrayList = new ArrayList<T>(collection);
                for (int i = 0; i < n - 1; ++i) {
                    Object e = arrayList.get(i);
                    for (int j = i + 1; j < n; ++j) {
                        Object e2 = arrayList.get(j);
                        assert (!e.equals(e2) || e.hashCode() == e2.hashCode()) : "bad equals/hashCode in " + e + " vs. " + e2;
                    }
                }
            }
            arrayList = new ArrayList(collection.size() + 1);
            if (this.before) {
                arrayList.add(this.getNodesEntry());
            }
            KE kE = new KE();
            kE.updateList(collection, arrayList);
            if (!this.before) {
                arrayList.add(this.getNodesEntry());
            }
            this.applyKeys(arrayList);
        }

        protected final void setKeys(T[] TArray) {
            KE kE;
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            int n = TArray.length;
            if (bl && n < 10) {
                for (int i = 0; i < n - 1; ++i) {
                    kE = TArray[i];
                    for (int j = i + 1; j < n; ++j) {
                        T t = TArray[j];
                        assert (!((Object)kE).equals(t) || ((Object)kE).hashCode() == t.hashCode()) : "bad equals/hashCode in " + kE + " vs. " + t;
                    }
                }
            }
            ArrayList<Entry> arrayList = new ArrayList<Entry>(TArray.length + 1);
            kE = new KE();
            if (this.before) {
                arrayList.add(this.getNodesEntry());
            }
            kE.updateList(TArray, arrayList);
            if (!this.before) {
                arrayList.add(this.getNodesEntry());
            }
            this.applyKeys(arrayList);
        }

        private void applyKeys(final List<? extends Entry> list) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (Keys.keysCheck(Keys.this, this)) {
                        Keys.this.setEntries(list);
                        Keys.keysExit(Keys.this, this);
                    }
                }
            };
            Keys.keysEnter(this, runnable);
            MUTEX.postWriteRequest(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setBefore(boolean bl) {
            try {
                PR.enterWriteAccess();
                if (this.before != bl) {
                    List<Entry> list = this.getEntries();
                    list.remove(this.getNodesEntry());
                    this.before = bl;
                    if (bl) {
                        list.add(0, this.getNodesEntry());
                    } else {
                        list.add(this.getNodesEntry());
                    }
                    this.setEntries(list);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected abstract Node[] createNodes(T var1);

        protected void destroyNodes(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i].fireNodeDestroyed();
            }
        }

        @Override
        Node[] notifyRemove(Collection<Node> collection, Node[] nodeArray) {
            Node[] nodeArray2 = super.notifyRemove(collection, nodeArray);
            this.destroyNodes(nodeArray2);
            return nodeArray2;
        }

        private static synchronized void keysEnter(Keys<?> keys, Runnable runnable) {
            lastRuns.put(keys, runnable);
        }

        private static synchronized void keysExit(Keys keys, Runnable runnable) {
            Runnable runnable2 = lastRuns.remove(keys);
            if (runnable2 != null && !runnable2.equals(runnable)) {
                lastRuns.put(keys, runnable2);
            }
        }

        private static synchronized boolean keysCheck(Keys keys, Runnable runnable) {
            return runnable == lastRuns.get(keys);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KE
        extends Dupl<T> {
            public KE() {
            }

            public KE(T t) {
                this.key = t;
            }

            @Override
            public Collection<Node> nodes() {
                Node[] nodeArray = Keys.this.createNodes(this.getKey());
                if (nodeArray == null) {
                    return Collections.emptyList();
                }
                return new LinkedList<Node>(Arrays.asList(nodeArray));
            }

            public String toString() {
                String string = this.getKey().toString();
                if (string.length() > 80) {
                    string = string.substring(0, 80);
                }
                return "Children.Keys.KE[" + string + "," + this.getCnt() + "]";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map<T>
    extends Children {
        protected java.util.Map<T, Node> nodes;

        protected Map(java.util.Map<T, Node> map) {
            this.nodes = map;
        }

        public Map() {
        }

        final java.util.Map<T, Node> getMap() {
            if (this.nodes == null) {
                this.nodes = this.initMap();
            }
            return this.nodes;
        }

        @Override
        final void callAddNotify() {
            this.setEntries(this.createEntries(this.getMap()));
            super.callAddNotify();
        }

        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            LinkedList<ME> linkedList = new LinkedList<ME>();
            for (Map.Entry<T, Node> entry : map.entrySet()) {
                linkedList.add(new ME(entry.getKey(), entry.getValue()));
            }
            return linkedList;
        }

        final void refreshImpl() {
            this.setEntries(this.createEntries(this.getMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refresh() {
            try {
                PR.enterWriteAccess();
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        final void refreshKeyImpl(T t) {
            this.refreshEntry(new ME(t, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refreshKey(T t) {
            try {
                PR.enterWriteAccess();
                this.refreshKeyImpl(t);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void putAll(java.util.Map<? extends T, ? extends Node> map) {
            try {
                PR.enterWriteAccess();
                this.nodes.putAll(map);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void put(T t, Node node) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.put(t, node) != null) {
                    this.refreshKeyImpl(t);
                } else {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void removeAll(Collection<? extends T> collection) {
            try {
                PR.enterWriteAccess();
                this.nodes.keySet().removeAll(collection);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(T t) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.remove(t) != null) {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected java.util.Map<T, Node> initMap() {
            return new HashMap(7);
        }

        @Override
        public boolean add(Node[] nodeArray) {
            return false;
        }

        @Override
        public boolean remove(Node[] nodeArray) {
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class ME
        implements Entry {
            public Object key;
            public Node node;

            public ME(Object object, Node node) {
                this.key = object;
                this.node = node;
            }

            @Override
            public Collection<Node> nodes() {
                return Collections.singleton(this.node);
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof ME) {
                    ME mE = (ME)object;
                    return this.key.equals(mE.key);
                }
                return false;
            }

            public String toString() {
                return "Key (" + this.key + ")";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortedArray
    extends Array {
        private Comparator<? super Node> comp;

        public SortedArray() {
        }

        protected SortedArray(Collection<Node> collection) {
            super(collection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Entry createNodesEntry() {
            return new SAE();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class SAE
        implements Entry {
            @Override
            public Collection<Node> nodes() {
                ArrayList<Node> arrayList = new ArrayList<Node>(SortedArray.this.getCollection());
                Collections.sort(arrayList, SortedArray.this.comp);
                return arrayList;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortedMap<T>
    extends Map<T> {
        private Comparator<? super Node> comp;

        public SortedMap() {
        }

        protected SortedMap(java.util.Map<T, Node> map) {
            super(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator<? super Node> comparator) {
            try {
                PR.enterWriteAccess();
                this.comp = comparator;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator<? super Node> getComparator() {
            return this.comp;
        }

        @Override
        Collection<? extends Entry> createEntries(java.util.Map<T, Node> map) {
            TreeSet<Map.ME> treeSet = new TreeSet<Map.ME>(new SMComparator());
            for (Map.Entry<T, Node> entry : map.entrySet()) {
                treeSet.add(new Map.ME(entry.getKey(), entry.getValue()));
            }
            return treeSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class SMComparator
        implements Comparator<Map.ME> {
            SMComparator() {
            }

            @Override
            public int compare(Map.ME mE, Map.ME mE2) {
                Comparator comparator = SortedMap.this.comp;
                if (comparator == null) {
                    int n = ((Comparable)mE.key).compareTo(mE2.key);
                    return n;
                }
                return comparator.compare(mE.node, mE2.node);
            }
        }
    }
}

