/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private PresentableFileEntry entry;

    public FileEntryNode(PresentableFileEntry presentableFileEntry, Children children) {
        super(children);
        this.entry = presentableFileEntry;
        PropL propL = new PropL();
        presentableFileEntry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propL, (Object)((Object)presentableFileEntry)));
        presentableFileEntry.getDataObject().addPropertyChangeListener((PropertyChangeListener)propL);
        super.setName(presentableFileEntry.getName());
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage(FileEntryNode.class, (String)string);
    }

    public PresentableFileEntry getFileEntry() {
        return this.entry;
    }

    public boolean canDestroy() {
        return this.entry.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        this.entry.delete();
        super.destroy();
    }

    public final boolean canCopy() {
        return this.entry.isCopyAllowed();
    }

    public final boolean canCut() {
        return this.entry.isMoveAllowed();
    }

    public void setName(String string) {
        try {
            this.entry.renameEntry(string);
            super.setName(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
    }

    public SystemAction getDefaultAction() {
        if (this.entry.isTemplate()) {
            return null;
        }
        Action action = this.getPreferredAction();
        if (action instanceof SystemAction) {
            return (SystemAction)action;
        }
        return null;
    }

    public Action getPreferredAction() {
        if (this.entry.isTemplate()) {
            return null;
        }
        return super.getPreferredAction();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        T t = this.entry.getCookie(clazz);
        if (t != null) {
            return t;
        }
        return (T)super.getCookie(clazz);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>("name", String.class, this.getBundleString("PROP_name"), this.getBundleString("HINT_name")){

            public String getValue() {
                return FileEntryNode.this.entry.getName();
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                FileEntryNode.this.setName(string);
            }

            public boolean canWrite() {
                return FileEntryNode.this.entry.isRenameAllowed();
            }
        };
        readWrite.setName("name");
        set.put((Node.Property)readWrite);
        try {
            readWrite = new PropertySupport.Reflection((Object)this.entry, Boolean.TYPE, "isTemplate", "setTemplate");
            readWrite.setName("template");
            readWrite.setDisplayName(this.getBundleString("PROP_template"));
            readWrite.setShortDescription(this.getBundleString("HINT_template"));
            set.put((Node.Property)readWrite);
        }
        catch (Exception exception) {
            throw new IllegalStateException();
        }
        return sheet;
    }

    void fireChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("cookie")) {
            this.fireCookieChange();
            return;
        }
        this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (string.equals("name")) {
            super.setName(this.entry.getName());
        }
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FileEntryNode.this.fireChange(propertyChangeEvent);
        }
    }
}

