/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;

public final class PropertiesDataLoader
extends MultiFileLoader {
    static final String PROPERTIES_EXTENSION = "properties";
    public static final char PRB_SEPARATOR_CHAR = '_';
    static final long serialVersionUID = 4384899552891479449L;
    public static final String PROP_EXTENSIONS = "extensions";

    public PropertiesDataLoader() {
        super("org.netbeans.modules.properties.PropertiesDataObject");
        ExtensionList extensionList = new ExtensionList();
        extensionList.addExtension(PROPERTIES_EXTENSION);
        extensionList.addExtension("impl");
        this.setExtensions(extensionList);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(PropertiesDataLoader.class, (String)"PROP_PropertiesLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-properties/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws IOException {
        return new PropertiesDataObject(fileObject, this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getExt().equalsIgnoreCase(PROPERTIES_EXTENSION)) {
            String string = fileObject.getName();
            int n = string.indexOf(95);
            while (n != -1) {
                FileObject fileObject2 = fileObject.getParent().getFileObject(string.substring(0, n), fileObject.getExt());
                if (fileObject2 != null) {
                    return fileObject2;
                }
                n = string.indexOf(95, n + 1);
            }
            return fileObject;
        }
        return this.getExtensions().isRegistered(fileObject) ? fileObject : null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new PropertiesFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new PropertiesFileEntry(multiDataObject, fileObject);
    }

    public void setExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_EXTENSIONS, extensionList, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        SafeException safeException;
        try {
            super.readExternal(objectInput);
            safeException = null;
        }
        catch (SafeException safeException2) {
            safeException = safeException2;
        }
        this.setExtensions((ExtensionList)objectInput.readObject());
        if (safeException != null) {
            throw safeException;
        }
    }
}

