/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map<Project, Reference<AntProjectHelper>> project2Helper;
    private static final Map<AntProjectHelper, Reference<Project>> helper2Project;
    private static final Map<AntBasedProjectType, List<Reference<AntProjectHelper>>> type2Projects;
    private static final Lookup.Result<AntBasedProjectType> antBasedProjectTypes;
    private static Map<String, AntBasedProjectType> antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;

    private static void antBasedProjectTypesRemoved(Set<AntBasedProjectType> set) {
        for (AntBasedProjectType antBasedProjectType : set) {
            List<Reference<AntProjectHelper>> list = type2Projects.get(antBasedProjectType);
            if (list != null) {
                for (Reference<AntProjectHelper> reference : list) {
                    AntProjectHelper antProjectHelper = reference.get();
                    if (antProjectHelper == null) continue;
                    antProjectHelper.notifyDeleted();
                }
            }
            type2Projects.remove(antBasedProjectType);
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String string) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, AntBasedProjectType>();
            for (AntBasedProjectType antBasedProjectType : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(antBasedProjectType.getType(), antBasedProjectType);
            }
        }
        return antBasedProjectTypesByType.get(string);
    }

    public boolean isProject(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return false;
        }
        File file2 = new File(new File(file, "nbproject"), "project.xml");
        return file2.isFile();
    }

    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        Document document;
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_XML_PATH);
        if (fileObject2 == null || !fileObject2.isData() || fileObject2.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        try {
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)file.getAbsolutePath(), (Object)sAXException.getMessage()));
            throw iOException;
        }
        Element element = document.getDocumentElement();
        if (!"project".equals(element.getLocalName()) || !PROJECT_NS.equals(element.getNamespaceURI())) {
            return null;
        }
        Element element2 = Util.findElement(element, "type", PROJECT_NS);
        if (element2 == null) {
            return null;
        }
        String string = Util.findText(element2);
        if (string == null) {
            return null;
        }
        AntBasedProjectType antBasedProjectType = AntBasedProjectFactorySingleton.findAntBasedProjectType(string);
        if (antBasedProjectType == null) {
            return null;
        }
        AntProjectHelper antProjectHelper = HELPER_CALLBACK.createHelper(fileObject, document, projectState, antBasedProjectType);
        Project project = antBasedProjectType.createProject(antProjectHelper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(antProjectHelper));
        helper2Project.put(antProjectHelper, new WeakReference<Project>(project));
        List<Reference<AntProjectHelper>> list = type2Projects.get(antBasedProjectType);
        if (list == null) {
            list = new ArrayList<Reference<AntProjectHelper>>();
            type2Projects.put(antBasedProjectType, list);
        }
        list.add(new WeakReference<AntProjectHelper>(antProjectHelper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<AntProjectHelper> reference = project2Helper.get(project);
        if (reference == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        AntProjectHelper antProjectHelper = reference.get();
        assert (antProjectHelper != null) : "AntProjectHelper collected for " + project;
        HELPER_CALLBACK.save(antProjectHelper);
    }

    public static Project getProjectFor(AntProjectHelper antProjectHelper) {
        Reference<Project> reference = helper2Project.get(antProjectHelper);
        assert (reference != null) : "Found a Project reference for " + antProjectHelper;
        Project project = reference.get();
        assert (project != null) : "Found a non-null Project for " + antProjectHelper;
        return project;
    }

    public static AntProjectHelper getHelperFor(Project project) {
        Reference<AntProjectHelper> reference = project2Helper.get(project);
        return reference != null ? reference.get() : null;
    }

    static {
        block3: {
            project2Helper = new WeakHashMap<Project, Reference<AntProjectHelper>>();
            helper2Project = new WeakHashMap<AntProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<AntBasedProjectType, List<Reference<AntProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class<AntBasedProjectFactorySingleton> clazz = AntBasedProjectFactorySingleton.class;
                    synchronized (AntBasedProjectFactorySingleton.class) {
                        Set set = type2Projects.keySet();
                        HashSet hashSet = new HashSet(set);
                        hashSet.removeAll(antBasedProjectTypes.allInstances());
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(hashSet);
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<AntProjectHelper> clazz = AntProjectHelper.class;
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

