/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathMatcher {
    private final String includes;
    private final String excludes;
    private final Pattern includePattern;
    private final Pattern excludePattern;
    private final File base;
    private final Set<String> knownIncludes;

    public PathMatcher(String string, String string2, File file) {
        this.includes = string;
        this.excludes = string2;
        this.includePattern = this.computePattern(string);
        this.excludePattern = this.computePattern(string2);
        this.base = file;
        this.knownIncludes = this.computeKnownIncludes();
    }

    private Pattern computePattern(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (!stringTokenizer.hasMoreTokens()) {
            return Pattern.compile("<cannot match>");
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().replace('\\', '/');
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            if (string2.endsWith("/")) {
                string2 = string2 + "**";
            }
            if (string2.equals("**")) {
                stringBuilder.append(".*");
                break;
            }
            Matcher matcher = Pattern.compile("/\\*\\*/|/\\*\\*|\\*\\*/|\\*|/|[^*/]+").matcher(string2);
            while (matcher.find()) {
                String string3 = matcher.group();
                if (string3.equals("/**")) {
                    stringBuilder.append("/.*");
                    continue;
                }
                if (string3.equals("**/")) {
                    stringBuilder.append("(.*/|)");
                    continue;
                }
                if (string3.equals("/**/")) {
                    stringBuilder.append("(/.*/|/)");
                    continue;
                }
                if (string3.equals("*")) {
                    stringBuilder.append("[^/]*");
                    continue;
                }
                stringBuilder.append(Pattern.quote(string3));
            }
        }
        string2 = stringBuilder.toString();
        return Pattern.compile(string2);
    }

    public boolean matches(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.excludePattern != null && this.excludePattern.matcher(string).matches()) {
            return false;
        }
        if (this.includePattern != null) {
            if (this.includePattern.matcher(string).matches()) {
                return true;
            }
            if (bl && (string.length() == 0 || string.endsWith("/"))) {
                for (String string2 : this.knownIncludes) {
                    if (!string2.startsWith(string)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Set<File> findIncludedRoots() throws IllegalArgumentException {
        if (this.includes == null) {
            return Collections.singleton(this.base);
        }
        HashSet<File> hashSet = new HashSet<File>();
        if (this.base != null) {
            for (String string : this.knownIncludes) {
                hashSet.add(new File(this.base, string.replace('/', File.separatorChar)));
            }
        }
        return hashSet;
    }

    private Set<String> computeKnownIncludes() {
        Object object;
        if (this.includes == null) {
            return Collections.emptySet();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.includes, ", ");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().replace('\\', '/').replaceFirst("/\\*\\*$", "/");
            if (((String)object).equals("**")) {
                treeSet.add("");
                continue;
            }
            if (((String)object).indexOf(42) == -1 && ((String)object).endsWith("/")) {
                String string;
                if (this.excludePattern != null && this.excludePattern.matcher((CharSequence)object).matches() || this.includePattern.matcher(string = ((String)object).substring(0, ((String)object).lastIndexOf(47, ((String)object).length() - 2) + 1)).matches()) continue;
                treeSet.add((String)object);
                continue;
            }
            if (this.base == null) continue;
            bl = true;
        }
        if (this.base != null && this.base.isDirectory()) {
            object = treeSet.iterator();
            while (object.hasNext()) {
                if (new File(this.base, ((String)object.next()).replace('/', File.separatorChar)).isDirectory()) continue;
                object.remove();
            }
        }
        if (bl) {
            this.findMatches(this.base, "", treeSet);
        }
        return treeSet;
    }

    private void findMatches(File file, String string, Set<String> set) {
        assert (string.length() == 0 || string.endsWith("/"));
        assert (this.includes != null);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            boolean bl = file2.isDirectory();
            String string3 = string + string2;
            if (bl) {
                string3 = string3 + "/";
            }
            if (this.excludePattern != null && this.excludePattern.matcher(string3).matches()) continue;
            if (this.includePattern.matcher(string3).matches()) {
                if (bl) {
                    set.add(string3);
                    continue;
                }
                set.add(string);
                continue;
            }
            if (!bl) continue;
            this.findMatches(file2, string3, set);
        }
    }

    public String toString() {
        return "PathMatcher[includes=" + this.includes + ",excludes=" + this.excludes + "]";
    }
}

