/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModeImpl
implements Mode {
    private static final String MODE_ANONYMOUS_NAME = "anonymousMode";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final boolean DEBUG = Debug.isLoggable(ModeImpl.class);

    private ModeImpl(String string, int n, int n2, boolean bl) {
        ModeImpl.getCentral().createModeModel(this, string, n, n2, bl);
    }

    public static ModeImpl createModeImpl(String string, int n, int n2, boolean bl) {
        return new ModeImpl(string, n, n2, bl);
    }

    public String getName() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ModeImpl.getCentral().getModeName(this);
    }

    public String getDisplayName() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getName();
    }

    public Image getIcon() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return null;
    }

    public boolean canDock(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return true;
    }

    public boolean dockInto(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.dockIntoImpl(topComponent, true);
    }

    public void setBounds(Rectangle rectangle) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl.getCentral().setModeBounds(this, rectangle);
    }

    public Rectangle getBounds() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ModeImpl.getCentral().getModeBounds(this);
    }

    public Workspace getWorkspace() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return WindowManagerImpl.getInstance();
    }

    public TopComponent[] getTopComponents() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ModeImpl.getCentral().getModeTopComponents(this).toArray(new TopComponent[0]);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean dockIntoImpl(TopComponent topComponent, boolean bl) {
        ModeImpl modeImpl;
        if (DEBUG) {
            Debug.log(ModeImpl.class, "Docking tc=" + topComponent.getName() + " into mode=" + this);
            Debug.dumpStack(ModeImpl.class);
        }
        if ((modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent)) != null && modeImpl != this) {
            modeImpl.removeTopComponent(topComponent);
        }
        this.addClosedTopComponent(topComponent);
        return true;
    }

    public void close(TopComponent topComponent) {
        if (!this.getOpenedTopComponents().contains(topComponent)) {
            return;
        }
        if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(topComponent)) {
            this.addClosedTopComponent(topComponent);
        } else {
            this.removeTopComponent(topComponent);
        }
    }

    public List<TopComponent> getOpenedTopComponents() {
        return ModeImpl.getCentral().getModeOpenedTopComponents(this);
    }

    public void setSelectedTopComponent(TopComponent topComponent) {
        if (!this.getOpenedTopComponents().contains(topComponent)) {
            return;
        }
        TopComponent topComponent2 = this.getSelectedTopComponent();
        if (topComponent == topComponent2) {
            return;
        }
        ModeImpl.getCentral().setModeSelectedTopComponent(this, topComponent);
    }

    public TopComponent getSelectedTopComponent() {
        WindowManagerImpl.assertEventDispatchThread();
        return ModeImpl.getCentral().getModeSelectedTopComponent(this);
    }

    public void setPreviousSelectedTopComponent(TopComponent topComponent) {
        TopComponent topComponent2 = this.getPreviousSelectedTopComponent();
        if (topComponent == topComponent2) {
            return;
        }
        ModeImpl.getCentral().setModePreviousSelectedTopComponent(this, topComponent);
    }

    public TopComponent getPreviousSelectedTopComponent() {
        WindowManagerImpl.assertEventDispatchThread();
        return ModeImpl.getCentral().getModePreviousSelectedTopComponent(this);
    }

    public void addOpenedTopComponent(TopComponent topComponent) {
        ModeImpl.getCentral().addModeOpenedTopComponent(this, topComponent);
    }

    public void addOpenedTopComponent(TopComponent topComponent, int n) {
        ModeImpl.getCentral().insertModeOpenedTopComponent(this, topComponent, n);
    }

    public void addClosedTopComponent(TopComponent topComponent) {
        ModeImpl.getCentral().addModeClosedTopComponent(this, topComponent);
    }

    public void addUnloadedTopComponent(String string) {
        ModeImpl.getCentral().addModeUnloadedTopComponent(this, string);
    }

    public void setUnloadedSelectedTopComponent(String string) {
        ModeImpl.getCentral().setUnloadedSelectedTopComponent(this, string);
    }

    public void setUnloadedPreviousSelectedTopComponent(String string) {
        ModeImpl.getCentral().setUnloadedPreviousSelectedTopComponent(this, string);
    }

    public List<String> getOpenedTopComponentsIDs() {
        return ModeImpl.getCentral().getModeOpenedTopComponentsIDs(this);
    }

    public List getClosedTopComponentsIDs() {
        return ModeImpl.getCentral().getModeClosedTopComponentsIDs(this);
    }

    public List getTopComponentsIDs() {
        return ModeImpl.getCentral().getModeTopComponentsIDs(this);
    }

    public void setFrameState(int n) {
        ModeImpl.getCentral().setModeFrameState(this, n);
    }

    public int getFrameState() {
        return ModeImpl.getCentral().getModeFrameState(this);
    }

    public boolean isPermanent() {
        return ModeImpl.getCentral().isModePermanent(this);
    }

    public boolean isEmpty() {
        return ModeImpl.getCentral().isModeEmpty(this);
    }

    public boolean containsTopComponent(TopComponent topComponent) {
        return ModeImpl.getCentral().containsModeTopComponent(this, topComponent);
    }

    public int getState() {
        return ModeImpl.getCentral().getModeState(this);
    }

    public int getKind() {
        return ModeImpl.getCentral().getModeKind(this);
    }

    public String getSide() {
        return ModeImpl.getCentral().getModeSide(this);
    }

    public void setConstraints(SplitConstraint[] splitConstraintArray) {
        WindowManagerImpl.getInstance().setModeConstraints(this, splitConstraintArray);
    }

    public SplitConstraint[] getConstraints() {
        return WindowManagerImpl.getInstance().getModeConstraints(this);
    }

    public void removeTopComponent(TopComponent topComponent) {
        ModeImpl.getCentral().removeModeTopComponent(this, topComponent);
    }

    public void removeTopComponents(Set set) {
        for (TopComponent topComponent : set) {
            this.removeTopComponent(topComponent);
        }
    }

    public void removeClosedTopComponentID(String string) {
        ModeImpl.getCentral().removeModeClosedTopComponentID(this, string);
    }

    public boolean canContain(TopComponent topComponent) {
        int n;
        if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
            return true;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (modeImpl == null) {
            return true;
        }
        int n2 = this.getKind();
        return n2 == (n = modeImpl.getKind()) || n2 != 1 && n != 1;
    }

    void doFirePropertyChange(final String string, final Object object, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.firePropertyChange(string, object, object2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.changeSupport.firePropertyChange(string, object, object2);
                }
            });
        }
    }

    public String toString() {
        return super.toString() + "[" + ModeImpl.getCentral().getModeName(this) + "]";
    }

    private static Central getCentral() {
        return WindowManagerImpl.getInstance().getCentral();
    }

    static String getUnusedModeName() {
        String string;
        String string2 = MODE_ANONYMOUS_NAME;
        if (string2.length() > 20) {
            string2 = string2.substring(0, 20);
        }
        int n = 1;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        while (windowManagerImpl.findMode(string = string2 + "_" + n) != null) {
            ++n;
        }
        return string;
    }
}

