/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloseAllButThisAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private TopComponent tc;

    public CloseAllButThisAction() {
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public CloseAllButThisAction(TopComponent topComponent) {
        this.tc = topComponent;
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"LBL_CloseAllButThisAction"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this.tc;
        if (topComponent == null) {
            topComponent = TopComponent.getRegistry().getActivated();
        }
        if (topComponent != null) {
            ActionUtils.closeAllExcept(topComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseAllButThis", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseAllButThis");
        }
        return super.getValue(string);
    }

    public void run() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        this.setEnabled(topComponent instanceof TopComponent.Cloneable && modeImpl != null && modeImpl.getKind() == 1);
    }
}

