/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.services.ActionPasteType;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolbarFolderNode
extends DataFolder.FolderNode
implements PropertyChangeListener {
    static SystemAction[] topStaticActions;
    private DataFolder folder;

    public ToolbarFolderNode() {
        this(NbPlaces.getDefault().toolbars());
    }

    ToolbarFolderNode(DataFolder dataFolder) {
        DataFolder dataFolder2 = dataFolder;
        dataFolder2.getClass();
        super(dataFolder2, (Children)new ToolbarFolderChildren(dataFolder));
        this.folder = dataFolder;
        super.setShortDescription(NbBundle.getBundle(ToolbarFolderNode.class).getString("CTL_Toolbars_hint"));
        this.setIconBaseWithExtension("org/netbeans/core/resources/toolbars.gif");
        ToolbarPool.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ToolbarPool.getDefault()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolbarFolderNode.class);
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        PasteType pasteType = ActionPasteType.getPasteType((DataFolder)this.getDataObject(), transferable);
        if (pasteType != null) {
            list.add(pasteType);
        }
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public String getName() {
                return NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_newToolbarName");
            }

            public void create() throws IOException {
                ToolbarFolderNode.this.newToolbar();
            }
        }};
    }

    void newToolbar() {
        String string;
        ResourceBundle resourceBundle = NbBundle.getBundle(ToolbarFolderNode.class);
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(resourceBundle.getString("PROP_newToolbarLabel"), resourceBundle.getString("PROP_newToolbarDialog"));
        inputLine.setInputText(resourceBundle.getString("PROP_newToolbar"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (object == NotifyDescriptor.OK_OPTION && !(string = inputLine.getInputText()).equals("")) {
            FileObject fileObject = this.folder.getPrimaryFile();
            try {
                FileObject fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    String string2 = this.getLastName();
                    fileObject2 = fileObject.createFolder(string);
                    if (string2 != null) {
                        fileObject.setAttribute(string2 + "/" + fileObject2.getNameExt(), (Object)Boolean.TRUE);
                    }
                } else {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(resourceBundle.getString("MSG_ToolbarExists"), string));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private String getLastName() {
        Node node;
        DataObject dataObject;
        String string = null;
        Node[] nodeArray = this.getChildren().getNodes();
        if (nodeArray.length > 0 && (dataObject = (DataObject)(node = nodeArray[nodeArray.length - 1]).getCookie(DataObject.class)) != null) {
            string = dataObject.getPrimaryFile().getNameExt();
        }
        return string;
    }

    public Action[] getActions(boolean bl) {
        if (topStaticActions == null) {
            topStaticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }
        return topStaticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[0];
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("configuration".equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange("configuration", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    static final class ToolbarFolderChildren
    extends FilterNode.Children {
        public ToolbarFolderChildren(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder != null) {
                return new ToolbarNode(dataFolder);
            }
            if (node.getCookie(InstanceDataObject.class) != null) {
                return new ToolbarItemNode(node);
            }
            return node.cloneNode();
        }

        protected Node[] createNodes(Node node) {
            Node[] nodeArray = super.createNodes(node);
            if (nodeArray.length == 1) {
                InstanceCookie instanceCookie = (InstanceCookie)nodeArray[0].getCookie(InstanceCookie.class);
                boolean bl = false;
                if (instanceCookie != null) {
                    if (instanceCookie instanceof InstanceCookie.Of) {
                        bl = ((InstanceCookie.Of)instanceCookie).instanceOf(ToolbarConfiguration.class);
                    } else {
                        try {
                            if (instanceCookie.instanceClass().equals(ToolbarConfiguration.class)) {
                                bl = true;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (bl) {
                    nodeArray = new Node[]{};
                }
            }
            return nodeArray;
        }
    }

    static final class ToolbarItemNode
    extends FilterNode {
        static SystemAction[] staticActions;
        static SystemAction[] separatorStaticActions;

        ToolbarItemNode(Node node) {
            super(node, FilterNode.Children.LEAF);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return this == object || this.getOriginal().equals(object) || object.equals(this.getOriginal());
        }

        public SystemAction[] getActions() {
            InstanceCookie.Of of = (InstanceCookie.Of)this.getCookie(InstanceCookie.Of.class);
            if (of != null && of.instanceOf(JSeparator.class)) {
                if (null == separatorStaticActions) {
                    separatorStaticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
                }
                return separatorStaticActions;
            }
            if (staticActions == null) {
                staticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return staticActions;
        }

        public boolean canRename() {
            return false;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolbarNode
    extends DataFolder.FolderNode
    implements PropertyChangeListener {
        static SystemAction[] staticActions;
        private DataFolder folder;
        private PropertyChangeListener wlpc;

        ToolbarNode(DataFolder dataFolder) {
            DataFolder dataFolder2 = dataFolder;
            dataFolder2.getClass();
            super(dataFolder2, (Children)new ToolbarFolderChildren(dataFolder));
            this.folder = dataFolder;
            super.setName(dataFolder.getName());
            super.setShortDescription(NbBundle.getBundle(ToolbarFolderNode.class).getString("CTL_Toolbars_hint"));
            this.setIconBaseWithExtension("org/netbeans/core/resources/toolbars.gif");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolbarPool toolbarPool = ToolbarPool.getDefault();
                    toolbarPool.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)ToolbarNode.this, (Object)toolbarPool));
                }
            });
            this.attachConfigListener();
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            PasteType pasteType = ActionPasteType.getPasteType((DataFolder)this.getDataObject(), transferable);
            if (pasteType != null) {
                list.add(pasteType);
            }
        }

        public NewType[] getNewTypes() {
            return new NewType[]{new NewType(){

                public String getName() {
                    return NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_newToolbarSeparator");
                }

                public void create() throws IOException {
                    ToolbarNode.this.newToolbarSeparator();
                }
            }};
        }

        public void setName(String string, boolean bl) {
            Toolbar toolbar = ToolbarPool.getDefault().findToolbar(this.getName());
            if (toolbar != null) {
                toolbar.setName(string);
            }
            super.setName(string, bl);
        }

        void newToolbarSeparator() {
            try {
                InstanceDataObject instanceDataObject = InstanceDataObject.find((DataFolder)this.folder, null, (String)"javax.swing.JToolBar$Separator");
                String string = this.getLastName();
                Object object = instanceDataObject == null ? InstanceDataObject.create((DataFolder)this.folder, null, (String)"javax.swing.JToolBar$Separator") : instanceDataObject.copy(this.folder);
                if (string != null) {
                    this.folder.getPrimaryFile().setAttribute(string + "/" + object.getPrimaryFile().getNameExt(), (Object)Boolean.TRUE);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private String getLastName() {
            Node node;
            DataObject dataObject;
            String string = null;
            Node[] nodeArray = this.getChildren().getNodes();
            if (nodeArray.length > 0 && (dataObject = (DataObject)(node = nodeArray[nodeArray.length - 1]).getCookie(DataObject.class)) != null) {
                string = dataObject.getPrimaryFile().getNameExt();
            }
            return string;
        }

        public Action[] getActions(boolean bl) {
            if (staticActions == null) {
                staticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(ReorderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return staticActions;
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            set.put((Node.Property)new PropertySupport.Name((Node)this, NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_ToolbarName"), NbBundle.getBundle(ToolbarFolderNode.class).getString("HINT_ToolbarName")));
            set.put((Node.Property)new PropertySupport.ReadWrite<Boolean>("visible", Boolean.class, NbBundle.getBundle(ToolbarFolderNode.class).getString("PROP_ToolbarVisible"), NbBundle.getBundle(ToolbarFolderNode.class).getString("HINT_ToolbarVisible")){

                public void setValue(Boolean bl) {
                    ToolbarNode.this.currentConfiguration().setToolbarVisible(ToolbarPool.getDefault().findToolbar(ToolbarNode.this.folder.getName()), bl);
                }

                public Boolean getValue() {
                    return ToolbarNode.this.currentConfiguration().isToolbarVisible(ToolbarPool.getDefault().findToolbar(ToolbarNode.this.folder.getName())) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            return sheet.toArray();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("configuration".equals(propertyChangeEvent.getPropertyName())) {
                ToolbarConfiguration toolbarConfiguration = this.configuration((String)propertyChangeEvent.getOldValue());
                if (toolbarConfiguration != null && this.wlpc != null) {
                    toolbarConfiguration.removePropertyChangeListener(this.wlpc);
                }
                this.attachConfigListener();
            } else if ("constraints".equals(propertyChangeEvent.getPropertyName())) {
                this.firePropertyChange("visible", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        private void attachConfigListener() {
            ToolbarConfiguration toolbarConfiguration = this.currentConfiguration();
            if (toolbarConfiguration != null) {
                this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)toolbarConfiguration);
                toolbarConfiguration.addPropertyChangeListener(this.wlpc);
            }
        }

        ToolbarConfiguration currentConfiguration() {
            String string = ToolbarPool.getDefault().getConfiguration();
            return this.configuration(string);
        }

        ToolbarConfiguration configuration(String string) {
            DataObject[] dataObjectArray = NbPlaces.getDefault().toolbars().getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                DataObject dataObject = dataObjectArray[i];
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie == null) continue;
                try {
                    ToolbarConfiguration toolbarConfiguration;
                    if (!ToolbarConfiguration.class.isAssignableFrom(instanceCookie.instanceClass()) || !string.equals((toolbarConfiguration = (ToolbarConfiguration)instanceCookie.instanceCreate()).getName())) continue;
                    return toolbarConfiguration;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Exceptions.printStackTrace((Throwable)classNotFoundException);
                }
            }
            return null;
        }
    }
}

